/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSRule;
import org.w3c.dom.DOMException;

public class OMCSSNamespaceRule
extends BaseCSSRule {
    private String namespaceURI = null;
    private String prefix = null;

    public OMCSSNamespaceRule(AbstractCSSStyleSheet parentSheet, short origin, String prefix, String namespaceURI) {
        super(parentSheet, (short)10, origin);
        this.prefix = prefix;
        this.namespaceURI = namespaceURI;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        throw new DOMException(7, "Cannot modify a namespace rule");
    }

    @Override
    public String getCssText() {
        if (this.namespaceURI == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(this.namespaceURI.length() + 32);
        buf.append("@namespace ");
        if (this.prefix != null) {
            buf.append(this.prefix).append(' ');
        }
        buf.append("url('").append(this.namespaceURI).append("');");
        return buf.toString();
    }

    @Override
    public OMCSSNamespaceRule clone(AbstractCSSStyleSheet parentSheet, int insertionIndex) {
        OMCSSNamespaceRule rule = new OMCSSNamespaceRule(parentSheet, this.getOrigin(), this.prefix, this.namespaceURI);
        rule.setInsertionIndex(insertionIndex);
        return rule;
    }
}

