/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.CSSStyleDeclarationRule;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.CSSURIValue;
import io.sf.carte.doc.style.css.property.CSSURIValueWrapper;
import io.sf.carte.doc.style.css.property.OMCSSValueList;
import java.net.MalformedURLException;
import java.net.URL;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSPrimitiveValue;

public class WrappedCSSStyleDeclaration
extends BaseCSSStyleDeclaration {
    private String hrefcontext = null;

    protected WrappedCSSStyleDeclaration(CSSStyleDeclarationRule parentRule) {
        super(parentRule);
        AbstractCSSStyleSheet parentSheet = parentRule.getParentStyleSheet();
        if (parentSheet != null) {
            URL baseurl;
            Node node = parentSheet.getOwnerNode();
            String parentHref = parentSheet.getHref();
            if (parentHref != null) {
                if (!parentHref.contains("://")) {
                    if (node != null) {
                        try {
                            this.hrefcontext = new URL(((CSSDocument)node.getOwnerDocument()).getBaseURL(), parentHref).toExternalForm();
                        }
                        catch (MalformedURLException e) {
                            parentRule.getStyleDeclarationErrorHandler().malformedURIValue(parentHref);
                        }
                    }
                } else {
                    this.hrefcontext = parentHref;
                }
            } else if (node != null && (baseurl = ((CSSDocument)node.getOwnerDocument()).getBaseURL()) != null) {
                this.hrefcontext = baseurl.toExternalForm();
            }
        }
    }

    @Override
    protected AbstractCSSValue getCSSValue(String propertyName) {
        AbstractCSSValue value = super.getCSSValue(propertyName);
        short type = value.getCssValueType();
        if (type == 2) {
            if (this.hrefcontext != null) {
                value = ((OMCSSValueList)value).wrap(this.hrefcontext);
            }
        } else if (type == 1 && ((CSSPrimitiveValue)((Object)value)).getPrimitiveType() == 20 && this.hrefcontext != null) {
            value = new CSSURIValueWrapper((CSSURIValue)value, this.hrefcontext);
        }
        return value;
    }

    @Override
    public BaseCSSStyleDeclaration clone() {
        return new WrappedCSSStyleDeclaration(this.getParentRule());
    }
}

