/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.ColorIdentifiers;
import io.sf.carte.doc.style.css.property.ValueFactory;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.Counter;
import org.w3c.dom.css.RGBColor;
import org.w3c.dom.css.Rect;

public abstract class AbstractCSSPrimitiveValue
extends AbstractCSSValue
implements CSSPrimitiveValue {
    private short primitiveType = 0;
    protected LexicalUnit nextLexicalUnit = null;
    private boolean subproperty = false;

    protected AbstractCSSPrimitiveValue(short unitType) {
        super((short)1);
        this.primitiveType = unitType;
    }

    protected AbstractCSSPrimitiveValue() {
        this(0);
    }

    protected AbstractCSSPrimitiveValue(AbstractCSSPrimitiveValue copied) {
        this(copied.primitiveType);
        this.nextLexicalUnit = copied.nextLexicalUnit;
    }

    @Override
    public short getPrimitiveType() {
        return this.primitiveType;
    }

    @Override
    public void setFloatValue(short unitType, float floatValue) throws DOMException {
        throw new DOMException(15, "Not a Float");
    }

    @Override
    public float getFloatValue(short unitType) throws DOMException {
        throw new DOMException(15, "Not a Float");
    }

    @Override
    public void setStringValue(short stringType, String stringValue) throws DOMException {
        throw new DOMException(15, "Not a String");
    }

    @Override
    public String getStringValue() throws DOMException {
        throw new DOMException(15, "Not a String");
    }

    @Override
    public Counter getCounterValue() throws DOMException {
        throw new DOMException(15, "Not a Counter");
    }

    @Override
    public Rect getRectValue() throws DOMException {
        throw new DOMException(15, "Not a Rect");
    }

    @Override
    public RGBColor getRGBColorValue() throws DOMException {
        String spec;
        if (this.getPrimitiveType() == 21 && (spec = "transparent".equals(this.getStringValue()) ? "rgba(0,0,0,0)" : ColorIdentifiers.getInstance().getColor(this.getStringValue())) != null) {
            ValueFactory factory = new ValueFactory();
            try {
                AbstractCSSValue val = factory.parseProperty(spec);
                if (val.getCssValueType() == 1 && ((CSSPrimitiveValue)((Object)val)).getPrimitiveType() == 25) {
                    return ((CSSPrimitiveValue)((Object)val)).getRGBColorValue();
                }
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        throw new DOMException(15, "Not an RGB Color");
    }

    public void setSubproperty(boolean subp) {
        this.subproperty = subp;
    }

    @Override
    public boolean isSubproperty() {
        return this.subproperty;
    }

    void setCSSUnitType(short cssUnitType) {
        this.primitiveType = cssUnitType;
    }

    boolean isNegativeNumber() {
        return false;
    }

    void setLexicalUnit(LexicalUnit lunit, boolean subp, ValueFactory factory) throws DOMException {
        this.setCSSUnitType(ValueFactory.domPrimitiveType(lunit));
    }

    public LexicalUnit getNextLexicalUnit() {
        return this.nextLexicalUnit;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.primitiveType;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof AbstractCSSPrimitiveValue)) {
            return false;
        }
        AbstractCSSPrimitiveValue other = (AbstractCSSPrimitiveValue)obj;
        return this.primitiveType == other.primitiveType;
    }

    public abstract AbstractCSSPrimitiveValue clone();
}

