/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.property.AbstractCSSPrimitiveValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class CSSStringValue
extends AbstractCSSPrimitiveValue {
    private String stringValue = null;

    public CSSStringValue() {
    }

    protected CSSStringValue(CSSStringValue copied) {
        super(copied);
        this.stringValue = copied.stringValue;
        this.setPlainCssText(copied.getCssText());
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        this.setCSSUnitType((short)19);
        if (this.isSubproperty()) {
            throw new DOMException(7, "This property was set with a shorthand. Must modify at the style-declaration level.");
        }
        String text = cssText;
        int tlm1 = cssText.length() - 1;
        if (tlm1 > 1) {
            char c = cssText.charAt(0);
            char d = cssText.charAt(tlm1);
            if (c == '\'') {
                if (d == '\'') {
                    text = cssText.substring(1, tlm1);
                }
            } else if (c == '\"' && d == '\"') {
                text = cssText.substring(1, tlm1);
            }
        }
        try {
            this.stringValue = ParseHelper.unescapeStringValue(text);
        }
        catch (NumberFormatException e) {
            this.stringValue = text;
        }
        this.setUnescapedCssText(text);
    }

    @Override
    public String getStringValue() throws DOMException {
        return this.stringValue;
    }

    @Override
    public void setStringValue(short stringType, String stringValue) throws DOMException {
        if (this.isSubproperty()) {
            throw new DOMException(7, "This property was set with a shorthand. Must modify at the style-declaration level.");
        }
        this.setCSSUnitType(stringType);
        this.setStringValue(stringValue);
        stringValue = ParseHelper.escapeBackslash(stringValue);
        this.setUnescapedCssText(stringValue);
    }

    protected void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    @Override
    void setLexicalUnit(LexicalUnit lunit, boolean subp, ValueFactory factory) {
        super.setLexicalUnit(lunit, subp, factory);
        String strval = lunit.getStringValue();
        strval = ParseHelper.escapeBackslash(strval);
        this.setUnescapedCssText(strval);
        if (lunit.getLexicalUnitType() == 36) {
            try {
                strval = ParseHelper.unescapeStringValue(strval);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.setStringValue(strval);
        this.nextLexicalUnit = lunit.getNextLexicalUnit();
        this.setSubproperty(subp);
    }

    protected void setUnescapedCssText(String css) throws DOMException {
        boolean hasSingleQuotes;
        boolean useDQ = true;
        boolean hasDoubleQuotes = css.indexOf(34) != -1;
        boolean bl = hasSingleQuotes = css.indexOf(39) != -1;
        if (hasSingleQuotes) {
            if (hasDoubleQuotes) {
                char quote;
                int len = css.length();
                int sqc = 0;
                int dqc = 0;
                for (int i = 0; i < len; ++i) {
                    char c = css.charAt(i);
                    if (c == '\'') {
                        ++sqc;
                        continue;
                    }
                    if (c != '\"') continue;
                    ++dqc;
                }
                if (sqc > dqc) {
                    quote = '\"';
                } else {
                    quote = '\'';
                    useDQ = false;
                }
                StringBuilder buf = new StringBuilder(len + 8);
                for (int i = 0; i < len; ++i) {
                    char c = css.charAt(i);
                    if (c == quote) {
                        buf.append('\\');
                    }
                    buf.append(c);
                }
                css = buf.toString();
            }
        } else if (hasDoubleQuotes) {
            useDQ = false;
        }
        css = CSSStringValue.escapeControl(css);
        if (hasSingleQuotes || hasDoubleQuotes || css.indexOf(32) != -1) {
            if (useDQ) {
                this.setPlainCssText("\"" + css + "\"");
            } else {
                this.setPlainCssText("'" + css + "'");
            }
        } else if (this.getPrimitiveType() == 19) {
            css = ParseHelper.escapeCssChars(css);
            this.setPlainCssText("'" + css + "'");
        } else {
            css = ParseHelper.escapeCssChars(css);
            this.setPlainCssText(css);
        }
    }

    static String escapeControl(String strval) {
        boolean noctrl = true;
        int len = strval.length();
        StringBuilder buf = null;
        for (int i = 0; i < len; ++i) {
            int cp = strval.codePointAt(i);
            if (Character.isISOControl(cp)) {
                if (noctrl) {
                    noctrl = false;
                    buf = new StringBuilder(len + 20);
                    buf.append(strval.subSequence(0, i));
                }
                buf.append('\\').append(Character.forDigit(cp, 16)).append(' ');
                continue;
            }
            if (noctrl) continue;
            buf.append(Character.toChars(cp));
        }
        if (noctrl) {
            return strval;
        }
        return buf.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.stringValue == null ? 0 : this.stringValue.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof CSSStringValue)) {
            return false;
        }
        CSSStringValue other = (CSSStringValue)obj;
        return !(this.stringValue == null ? other.stringValue != null : !this.getCssText().equals(other.getCssText()));
    }

    @Override
    public CSSStringValue clone() {
        return new CSSStringValue(this);
    }
}

