/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.ColorIdentifiers;
import io.sf.carte.doc.style.css.property.ValueFactory;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public final class PropertyDatabase {
    private ClassLoader classLoader = null;
    private ValueFactory valueFactory = new ValueFactory();
    private Set<String> inherited_properties;
    private Map<String, String[]> shorthand2subp = new HashMap<String, String[]>();
    private Map<String, String> subp2shorthand = new HashMap<String, String>();
    private Properties identifiers;
    private Map<String, AbstractCSSValue> initialValueMap;
    private static PropertyDatabase singleton = new PropertyDatabase();

    protected PropertyDatabase() {
        this.inherited_properties = this.computeInheritedPropertiesList();
        Properties shand = this.loadPropertiesfromClasspath("shorthand.properties");
        ArrayList<String> array = new ArrayList<String>();
        for (Map.Entry<Object, Object> me : shand.entrySet()) {
            String shname = (String)me.getKey();
            String subpties = (String)me.getValue();
            StringTokenizer st = new StringTokenizer(subpties, ",");
            while (st.hasMoreTokens()) {
                array.add(st.nextToken().trim());
            }
            this.addShorthand(shname, array.toArray(new String[0]));
            array.clear();
        }
        this.identifiers = this.loadPropertiesfromClasspath("identifier.properties");
        this.initialValueMap = this.computeInitialValueMap();
    }

    public static PropertyDatabase getInstance() {
        return singleton;
    }

    public boolean isInherited(String name) {
        return this.inherited_properties.contains(name);
    }

    protected Set<String> computeInheritedPropertiesList() {
        String[] inherit = new String[]{"azimuth", "border-collapse", "border-spacing", "caption-side", "color", "cursor", "direction", "elevation", "empty-cells", "font-family", "font-max-size", "font-min-size", "font-size", "font-size-adjust", "font-style", "font-stretch", "font-synthesis", "font-variant", "font-weight", "font", "letter-spacing", "line-height", "list-style-image", "list-style-position", "list-style-type", "list-style", "orphans", "page-break-inside", "pitch-range", "pitch", "quotes", "richness", "speak-header", "speak-numeral", "speak-punctuation", "speak", "speech-rate", "stress", "text-align", "text-emphasis-color", "text-emphasis-position", "text-emphasis-style", "text-indent", "text-shadow", "text-transform", "text-underline-position", "visibility", "voice-family", "volume", "white-space", "widows", "word-spacing"};
        return new HashSet<String>(Arrays.asList(inherit));
    }

    public AbstractCSSValue getInitialValue(String propertyName) {
        return this.initialValueMap.get(propertyName);
    }

    protected Map<String, AbstractCSSValue> computeInitialValueMap() {
        String[][] initialArray = new String[][]{{"azimuth", "center"}, {"background-attachment", "scroll"}, {"background-clip", "border-box"}, {"background-color", "transparent"}, {"background-image", "none"}, {"background-origin", "padding-box"}, {"background-position", "0% 0%"}, {"background-repeat", "repeat"}, {"background-size", "auto"}, {"border-collapse", "separate"}, {"border-spacing", "0"}, {"border-top-style", "none"}, {"border-right-style", "none"}, {"border-bottom-style", "none"}, {"border-left-style", "none"}, {"border-top-width", "medium"}, {"border-right-width", "medium"}, {"border-bottom-width", "medium"}, {"border-left-width", "medium"}, {"border-image-outset", "0"}, {"border-image-repeat", "stretch"}, {"border-image-slice", "100%"}, {"border-image-source", "none"}, {"border-image-width", "1"}, {"border-top-left-radius", "0"}, {"border-top-right-radius", "0"}, {"border-bottom-right-radius", "0"}, {"border-bottom-left-radius", "0"}, {"bottom", "auto"}, {"box-decoration-break", "slice"}, {"box-shadow", "none"}, {"caption-side", "top"}, {"clear", "none"}, {"content", "normal"}, {"counter-increment", "none"}, {"counter-reset", "none"}, {"cue-after", "none"}, {"cue-before", "none"}, {"cursor", "auto"}, {"direction", "ltr"}, {"display", "inline"}, {"elevation", "level"}, {"empty-cells", "show"}, {"float", "none"}, {"font-min-size", "0"}, {"font-size", "medium"}, {"font-size-adjust", "none"}, {"font-stretch", "normal"}, {"font-style", "normal"}, {"font-synthesis", "weight style"}, {"font-variant", "normal"}, {"font-variant-east-asian", "normal"}, {"font-weight", "normal"}, {"height", "auto"}, {"left", "auto"}, {"letter-spacing", "normal"}, {"line-height", "normal"}, {"list-style-image", "none"}, {"list-style-position", "outside"}, {"list-style-type", "disc"}, {"margin-right", "0"}, {"margin-left", "0"}, {"margin-top", "0"}, {"margin-bottom", "0"}, {"max-height", "none"}, {"max-width", "none"}, {"min-height", "0"}, {"min-width", "0"}, {"opacity", "1"}, {"orphans", "2"}, {"outline-color", "invert"}, {"outline-style", "none"}, {"outline-width", "medium"}, {"overflow", "visible"}, {"padding-top", "0"}, {"padding-right", "0"}, {"padding-bottom", "0"}, {"padding-left", "0"}, {"page-break-after", "auto"}, {"page-break-before", "auto"}, {"page-break-inside", "auto"}, {"pause-after", "0"}, {"pause-before", "0"}, {"pitch-range", "50"}, {"pitch", "medium"}, {"play-during", "auto"}, {"position", "static"}, {"richness", "50"}, {"right", "auto"}, {"speak-header", "once"}, {"speak-numeral", "continuous"}, {"speak-punctuation", "none"}, {"speak", "normal"}, {"speech-rate", "medium"}, {"stress", "50"}, {"table-layout", "auto"}, {"text-decoration-line", "none"}, {"text-decoration-style", "solid"}, {"text-emphasis-style", "none"}, {"text-emphasis-position", "over right"}, {"text-indent", "0"}, {"text-transform", "none"}, {"text-shadow", "none"}, {"text-underline-position", "auto"}, {"top", "auto"}, {"transition-property", "all"}, {"transition-duration", "0s"}, {"transition-timing-function", "ease"}, {"transition-delay", "0s"}, {"unicode-bidi", "normal"}, {"vertical-align", "baseline"}, {"visibility", "visible"}, {"voice-family", "male"}, {"volume", "medium"}, {"white-space", "normal"}, {"widows", "2"}, {"width", "auto"}, {"word-spacing", "normal"}, {"z-index", "auto"}};
        HashMap<String, AbstractCSSValue> initialValueMap = new HashMap<String, AbstractCSSValue>(initialArray.length);
        for (int i = 0; i < initialArray.length; ++i) {
            AbstractCSSValue value = this.valueFactory.parseProperty(initialArray[i][1]);
            initialValueMap.put(initialArray[i][0], value);
        }
        return initialValueMap;
    }

    public boolean isKnownProperty(String name) {
        return this.initialValueMap.keySet().contains(name);
    }

    public boolean isShorthand(String name) {
        return this.shorthand2subp.containsKey(name);
    }

    public boolean isShorthandSubproperty(String name) {
        return this.subp2shorthand.containsKey(name);
    }

    public String getShorthand(String subproperty) {
        return this.subp2shorthand.get(subproperty);
    }

    public boolean isShorthandSubpropertyOf(String shorthand, String subpName) {
        String sh = this.subp2shorthand.get(subpName);
        if (sh == null) {
            return false;
        }
        if (sh.equals(shorthand)) {
            return true;
        }
        if (shorthand.equals(sh = this.subp2shorthand.get(sh))) {
            return true;
        }
        String[] subp = this.shorthand2subp.get(shorthand);
        for (int i = 0; i < subp.length; ++i) {
            if (!subp[i].equals(subpName)) continue;
            return true;
        }
        return false;
    }

    public String[] getShorthandSubproperties(String shorthandName) {
        return this.shorthand2subp.get(shorthandName);
    }

    protected void addShorthand(String shorthand, String[] subproperties) {
        this.shorthand2subp.put(shorthand, subproperties);
        for (int i = 0; i < subproperties.length; ++i) {
            String prevSh = this.subp2shorthand.get(subproperties[i]);
            if (prevSh != null) {
                String topShorthand = this.subp2shorthand.get(shorthand);
                String topPrevSh = this.subp2shorthand.get(prevSh);
                if (topShorthand == null) {
                    if (topPrevSh != null) {
                        this.subp2shorthand.put(shorthand, topPrevSh);
                    }
                } else if (topPrevSh == null) {
                    this.subp2shorthand.put(prevSh, topShorthand);
                }
            }
            this.subp2shorthand.put(subproperties[i], shorthand);
        }
    }

    public boolean isIdentifierValue(String propertyName, String value) {
        String csl = this.identifiers.getProperty(propertyName);
        if (csl == null) {
            if (propertyName.endsWith("-color")) {
                return ColorIdentifiers.getInstance().getColor(value) != null || "transparent".equals(value);
            }
            return false;
        }
        StringTokenizer tokp = new StringTokenizer(csl, ",");
        while (tokp.hasMoreTokens()) {
            String s = tokp.nextToken();
            if (!s.trim().equals(value)) continue;
            return true;
        }
        return false;
    }

    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    Properties loadPropertiesfromClasspath(final String filename) {
        return AccessController.doPrivileged(new PrivilegedAction<Properties>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Properties run() {
                InputStream is = PropertyDatabase.this.classLoader != null ? PropertyDatabase.this.classLoader.getResourceAsStream(PropertyDatabase.this.resourcePath(filename)) : this.getClass().getResourceAsStream(PropertyDatabase.this.resourcePath(filename));
                if (is == null) {
                    return null;
                }
                Properties p = new Properties();
                try {
                    p.load(is);
                }
                catch (IOException e) {
                    Properties properties = null;
                    return properties;
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                return p;
            }
        });
    }

    protected String resourcePath(String filename) {
        return '/' + PropertyDatabase.class.getPackage().getName().replace('.', '/') + '/' + filename;
    }
}

