/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css;

import io.sf.carte.doc.style.css.ErrorHandler;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleSheet;

public class LogErrorHandler
implements ErrorHandler {
    static Logger log = LoggerFactory.getLogger((String)LogErrorHandler.class.getName());

    @Override
    public void onException(Exception e, Element elt) {
        log.error(elt.toString(), (Throwable)e);
    }

    @Override
    public void onException(Exception e, CSSStyleSheet sheet) {
        String href = sheet.getHref();
        if (href != null) {
            log.error("Error parsing sheet at " + href);
        }
        log.error(((AbstractCSSStyleSheet)sheet).toStyleString(), (Throwable)e);
    }

    @Override
    public void onException(Exception e, String context) {
        log.error(context, (Throwable)e);
    }

    @Override
    public void mediaQueryError(String media) {
        log.error("Error parsing media text: " + media);
    }
}

