/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.OrderedShorthandBuilder;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.OMCSSValueList;
import java.util.Set;
import org.w3c.dom.css.CSSPrimitiveValue;

class AnimationShorthandBuilder
extends OrderedShorthandBuilder {
    AnimationShorthandBuilder(BaseCSSStyleDeclaration parentStyle) {
        super("animation", parentStyle, "none", "animation-name");
    }

    @Override
    boolean appendShorthandSet(StringBuilder buf, Set<String> declaredSet, boolean important) {
        OMCSSValueList masterList;
        AbstractCSSValue masterValue = this.getCSSValue("animation-name");
        if (masterValue.getCssValueType() != 2 || !(masterList = (OMCSSValueList)masterValue).isCommaSeparated()) {
            return super.appendShorthandSet(buf, declaredSet, important);
        }
        int listLen = masterList.getLength();
        if (this.checkDeclaredValueListForInherit(declaredSet, listLen)) {
            return false;
        }
        if (this.checkDeclaredValueListForKeyword("unset", declaredSet, listLen)) {
            return false;
        }
        for (String property : declaredSet) {
            if (!this.invalidListValueClash(declaredSet, property, (OMCSSValueList)this.getCSSValue(property))) continue;
            return false;
        }
        buf.append(this.getShorthandName()).append(':');
        for (int index = 0; index < listLen; ++index) {
            if (index != 0) {
                buf.append(',');
            }
            boolean appended = false;
            String[] subp = this.getSubproperties();
            for (int i = 0; i < subp.length; ++i) {
                String property = subp[i];
                if (!declaredSet.contains(property)) continue;
                appended = this.appendValueText(index, buf, property, appended);
            }
            if (appended) continue;
            buf.append(this.initialvalue);
        }
        this.appendPriority(buf, important);
        return true;
    }

    boolean checkDeclaredValueListForInherit(Set<String> declaredSet, int listLen) {
        for (String propertyName : declaredSet) {
            OMCSSValueList list = this.computeCSSItemList(propertyName, listLen - 1);
            for (int i = 0; i < listLen; ++i) {
                if (!this.isInherit(list.item(i))) continue;
                return true;
            }
        }
        return false;
    }

    boolean checkDeclaredValueListForKeyword(String keyword, Set<String> declaredSet, int listLen) {
        for (String propertyName : declaredSet) {
            OMCSSValueList list = this.computeCSSItemList(propertyName, listLen - 1);
            for (int i = 0; i < listLen; ++i) {
                if (!this.isCssKeywordValue(keyword, list.item(i))) continue;
                return true;
            }
        }
        return false;
    }

    boolean invalidListValueClash(Set<String> declaredSet, String property, OMCSSValueList list) {
        int len = list.getLength();
        for (int i = 0; i < len; ++i) {
            if (!this.invalidValueClash(declaredSet, property, list.item(i))) continue;
            return true;
        }
        return false;
    }

    boolean appendValueText(int index, StringBuilder buf, String property, boolean appended) {
        AbstractCSSValue cssVal = this.getCSSListItemValue(property, index);
        if (this.isNotInitialValue(cssVal, property) || !this.freeProperty.equals(property) && this.valueClash(index, property)) {
            if (appended) {
                buf.append(' ');
            }
            buf.append(cssVal.getMinifiedCssText(property));
            return true;
        }
        return appended;
    }

    AbstractCSSValue getCSSListItemValue(String propertyName, int index) {
        return this.computeCSSItemList(propertyName, index).item(index);
    }

    OMCSSValueList computeCSSItemList(String propertyName, int lastIdx) {
        int items;
        OMCSSValueList list;
        AbstractCSSValue value = this.getCSSValue(propertyName);
        if (value.getCssValueType() == 2 && ((OMCSSValueList)value).isCommaSeparated()) {
            list = (OMCSSValueList)value.clone();
            items = list.getLength();
        } else {
            list = OMCSSValueList.createCSValueList();
            list.add(value);
            value = list;
            items = 1;
        }
        if (lastIdx >= items) {
            int j = 0;
            while (items++ < lastIdx) {
                list.add(list.item(j++));
            }
        }
        return list;
    }

    boolean valueClash(int index, String property) {
        AbstractCSSValue delay;
        boolean retval;
        String chkProperty = property;
        if ("animation-timing-function".equals(property)) {
            chkProperty = "transition-timing-function";
        }
        AbstractCSSValue freePropertyValue = this.getCSSListItemValue(this.freeProperty, index);
        String freePropertyStringValue = null;
        if (freePropertyValue.getCssValueType() == 1 && ((CSSPrimitiveValue)((Object)freePropertyValue)).getPrimitiveType() == 21) {
            freePropertyStringValue = ((CSSPrimitiveValue)((Object)freePropertyValue)).getStringValue();
        }
        boolean bl = retval = freePropertyStringValue != null && this.pdb.isIdentifierValue(chkProperty, freePropertyStringValue);
        if (!retval && property.equals("animation-duration") && this.isNotInitialValue(delay = this.getCSSListItemValue("animation-delay", index), "animation-delay")) {
            retval = true;
        }
        return retval;
    }

    @Override
    boolean validValueClash(String property) {
        AbstractCSSValue delay;
        boolean retval;
        String chkProperty = property;
        if ("animation-timing-function".equals(property)) {
            chkProperty = "transition-timing-function";
        }
        if (!(retval = super.validValueClash(chkProperty)) && property.equals("animation-duration") && this.isNotInitialValue(delay = this.getCSSValue("animation-delay"), "animation-delay")) {
            retval = true;
        }
        return retval;
    }
}

