/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.om.BaseBoxShorthandBuilder;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import java.util.Set;
import org.w3c.dom.css.CSSPrimitiveValue;

class BoxShorthandBuilder
extends BaseBoxShorthandBuilder {
    private final String topProperty;
    private final String rightProperty;
    private final String bottomProperty;
    private final String leftProperty;
    private byte keyword_state_top = 0;
    private byte keyword_state_bottom = 0;
    private byte keyword_state_left = 0;
    private byte keyword_state_right = 0;
    private boolean appended = false;

    BoxShorthandBuilder(String shorthandName, BaseCSSStyleDeclaration parentStyle) {
        super(shorthandName, parentStyle);
        this.topProperty = shorthandName + "-top";
        this.rightProperty = shorthandName + "-right";
        this.bottomProperty = shorthandName + "-bottom";
        this.leftProperty = shorthandName + "-left";
    }

    @Override
    int getMinimumSetSize() {
        return 4;
    }

    private int sameValueScore(Set<String> declaredSet, byte live_state) {
        AbstractCSSValue topv = this.getCSSValue(this.topProperty);
        AbstractCSSValue bottomv = this.getCSSValue(this.bottomProperty);
        AbstractCSSValue leftv = this.getCSSValue(this.leftProperty);
        AbstractCSSValue rightv = this.getCSSValue(this.rightProperty);
        int score = 0;
        if (!declaredSet.contains(this.leftProperty) || this.keyword_state_left != live_state) {
            leftv = null;
        }
        if (!declaredSet.contains(this.rightProperty) || this.keyword_state_right != live_state) {
            rightv = null;
        }
        if (!declaredSet.contains(this.bottomProperty) || this.keyword_state_bottom != live_state) {
            bottomv = null;
        }
        if (!declaredSet.contains(this.topProperty) || this.keyword_state_top != live_state) {
            topv = null;
        }
        if (leftv == null || rightv == null || this.valueEquals(leftv, rightv)) {
            score += 16;
        }
        if (topv == null || bottomv == null || this.valueEquals(topv, bottomv)) {
            score += 4;
        }
        if (topv == null) {
            topv = bottomv;
        }
        if (leftv == null) {
            leftv = rightv;
        }
        if (topv == null || leftv == null || this.valueEquals(topv, leftv)) {
            ++score;
        }
        return score;
    }

    @Override
    boolean appendShorthandSet(StringBuilder buf, Set<String> declaredSet, boolean important) {
        this.keyword_state_top = this.keywordState(this.getCSSValue(this.topProperty));
        this.keyword_state_bottom = this.keywordState(this.getCSSValue(this.bottomProperty));
        this.keyword_state_left = this.keywordState(this.getCSSValue(this.leftProperty));
        this.keyword_state_right = this.keywordState(this.getCSSValue(this.rightProperty));
        int keyword_state = this.keyword_state_top + this.keyword_state_bottom + this.keyword_state_left + this.keyword_state_right;
        byte best_state = 0;
        int inherit_count = keyword_state % 5;
        if (inherit_count > 1) {
            best_state = 1;
        } else if (keyword_state >= 10) {
            best_state = 5;
        }
        if (keyword_state == 0 || keyword_state == 4 || keyword_state == 20) {
            return this.appendPropertyBoxText(buf, declaredSet, important, best_state);
        }
        if (!this.appendPropertyBoxText(buf, declaredSet, important, best_state)) {
            return false;
        }
        if (declaredSet.contains(this.bottomProperty) && this.keyword_state_bottom != best_state) {
            this.appendIndividualProperty(buf, this.bottomProperty, important);
        }
        if (declaredSet.contains(this.leftProperty) && this.keyword_state_left != best_state) {
            this.appendIndividualProperty(buf, this.leftProperty, important);
        }
        if (declaredSet.contains(this.rightProperty) && this.keyword_state_right != best_state) {
            this.appendIndividualProperty(buf, this.rightProperty, important);
        }
        if (declaredSet.contains(this.topProperty) && this.keyword_state_top != best_state) {
            this.appendIndividualProperty(buf, this.topProperty, important);
        }
        return true;
    }

    private void appendIndividualProperty(StringBuilder buf, String propertyName, boolean important) {
        buf.append(propertyName).append(':');
        BaseCSSStyleDeclaration.appendMinifiedCssText(buf, this.getCSSValue(propertyName), propertyName);
        this.appendPriority(buf, important);
    }

    private boolean appendPropertyBoxText(StringBuilder buf, Set<String> declaredSet, boolean important, byte live_state) {
        buf.append(this.getShorthandName()).append(':');
        this.appended = false;
        switch (this.sameValueScore(declaredSet, live_state)) {
            case 21: {
                String property = this.topProperty;
                if (!(declaredSet.contains(property) && this.keyword_state_top == live_state || declaredSet.contains(property = this.bottomProperty) && this.keyword_state_bottom == live_state || declaredSet.contains(property = this.rightProperty) && this.keyword_state_right == live_state || declaredSet.contains(property = this.leftProperty) && this.keyword_state_left == live_state)) {
                    buf.append('0');
                    break;
                }
                if (!this.appendValueIfSaneAndNotInitial(buf, property)) {
                    return false;
                }
                if (this.appended) break;
                buf.append('0');
                break;
            }
            case 20: {
                String property = this.topProperty;
                if (!(declaredSet.contains(property) && this.keyword_state_top == live_state || declaredSet.contains(property = this.bottomProperty) && this.keyword_state_bottom == live_state)) {
                    buf.append('0');
                    this.appended = true;
                }
                if (!this.appended && !this.appendValueIfSaneAndNotInitial(buf, property)) {
                    return false;
                }
                if (!this.appended) {
                    buf.append('0');
                } else {
                    this.appended = false;
                }
                buf.append(' ');
                property = this.leftProperty;
                if (!(declaredSet.contains(property) && this.keyword_state_left == live_state || declaredSet.contains(property = this.rightProperty) && this.keyword_state_right == live_state)) {
                    buf.append('0');
                    this.appended = true;
                }
                if (!this.appended && !this.appendValueIfSaneAndNotInitial(buf, property)) {
                    return false;
                }
                if (this.appended) break;
                buf.append('0');
                break;
            }
            case 16: 
            case 17: {
                if (declaredSet.contains(this.topProperty) && this.keyword_state_top == live_state && !this.appendValueIfSaneAndNotInitial(buf, this.topProperty)) {
                    return false;
                }
                if (!this.appended) {
                    buf.append('0');
                } else {
                    this.appended = false;
                }
                buf.append(' ');
                String property = this.leftProperty;
                if (!(declaredSet.contains(property) && this.keyword_state_left == live_state || declaredSet.contains(property = this.rightProperty) && this.keyword_state_right == live_state)) {
                    buf.append('0');
                    this.appended = true;
                }
                if (!this.appended && !this.appendValueIfSaneAndNotInitial(buf, property)) {
                    return false;
                }
                if (!this.appended) {
                    buf.append('0');
                } else {
                    this.appended = false;
                }
                buf.append(' ');
                if (declaredSet.contains(this.bottomProperty) && this.keyword_state_bottom == live_state && !this.appendValueIfSaneAndNotInitial(buf, this.bottomProperty)) {
                    return false;
                }
                if (this.appended) break;
                buf.append('0');
                break;
            }
            default: {
                if (declaredSet.contains(this.topProperty) && this.keyword_state_top == live_state && !this.appendValueIfSaneAndNotInitial(buf, this.topProperty)) {
                    return false;
                }
                if (!this.appended) {
                    buf.append('0');
                } else {
                    this.appended = false;
                }
                buf.append(' ');
                if (declaredSet.contains(this.rightProperty) && this.keyword_state_right == live_state && !this.appendValueIfSaneAndNotInitial(buf, this.rightProperty)) {
                    return false;
                }
                if (!this.appended) {
                    buf.append('0');
                } else {
                    this.appended = false;
                }
                buf.append(' ');
                if (declaredSet.contains(this.bottomProperty) && this.keyword_state_bottom == live_state && !this.appendValueIfSaneAndNotInitial(buf, this.bottomProperty)) {
                    return false;
                }
                if (!this.appended) {
                    buf.append('0');
                } else {
                    this.appended = false;
                }
                buf.append(' ');
                if (declaredSet.contains(this.leftProperty) && this.keyword_state_left == live_state && !this.appendValueIfSaneAndNotInitial(buf, this.leftProperty)) {
                    return false;
                }
                if (this.appended) break;
                buf.append('0');
            }
        }
        this.appendPriority(buf, important);
        return true;
    }

    private boolean appendValueIfSaneAndNotInitial(StringBuilder buf, String propertyName) {
        AbstractCSSValue cssVal = this.getCSSValue(propertyName);
        short type = cssVal.getCssValueType();
        if (type != 2) {
            if (type == 1) {
                CSSPrimitiveValue primi = (CSSPrimitiveValue)((Object)cssVal);
                short ptype = primi.getPrimitiveType();
                if (ptype != 19) {
                    String s;
                    if (!(ptype != 21 || (s = primi.getStringValue()).equalsIgnoreCase("auto") || s.equalsIgnoreCase("initial") || s.equalsIgnoreCase("unset"))) {
                        return false;
                    }
                    if (this.isNotInitialValue(cssVal, propertyName)) {
                        if (this.appended) {
                            buf.append(' ');
                        }
                        buf.append(cssVal.getMinifiedCssText(propertyName));
                        this.appended = true;
                    }
                }
            } else if (type == 0) {
                if (this.appended) {
                    buf.append(' ');
                }
                buf.append("inherit");
                this.appended = true;
            }
            return true;
        }
        return false;
    }
}

