/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.BaseDocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.doc.style.css.om.DOMCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.InlineStyle;
import java.util.Iterator;
import org.w3c.dom.DOMException;

public abstract class DOMDocumentCSSStyleSheet
extends BaseDocumentCSSStyleSheet {
    private CSSDocument ownerNode = null;

    public DOMDocumentCSSStyleSheet(byte origin) {
        super(null, origin);
    }

    protected DOMDocumentCSSStyleSheet(String medium, byte origin) {
        super(medium, origin);
    }

    @Override
    public CSSDocument getOwnerNode() {
        return this.ownerNode;
    }

    @Override
    public void setOwnerDocument(CSSDocument ownerNode) {
        this.ownerNode = ownerNode;
    }

    @Override
    public ComputedCSSStyle getComputedStyle(CSSElement elm, String pseudoElt) {
        InlineStyle inline = this.getStyleSheetFactory().createInlineStyle(elm);
        String st = elm.getAttribute("style");
        if (st.length() > 0) {
            try {
                inline.setCssText(st);
            }
            catch (DOMException e) {
                this.getErrorHandler().inlineStyleError(e, elm, st);
                inline = null;
            }
        }
        DOMCSSStyleDeclaration style = this.createComputedCSSStyle(this);
        style.setOwnerNode(elm);
        return this.computeStyle(style, elm.getSelectorMatcher(), pseudoElt, inline);
    }

    public abstract DOMCSSStyleDeclaration createComputedCSSStyle(BaseCSSStyleSheet var1);

    protected abstract DOMDocumentCSSStyleSheet createDocumentStyleSheet(String var1, byte var2);

    @Override
    public abstract BaseCSSStyleSheetFactory getStyleSheetFactory();

    @Override
    public DOMDocumentCSSStyleSheet clone() {
        DOMDocumentCSSStyleSheet myClone = this.createDocumentStyleSheet(this.getTargetMedium(), this.getOrigin());
        myClone.setOwnerDocument(this.ownerNode);
        myClone.currentInsertionIndex = this.currentInsertionIndex;
        myClone.setDisabled(this.getDisabled());
        myClone.namespaces = this.namespaces;
        myClone.setParentStyleSheet(this.getParentStyleSheet());
        myClone.cssRules = new CSSRuleArrayList(this.cssRules.getLength());
        Iterator it = this.cssRules.iterator();
        while (it.hasNext()) {
            myClone.cssRules.add(((AbstractCSSRule)it.next()).clone(myClone));
        }
        return myClone;
    }

    @Override
    public DOMDocumentCSSStyleSheet clone(String targetMedium) {
        DOMDocumentCSSStyleSheet myClone = this.createDocumentStyleSheet(targetMedium, this.getOrigin());
        myClone.setOwnerDocument(this.ownerNode);
        this.copyTo(myClone);
        return myClone;
    }
}

