/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.agent.CSSCanvas;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.SelectorMatcher;
import io.sf.carte.doc.style.css.om.AbstractSelectorMatcher;
import java.util.Locale;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.SiblingSelector;
import org.w3c.css.sac.SimpleSelector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMSelectorMatcher
extends AbstractSelectorMatcher {
    CSSElement element;

    public DOMSelectorMatcher(CSSElement elm) {
        this.element = elm;
        String name = elm.getLocalName();
        if (name == null) {
            name = elm.getTagName();
        }
        if (name != null) {
            name = name.toLowerCase(Locale.US).intern();
        }
        this.setLocalName(name);
    }

    @Override
    protected AbstractSelectorMatcher getParentSelectorMatcher() {
        Node parent = this.element.getParentNode();
        if (parent.getNodeType() == 1) {
            return (AbstractSelectorMatcher)((CSSElement)parent).getSelectorMatcher();
        }
        return null;
    }

    @Override
    protected AbstractSelectorMatcher getPreviousSiblingSelectorMatcher() {
        for (Node sibling = this.element.getPreviousSibling(); sibling != null; sibling = sibling.getPreviousSibling()) {
            if (sibling.getNodeType() != 1) continue;
            return (AbstractSelectorMatcher)((CSSElement)sibling).getSelectorMatcher();
        }
        return null;
    }

    @Override
    protected int indexOf(SelectorList selectors) {
        NodeList list = this.element.getParentNode().getChildNodes();
        int sz = list.getLength();
        int idx = 0;
        for (int i = 0; i < sz; ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1 || !this.matchSelectors(selectors, (CSSElement)node)) continue;
            ++idx;
            if (node == this.element) break;
        }
        return idx == sz ? -1 : idx;
    }

    @Override
    protected int reverseIndexOf(SelectorList selectors) {
        NodeList list = this.element.getParentNode().getChildNodes();
        int sz = list.getLength();
        int idx = 0;
        for (int i = sz - 1; i >= 0; --i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1 || !this.matchSelectors(selectors, (CSSElement)node)) continue;
            ++idx;
            if (node == this.element) break;
        }
        return idx;
    }

    private boolean matchSelectors(SelectorList selectors, CSSElement element) {
        if (selectors == null) {
            return true;
        }
        DOMSelectorMatcher matcher = new DOMSelectorMatcher(element);
        int sz = selectors.getLength();
        for (int i = 0; i < sz; ++i) {
            if (!matcher.matches(selectors.item(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isActivePseudoClass(String pseudoclassName) {
        CSSCanvas canvas;
        Document doc = this.element.getOwnerDocument();
        if (doc != null && (canvas = doc.getCanvas()) != null) {
            return canvas.isActivePseudoClass(this.element, pseudoclassName);
        }
        return false;
    }

    @Override
    protected boolean isFirstChild() {
        for (Node sibling = this.element.getPreviousSibling(); sibling != null; sibling = sibling.getPreviousSibling()) {
            if (sibling.getNodeType() != 1) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean isLastChild() {
        for (Node sibling = this.element.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
            if (sibling.getNodeType() != 1) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean isFirstOfType() {
        for (Node sibling = this.element.getPreviousSibling(); sibling != null; sibling = sibling.getPreviousSibling()) {
            if (sibling.getNodeType() != 1 || !this.getLocalName().equals(sibling.getNodeName())) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean isLastOfType() {
        for (Node sibling = this.element.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
            if (sibling.getNodeType() != 1 || !this.getLocalName().equals(sibling.getNodeName())) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean isNthOfType(int step, int offset) {
        NodeList list = this.element.getParentNode().getChildNodes();
        int sz = list.getLength();
        int idx = 0;
        for (int i = 0; i < sz; ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1 || !this.getLocalName().equals(node.getNodeName())) continue;
            ++idx;
            if (node == this.element) break;
        }
        return step == 0 ? idx == 0 : Math.floorMod(idx -= offset, step) == 0;
    }

    @Override
    protected boolean isNthLastOfType(int step, int offset) {
        NodeList list = this.element.getParentNode().getChildNodes();
        int sz = list.getLength();
        int idx = 0;
        for (int i = sz - 1; i >= 0; --i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1 || !this.getLocalName().equals(node.getNodeName())) continue;
            ++idx;
            if (node == this.element) break;
        }
        return step == 0 ? idx == 0 : Math.floorMod(idx -= offset, step) == 0;
    }

    @Override
    protected boolean isNotVisitedLink() {
        String href = this.element.getAttribute("href");
        if (href.length() != 0) {
            return !this.element.getOwnerDocument().isVisitedURI(href);
        }
        return false;
    }

    @Override
    protected boolean isVisitedLink() {
        String href = this.element.getAttribute("href");
        if (href.length() != 0) {
            return this.element.getOwnerDocument().isVisitedURI(href);
        }
        return false;
    }

    @Override
    protected boolean isTarget() {
        int len;
        int idx;
        String uri = this.element.getOwnerDocument().getDocumentURI();
        return uri != null && (idx = uri.lastIndexOf(35)) != -1 && ++idx < (len = uri.length()) && this.getId().equals(uri.subSequence(idx, len));
    }

    @Override
    protected boolean isRoot() {
        return this.element.getOwnerDocument().getDocumentElement().isSameNode(this.element);
    }

    @Override
    protected boolean isEmpty() {
        if (this.element.hasChildNodes()) {
            NodeList list = this.element.getChildNodes();
            int sz = list.getLength();
            for (int i = 0; i < sz; ++i) {
                String value;
                Node node = list.item(i);
                short type = node.getNodeType();
                if (type == 1) {
                    return false;
                }
                if (!(type == 3 ? (value = node.getNodeValue()) != null && value.length() > 0 : type == 5 && node.hasChildNodes())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean isBlank() {
        if (this.element.hasChildNodes()) {
            NodeList list = this.element.getChildNodes();
            int sz = list.getLength();
            for (int i = 0; i < sz; ++i) {
                String value;
                Node node = list.item(i);
                short type = node.getNodeType();
                if (type == 1) {
                    return false;
                }
                if (!(type == 3 ? (value = node.getNodeValue()) != null && !((Text)node).isElementContentWhitespace() : type == 5 && node.hasChildNodes())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean isDisabled() {
        if (this.element.hasAttribute("disabled")) {
            return true;
        }
        Node parent = this.element.getParentNode();
        if (parent != null && parent.getNodeType() == 1 && "fieldset".equals(parent.getNodeName()) && !"legend".equals(this.getLocalName())) {
            return ((CSSElement)parent).hasAttribute("disabled");
        }
        return false;
    }

    @Override
    protected boolean isDefaultButton() {
        Node parent = this.element.getParentNode();
        if (parent == null) {
            return false;
        }
        while (parent != null && parent.getNodeType() == 1 && !"form".equals(((CSSElement)parent).getTagName())) {
            parent = parent.getParentNode();
        }
        String formid = parent == null ? null : ((CSSElement)parent).getId();
        Node sibling = this.element.getPreviousSibling();
        while (sibling != null) {
            if (sibling.getNodeType() != 1) continue;
            CSSElement element = (CSSElement)sibling;
            if (!DOMSelectorMatcher.defaultButtonCheck(element, formid)) {
                return false;
            }
            if (element.hasChildNodes()) {
                NodeList list = element.getChildNodes();
                int sz = list.getLength();
                for (int i = 0; i < sz; ++i) {
                    Node node = list.item(i);
                    if (node.getNodeType() != 1 || DOMSelectorMatcher.defaultButtonCheck((CSSElement)node, formid)) continue;
                    return false;
                }
            }
            sibling = sibling.getPreviousSibling();
        }
        return true;
    }

    private static boolean defaultButtonCheck(CSSElement element, String formid) {
        String type;
        String tagname;
        String form;
        return element.hasAttribute("disabled") || (form = element.getAttribute("form")) != null && !form.equals(formid) || !((tagname = element.getTagName().toLowerCase(Locale.US)).equals("input") ? "submit".equals(type = element.getAttribute("type")) || "image".equals(type) : tagname.equals("button") && "submit".equals(element.getAttribute("type")));
    }

    @Override
    protected String getNamespaceURI() {
        return this.element.getNamespaceURI();
    }

    @Override
    protected String getAttributeValue(String attrName) {
        return this.element.getAttribute(attrName);
    }

    @Override
    protected boolean hasAttribute(String attrName) {
        return this.element.hasAttribute(attrName);
    }

    @Override
    protected String getLanguage() {
        String lang = this.element.getAttribute("lang");
        Node parent = this.element;
        while (lang.length() == 0 && (parent = parent.getParentNode()) != null) {
            if (!(parent instanceof Element)) continue;
            lang = ((Element)parent).getAttribute("lang");
        }
        return lang;
    }

    @Override
    protected boolean scopeMatchChild(DescendantSelector selector) {
        SimpleSelector desc = selector.getSimpleSelector();
        NodeList list = this.element.getChildNodes();
        int sz = list.getLength();
        for (int i = 0; i < sz; ++i) {
            DOMSelectorMatcher childSM;
            Node node = list.item(i);
            if (node.getNodeType() != 1 || !(childSM = new DOMSelectorMatcher((CSSElement)node)).matches((Selector)desc)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean scopeMatchDirectAdjacent(SiblingSelector selector) {
        SelectorMatcher siblingSM = null;
        for (Node sibling = this.element.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
            if (sibling.getNodeType() != 1) continue;
            siblingSM = new DOMSelectorMatcher((CSSElement)sibling);
            break;
        }
        if (siblingSM != null) {
            return siblingSM.matches((Selector)selector.getSiblingSelector());
        }
        return false;
    }
}

