/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.ExtendedCSSValue;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.css.CSSRule;

public class DefaultStyleFormattingContext
implements StyleFormattingContext {
    private static final String indentingUnit = "    ";
    private String indentString = "";
    private CSSRule parentContextRule = null;

    @Override
    public void deepenCurrentContext() {
        this.indentString = this.indentString + indentingUnit;
    }

    @Override
    public void endCurrentContext(CSSRule rule) {
        this.updateIndentString(rule.getParentRule());
    }

    @Override
    public void endPropertyDeclaration(SimpleWriter wri) throws IOException {
        wri.newLine();
    }

    @Override
    public void endRule(SimpleWriter wri) throws IOException {
        wri.newLine();
    }

    @Override
    public void endRuleList(SimpleWriter wri) throws IOException {
        this.writeFullIndent(wri);
    }

    @Override
    public void endStyleDeclaration(SimpleWriter wri) throws IOException {
        this.writeFullIndent(wri);
    }

    @Override
    public void newLine(SimpleWriter wri) throws IOException {
        wri.newLine();
        this.writeFullIndent(wri);
    }

    @Override
    public void setParentContext(CSSRule rule) {
        this.parentContextRule = rule;
    }

    @Override
    public void startPropertyDeclaration(SimpleWriter wri) throws IOException {
        this.writeFullIndent(wri);
    }

    @Override
    public void startRule(SimpleWriter wri) throws IOException {
        this.writeFullIndent(wri);
    }

    @Override
    public void startStyleDeclaration(SimpleWriter wri) throws IOException {
    }

    @Override
    public void updateContext(CSSRule rule) {
        this.updateIndentString(rule);
    }

    private void updateIndentString(CSSRule rule) {
        if (rule == this.parentContextRule) {
            this.indentString = "";
        } else {
            this.indentString = indentingUnit;
            for (CSSRule parent = rule.getParentRule(); parent != this.parentContextRule; parent = parent.getParentRule()) {
                this.deepenCurrentContext();
            }
        }
    }

    @Override
    public void writeColon(SimpleWriter wri) throws IOException {
        wri.write(':');
        wri.write(' ');
    }

    @Override
    public void writeComma(SimpleWriter wri) throws IOException {
        wri.write(',');
        wri.write(' ');
    }

    @Override
    public void writeComment(SimpleWriter wri, String comment) throws IOException {
        this.writeFullIndent(wri);
        wri.write("/*");
        wri.write(comment);
        wri.write("*/");
        wri.newLine();
    }

    @Override
    public void writeFullIndent(SimpleWriter wri) throws IOException {
        wri.write(this.indentString);
    }

    @Override
    public void writeImportantPriority(SimpleWriter wri) throws IOException {
        wri.write(" ! important");
    }

    @Override
    public void writeLeftCurlyBracket(SimpleWriter wri) throws IOException {
        wri.write(' ');
        wri.write('{');
        wri.newLine();
    }

    @Override
    public void writeLevelIndent(SimpleWriter wri) throws IOException {
        wri.write(indentingUnit);
    }

    @Override
    public void writeRightCurlyBracket(SimpleWriter wri) throws IOException {
        wri.write('}');
    }

    @Override
    public void writeSemiColon(SimpleWriter wri) throws IOException {
        wri.write(';');
    }

    @Override
    public void writeURL(SimpleWriter wri, String href) throws IOException {
        wri.write("url('");
        wri.write(href);
        wri.write("')");
    }

    @Override
    public void writeValue(SimpleWriter wri, String propertyName, ExtendedCSSValue value) throws IOException {
        value.writeCssText(wri);
    }
}

