/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.CSSIdentifierValue;
import io.sf.carte.doc.style.css.property.OMCSSValueList;
import org.w3c.dom.css.CSSPrimitiveValue;

class GridPlacementShorthandSetter
extends ShorthandSetter {
    final String[] subparray;

    GridPlacementShorthandSetter(BaseCSSStyleDeclaration style, String shorthandName) {
        super(style, shorthandName);
        this.subparray = this.getPropertyDatabase().getShorthandSubproperties(shorthandName);
    }

    @Override
    public boolean assignSubproperties() {
        byte kwscan = this.scanForCssWideKeywords(this.currentValue);
        if (kwscan == 1) {
            return true;
        }
        if (kwscan == 2) {
            return false;
        }
        this.setPropertyToDefault(this.subparray[0]);
        this.setPropertyToDefault(this.subparray[1]);
        AbstractCSSValue firstValue = this.gridLine();
        if (firstValue != null) {
            this.setSubpropertyValue(this.subparray[0], firstValue);
            if (this.currentValue != null) {
                AbstractCSSValue secondValue;
                this.nextCurrentValue();
                if (this.currentValue != null && (secondValue = this.gridLine()) != null && this.currentValue == null) {
                    this.setSubpropertyValue(this.subparray[1], secondValue);
                    this.flush();
                    return true;
                }
            } else {
                if (firstValue.getCssValueType() == 1 && ((CSSPrimitiveValue)((Object)firstValue)).getPrimitiveType() == 21) {
                    this.setSubpropertyValue(this.subparray[1], firstValue);
                }
                this.flush();
                return true;
            }
        }
        return false;
    }

    AbstractCSSValue gridLine() {
        short lut = this.currentValue.getLexicalUnitType();
        if (lut == 35) {
            String sv = this.currentValue.getStringValue();
            if ("auto".equalsIgnoreCase(sv)) {
                this.nextCurrentValue();
                CSSIdentifierValue ident = new CSSIdentifierValue("auto");
                ident.setSubproperty(true);
                if (this.isFinalCurrentValue()) {
                    return ident;
                }
            } else if ("span".equalsIgnoreCase(sv)) {
                OMCSSValueList list = OMCSSValueList.createWSValueList();
                list.add(this.valueFactory.createCSSValueItem(this.currentValue, true).getCSSValue());
                this.nextCurrentValue();
                if (this.currentValue != null && ((lut = this.currentValue.getLexicalUnitType()) == 13 || lut == 35)) {
                    list.add(this.valueFactory.createCSSValueItem(this.currentValue, true).getCSSValue());
                    this.nextCurrentValue();
                    if (this.isFinalCurrentValue()) {
                        return list;
                    }
                }
            } else {
                AbstractCSSValue customIdent = this.createCSSValue(this.getShorthandName(), this.currentValue);
                this.nextCurrentValue();
                if (this.isFinalCurrentValue()) {
                    return customIdent;
                }
            }
        } else if (lut == 13) {
            AbstractCSSValue cssInt = this.createCSSValue(this.getShorthandName(), this.currentValue);
            this.nextCurrentValue();
            if (this.isFinalCurrentValue()) {
                return cssInt;
            }
            if (this.currentValue.getLexicalUnitType() == 35) {
                OMCSSValueList list = OMCSSValueList.createWSValueList();
                list.add(cssInt);
                list.add(this.valueFactory.createCSSValueItem(this.currentValue, true).getCSSValue());
                this.nextCurrentValue();
                if (this.isFinalCurrentValue()) {
                    return list;
                }
            }
        }
        return null;
    }

    boolean isFinalCurrentValue() {
        return this.currentValue == null || this.currentValue.getLexicalUnitType() == 4;
    }
}

