/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.OMCSSValueList;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.css.CSSPrimitiveValue;

class GridShorthandBuilder
extends ShorthandBuilder {
    GridShorthandBuilder(BaseCSSStyleDeclaration parentStyle) {
        super("grid", parentStyle);
    }

    @Override
    int getMinimumSetSize() {
        return 3;
    }

    @Override
    boolean appendShorthandSet(StringBuilder buf, Set<String> declaredSet, boolean important) {
        BaseCSSStyleDeclaration style = this.getParentStyle();
        if (!(style.isPropertySet("grid-template-rows") && style.isPropertySet("grid-template-columns") && style.isPropertySet("grid-template-areas"))) {
            return false;
        }
        if (style.isPropertySet("grid-auto-rows") && style.isPropertySet("grid-auto-columns") && style.isPropertySet("grid-auto-flow")) {
            return new FullGridShorthandBuilder(style).appendShorthandSet(buf, declaredSet, important);
        }
        return new GridTemplateShorthandBuilder(style).appendShorthandSet(buf, declaredSet, important);
    }

    @Override
    boolean isNotInitialValue(AbstractCSSValue cssVal, String propertyName) {
        return cssVal != null && !GridShorthandBuilder.isInitialIdentifier(cssVal) && !this.valueEquals(this.getInitialPropertyValue(propertyName), cssVal);
    }

    private void appendValueText(StringBuilder buf, AbstractCSSValue cssVal) {
        buf.append(cssVal.getMinifiedCssText(this.getShorthandName()));
    }

    private boolean isIdentifier(AbstractCSSValue cssVal) {
        return cssVal.getCssValueType() == 1 && ((CSSPrimitiveValue)((Object)cssVal)).getPrimitiveType() == 21;
    }

    private boolean isIdentifier(AbstractCSSValue cssVal, String ident) {
        return this.isIdentifier(cssVal) && ident.equalsIgnoreCase(((CSSPrimitiveValue)((Object)cssVal)).getStringValue());
    }

    private class GridValues
    extends GridTemplateValues {
        final AbstractCSSValue cssGridARows;
        final AbstractCSSValue cssGridAColumns;
        final AbstractCSSValue cssGridAFlow;
        final boolean defaultGridARows;
        final boolean defaultGridAColumns;
        final boolean defaultGridAFlow;
        final boolean rowAFlow;

        GridValues(Set<String> declaredSet) {
            super(declaredSet);
            this.cssGridARows = GridShorthandBuilder.this.getCSSValue("grid-auto-rows");
            this.cssGridAColumns = GridShorthandBuilder.this.getCSSValue("grid-auto-columns");
            this.cssGridAFlow = GridShorthandBuilder.this.getCSSValue("grid-auto-flow");
            this.defaultGridARows = GridShorthandBuilder.this.isIdentifier(this.cssGridARows, "auto") || !declaredSet.contains("grid-auto-rows");
            this.defaultGridAColumns = GridShorthandBuilder.this.isIdentifier(this.cssGridAColumns, "auto") || !declaredSet.contains("grid-auto-columns");
            this.defaultGridAFlow = GridShorthandBuilder.this.isIdentifier(this.cssGridAFlow, "row") || !declaredSet.contains("grid-auto-flow");
            this.rowAFlow = this.isRowAutoflow();
        }

        @Override
        void gridRowsColumnsSyntax(StringBuilder buf, Set<String> declaredSet, boolean important) {
            super.gridRowsColumnsSyntax(buf, declaredSet, important);
            if (!this.defaultGridARows) {
                buf.append("grid-auto-rows:");
                GridShorthandBuilder.this.appendValueText(buf, this.cssGridARows);
                GridShorthandBuilder.this.appendPriority(buf, important);
            }
            if (!this.defaultGridAColumns) {
                buf.append("grid-auto-columns:");
                GridShorthandBuilder.this.appendValueText(buf, this.cssGridAColumns);
                GridShorthandBuilder.this.appendPriority(buf, important);
            }
            if (!this.defaultGridAFlow) {
                buf.append("grid-auto-flow:");
                GridShorthandBuilder.this.appendValueText(buf, this.cssGridAFlow);
                GridShorthandBuilder.this.appendPriority(buf, important);
            }
        }

        private boolean gridRowAutoFlowSyntax(StringBuilder buf, Set<String> declaredSet) {
            if (!this.isAutoflowDense()) {
                buf.append("auto-flow ");
            } else {
                buf.append("auto-flow dense ");
            }
            GridShorthandBuilder.this.appendValueText(buf, this.cssGridARows);
            if (!this.defaultGridTColumns) {
                buf.append('/');
                GridShorthandBuilder.this.appendValueText(buf, this.cssGridTColumns);
            }
            return true;
        }

        private boolean gridColumnAutoFlowSyntax(StringBuilder buf, Set<String> declaredSet) {
            GridShorthandBuilder.this.appendValueText(buf, this.cssGridTRows);
            if (!this.defaultGridAColumns) {
                buf.append('/');
                if (!this.isAutoflowDense()) {
                    buf.append("auto-flow ");
                } else {
                    buf.append("auto-flow dense ");
                }
                GridShorthandBuilder.this.appendValueText(buf, this.cssGridAColumns);
            }
            return true;
        }

        @Override
        boolean isNoneValue() {
            return this.defaultGridTAreas && this.defaultGridTRows && this.defaultGridTColumns && this.defaultGridARows && this.defaultGridAColumns && this.defaultGridAFlow;
        }

        private boolean isRowAutoflow() {
            if (this.cssGridAFlow.getCssValueType() == 2) {
                OMCSSValueList list = (OMCSSValueList)this.cssGridAFlow;
                if (list.getLength() == 2) {
                    return "row".equalsIgnoreCase(list.item(0).getCssText()) || "row".equalsIgnoreCase(list.item(1).getCssText());
                }
            } else {
                return "row".equalsIgnoreCase(this.cssGridAFlow.getCssText());
            }
            return false;
        }

        private boolean isAutoflowDense() {
            OMCSSValueList list;
            if (this.cssGridAFlow.getCssValueType() == 2 && (list = (OMCSSValueList)this.cssGridAFlow).getLength() == 2) {
                return "dense".equalsIgnoreCase(list.item(1).getCssText()) || "dense".equalsIgnoreCase(list.item(0).getCssText());
            }
            return false;
        }
    }

    private class GridTemplateValues {
        final AbstractCSSValue cssGridTAreas;
        final AbstractCSSValue cssGridTRows;
        final AbstractCSSValue cssGridTColumns;
        final boolean defaultGridTAreas;
        final boolean defaultGridTRows;
        final boolean defaultGridTColumns;
        boolean lacksRepeatInGridTRows;

        GridTemplateValues(Set<String> declaredSet) {
            this.cssGridTAreas = GridShorthandBuilder.this.getCSSValue("grid-template-areas");
            this.cssGridTRows = GridShorthandBuilder.this.getCSSValue("grid-template-rows");
            this.cssGridTColumns = GridShorthandBuilder.this.getCSSValue("grid-template-columns");
            this.defaultGridTAreas = GridShorthandBuilder.this.isIdentifier(this.cssGridTAreas, "none") || !declaredSet.contains("grid-template-areas");
            this.defaultGridTRows = GridShorthandBuilder.this.isIdentifier(this.cssGridTRows, "none") || !declaredSet.contains("grid-template-rows");
            this.defaultGridTColumns = GridShorthandBuilder.this.isIdentifier(this.cssGridTColumns, "none") || !declaredSet.contains("grid-template-columns");
            this.lacksRepeatInGridTRows = this.lacksRepeatFunction(this.cssGridTRows);
        }

        private boolean lacksRepeatFunction(AbstractCSSValue value) {
            if (value.getCssValueType() == 2) {
                OMCSSValueList list = (OMCSSValueList)value;
                Iterator<AbstractCSSValue> it = list.iterator();
                while (it.hasNext()) {
                    if (this.lacksRepeatFunction(it.next())) continue;
                    return false;
                }
            } else if (value.getCssValueType() == 1) {
                CSSPrimitiveValue primi = (CSSPrimitiveValue)((Object)value);
                return primi.getPrimitiveType() != 127 || "repeat".equalsIgnoreCase(primi.getStringValue());
            }
            return true;
        }

        boolean gridAreasSyntax(StringBuilder buf, Set<String> declaredSet) {
            if (this.defaultGridTRows) {
                AbstractCSSValue areavalue = this.getGridTemplateAreaItem(0);
                GridShorthandBuilder.this.appendValueText(buf, areavalue);
                int idx = 1;
                while ((areavalue = this.getGridTemplateAreaItem(idx)) != null) {
                    buf.append(' ');
                    GridShorthandBuilder.this.appendValueText(buf, areavalue);
                    ++idx;
                }
            } else if (this.cssGridTRows.getCssValueType() == 2) {
                if (!((OMCSSValueList)this.cssGridTRows).isBracketList()) {
                    int rowlistIdx = 0;
                    OMCSSValueList rowsslist = (OMCSSValueList)this.cssGridTRows;
                    Iterator<AbstractCSSValue> it = rowsslist.iterator();
                    while (it.hasNext()) {
                        OMCSSValueList bracketlist;
                        AbstractCSSValue value = it.next();
                        if (value.getCssValueType() == 2 && (bracketlist = (OMCSSValueList)value).isBracketList()) {
                            int sz = bracketlist.getLength();
                            if (sz < 2) {
                                GridShorthandBuilder.this.appendValueText(buf, value);
                            } else if (sz == 2) {
                                buf.append('[');
                                GridShorthandBuilder.this.appendValueText(buf, bracketlist.item(0));
                                buf.append("] [");
                                GridShorthandBuilder.this.appendValueText(buf, bracketlist.item(1));
                                buf.append(']');
                            } else {
                                return false;
                            }
                            AbstractCSSValue areavalue = this.getGridTemplateAreaItem(rowlistIdx);
                            if (areavalue != null) {
                                buf.append(' ');
                                GridShorthandBuilder.this.appendValueText(buf, areavalue);
                                buf.append(' ');
                                ++rowlistIdx;
                                continue;
                            }
                            if (!it.hasNext()) continue;
                            return false;
                        }
                        if (GridShorthandBuilder.this.isIdentifier(value) && "auto".equalsIgnoreCase(value.getCssText())) continue;
                        GridShorthandBuilder.this.appendValueText(buf, value);
                        buf.append(' ');
                    }
                } else {
                    AbstractCSSValue areavalue;
                    GridShorthandBuilder.this.appendValueText(buf, this.cssGridTRows);
                    int idx = 0;
                    while ((areavalue = this.getGridTemplateAreaItem(idx)) != null) {
                        buf.append(' ');
                        GridShorthandBuilder.this.appendValueText(buf, areavalue);
                        buf.append(' ');
                        ++idx;
                    }
                }
            } else {
                AbstractCSSValue areavalue = this.getGridTemplateAreaItem(0);
                GridShorthandBuilder.this.appendValueText(buf, areavalue);
                buf.append(' ');
                GridShorthandBuilder.this.appendValueText(buf, this.cssGridTRows);
                int idx = 1;
                while ((areavalue = this.getGridTemplateAreaItem(idx)) != null) {
                    buf.append(' ');
                    GridShorthandBuilder.this.appendValueText(buf, areavalue);
                    buf.append(' ');
                    ++idx;
                }
            }
            if (!this.defaultGridTColumns) {
                buf.append('/');
                GridShorthandBuilder.this.appendValueText(buf, this.cssGridTColumns);
            } else {
                int lm1 = buf.length() - 1;
                if (buf.charAt(lm1) == ' ') {
                    buf.setLength(lm1);
                }
            }
            return true;
        }

        void gridRowsColumnsSyntax(StringBuilder buf, Set<String> declaredSet, boolean important) {
            GridShorthandBuilder.this.appendValueText(buf, this.cssGridTRows);
            if (!this.defaultGridTColumns) {
                buf.append('/');
                GridShorthandBuilder.this.appendValueText(buf, this.cssGridTColumns);
            }
            GridShorthandBuilder.this.appendPriority(buf, important);
            if (!this.defaultGridTAreas) {
                buf.append("grid-template-areas:");
                GridShorthandBuilder.this.appendValueText(buf, this.cssGridTAreas);
                GridShorthandBuilder.this.appendPriority(buf, important);
            }
        }

        boolean isNoneValue() {
            return this.defaultGridTAreas && this.defaultGridTRows && this.defaultGridTColumns;
        }

        AbstractCSSValue getGridTemplateAreaItem(int index) {
            if (this.cssGridTAreas.getCssValueType() == 2) {
                return ((OMCSSValueList)this.cssGridTAreas).item(index);
            }
            if (!this.defaultGridTAreas) {
                return this.cssGridTAreas;
            }
            return null;
        }
    }

    private class FullGridShorthandBuilder
    extends GridShorthandBuilder {
        FullGridShorthandBuilder(BaseCSSStyleDeclaration parentStyle) {
            super(parentStyle);
        }

        @Override
        boolean appendShorthandSet(StringBuilder buf, Set<String> declaredSet, boolean important) {
            String[] subp;
            buf.append(this.getShorthandName()).append(':');
            byte check = this.checkValuesForInherit(declaredSet);
            if (check == 1) {
                buf.append("inherit");
                this.appendPriority(buf, important);
                return true;
            }
            if (check == 2) {
                return false;
            }
            check = this.checkValuesForKeyword("unset", declaredSet);
            if (check == 1) {
                buf.append("unset");
                this.appendPriority(buf, important);
                return true;
            }
            if (check == 2) {
                return false;
            }
            for (String property : subp = this.getLonghandProperties()) {
                AbstractCSSValue cssVal = this.getCSSValue(property);
                if (cssVal.getCssValueType() != 2 || !((OMCSSValueList)cssVal).isCommaSeparated()) continue;
                return false;
            }
            GridValues values = new GridValues(declaredSet);
            if (values.isNoneValue()) {
                buf.append("none");
                this.appendPriority(buf, important);
                return true;
            }
            if (values.defaultGridTAreas) {
                if (!values.rowAFlow && values.defaultGridARows && values.defaultGridTColumns) {
                    if (values.gridColumnAutoFlowSyntax(buf, declaredSet)) {
                        this.appendPriority(buf, important);
                        return true;
                    }
                } else if (values.rowAFlow && values.defaultGridAColumns && values.defaultGridTRows && values.gridRowAutoFlowSyntax(buf, declaredSet)) {
                    this.appendPriority(buf, important);
                    return true;
                }
            } else if (!values.defaultGridTAreas && values.lacksRepeatInGridTRows && values.gridAreasSyntax(buf, declaredSet)) {
                this.appendPriority(buf, important);
                return true;
            }
            values.gridRowsColumnsSyntax(buf, declaredSet, important);
            return true;
        }
    }

    private class GridTemplateShorthandBuilder
    extends GridShorthandBuilder {
        GridTemplateShorthandBuilder(BaseCSSStyleDeclaration parentStyle) {
            super(parentStyle);
        }

        @Override
        boolean appendShorthandSet(StringBuilder buf, Set<String> declaredSet, boolean important) {
            String[] subp;
            buf.append(this.getShorthandName()).append(':');
            byte check = this.checkValuesForInherit(declaredSet);
            if (check == 1) {
                buf.append("inherit");
                this.appendPriority(buf, important);
                return true;
            }
            if (check == 2) {
                return false;
            }
            check = this.checkValuesForKeyword("unset", declaredSet);
            if (check == 1) {
                buf.append("unset");
                this.appendPriority(buf, important);
                return true;
            }
            if (check == 2) {
                return false;
            }
            for (String property : subp = this.getLonghandProperties()) {
                AbstractCSSValue cssVal = this.getCSSValue(property);
                if (cssVal.getCssValueType() != 2 || !((OMCSSValueList)cssVal).isCommaSeparated()) continue;
                return false;
            }
            GridTemplateValues values = new GridTemplateValues(declaredSet);
            if (values.isNoneValue()) {
                buf.append("none");
                this.appendPriority(buf, important);
                return true;
            }
            if (!values.defaultGridTAreas && values.lacksRepeatInGridTRows && values.gridAreasSyntax(buf, declaredSet)) {
                this.appendPriority(buf, important);
                return true;
            }
            values.gridRowsColumnsSyntax(buf, declaredSet, important);
            return true;
        }

        @Override
        String getShorthandName() {
            return "grid-template";
        }

        @Override
        int getTotalSetSize() {
            return 3;
        }
    }
}

