/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandSetter;

class ListStyleShorthandSetter
extends ShorthandSetter {
    ListStyleShorthandSetter(BaseCSSStyleDeclaration style) {
        super(style, "list-style");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean assignSubproperties() {
        byte kwscan = this.scanForCssWideKeywords(this.currentValue);
        if (kwscan == 1) {
            return true;
        }
        if (kwscan == 2) {
            return false;
        }
        this.setPropertyToDefault("list-style-image");
        this.setPropertyToDefault("list-style-type");
        this.setPropertyToDefault("list-style-position");
        boolean stylePositionUnset = true;
        boolean styleImageUnset = true;
        boolean styleTypeUnset = true;
        while (this.currentValue != null) {
            short lut = this.currentValue.getLexicalUnitType();
            if (lut == 24 || this.isGradientValue()) {
                this.setSubpropertyValue("list-style-image", this.createCSSValue("list-style-image", this.currentValue));
                styleImageUnset = false;
            } else if (lut == 35) {
                if (stylePositionUnset && this.testIdentifiers("list-style-position")) {
                    this.setSubpropertyValue("list-style-position", this.createCSSValue("list-style-position", this.currentValue));
                    stylePositionUnset = false;
                } else if (styleTypeUnset && this.testIdentifiers("list-style-type")) {
                    this.setSubpropertyValue("list-style-type", this.createCSSValue("list-style-type", this.currentValue));
                    styleTypeUnset = false;
                } else if ("none".equalsIgnoreCase(this.currentValue.getStringValue())) {
                    if (styleImageUnset) {
                        this.setSubpropertyValue("list-style-image", this.createCSSValue("list-style-image", this.currentValue));
                    }
                    if (styleTypeUnset) {
                        this.setSubpropertyValue("list-style-type", this.createCSSValue("list-style-type", this.currentValue));
                    }
                } else {
                    if (!styleTypeUnset) return false;
                    this.setSubpropertyValue("list-style-type", this.createCSSValue("list-style-type", this.currentValue));
                    styleTypeUnset = false;
                }
            } else {
                if (!styleTypeUnset || lut != 36) return false;
                this.setSubpropertyValue("list-style-type", this.createCSSValue("list-style-type", this.currentValue));
                styleTypeUnset = false;
            }
            this.nextCurrentValue();
        }
        this.flush();
        return true;
    }
}

