/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.ExtendedCSSValue;
import io.sf.carte.doc.style.css.om.MediaQueryFactory;
import io.sf.carte.doc.style.css.om.MediaQueryHandler;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.TokenProducer;
import java.util.Locale;

class MediaQueryParser {
    MediaQueryParser() {
    }

    public static void parse(String mediaQueryString, MediaQueryHandler mqhandler) {
        int[] allowInWords = new int[]{45, 95};
        MQTokenHandler handler = new MQTokenHandler(mqhandler);
        TokenProducer tp = new TokenProducer(handler, allowInWords);
        tp.parse(mediaQueryString, "/*", "*/");
    }

    private static ExtendedCSSValue parseMediaFeature(String stringValue) {
        AbstractCSSValue value;
        try {
            value = new ValueFactory().parseMediaFeature(stringValue);
        }
        catch (RuntimeException e) {
            value = null;
        }
        return value;
    }

    private static boolean isKnownFeature(String string) {
        return string.startsWith("min-") || string.startsWith("max-") || MediaQueryFactory.isMediaFeature(string);
    }

    private static boolean isValidFeatureSyntax(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetter(c) || c == '-') continue;
            return false;
        }
        return true;
    }

    static class MQTokenHandler
    implements TokenProducer.TokenHandler {
        MediaQueryHandler handler;
        byte stage = 0;
        StringBuilder buffer = new StringBuilder(64);
        boolean spaceFound = false;
        boolean escaped = false;
        String featureName = null;
        String firstValue = null;
        int prevcp = 32;
        boolean functionToken = false;
        short parendepth = 0;
        byte rangeType = 0;
        private static final byte WORD_UNQUOTED = 0;
        private static final byte WORD_SINGLE_QUOTED = 1;
        private static final byte WORD_DOUBLE_QUOTED = 2;

        MQTokenHandler(MediaQueryHandler handler) {
            this.handler = handler;
        }

        private void reverseRangetype() {
            if ((this.rangeType & 2) == 2) {
                this.rangeType = (byte)(this.rangeType ^ 2);
                this.rangeType = (byte)(this.rangeType | 4);
            } else if ((this.rangeType & 4) == 4) {
                this.rangeType = (byte)(this.rangeType ^ 4);
                this.rangeType = (byte)(this.rangeType | 2);
            }
        }

        @Override
        public void word(int index, String word) {
            if (this.stage == 127) {
                return;
            }
            String lctoken = word.toLowerCase(Locale.US);
            if (this.functionToken) {
                if (this.buffer.length() != 0) {
                    this.buffer.append(' ');
                }
                this.buffer.append(word);
            } else if ("not".equals(lctoken)) {
                if (this.stage != 0) {
                    this.reportError(index, "Found 'not' at the wrong parsing stage");
                } else {
                    this.handler.negativeQuery();
                }
            } else if ("only".equals(lctoken)) {
                if (this.stage != 0) {
                    this.reportError(index, "Found 'only' at the wrong parsing stage");
                } else {
                    this.handler.onlyPrefix();
                }
            } else if ("and".equals(lctoken)) {
                if (this.stage != 0 && this.stage != 1) {
                    this.reportError(index, "Found 'and' at the wrong parsing stage");
                    return;
                }
                if (this.buffer.length() != 0) {
                    this.handler.mediaType(this.rawBuffer());
                }
                this.stage = (byte)2;
            } else if ("or".equals(lctoken)) {
                this.handler.invalidQuery("Found 'or'");
            } else if (!this.appendWord(index, word, (byte)0)) {
                return;
            }
            this.prevcp = 65;
        }

        private void processBuffer() {
            if (this.buffer.length() != 0) {
                if (this.stage == 1) {
                    this.handler.mediaType(this.rawBuffer());
                } else if (this.stage == 6) {
                    this.featureName = this.rawBuffer();
                }
            }
        }

        private String rawBuffer() {
            String raw = this.buffer.toString();
            this.buffer.setLength(0);
            this.spaceFound = false;
            this.escaped = false;
            return raw;
        }

        private boolean appendWord(int index, String word, byte quotes) {
            if (this.buffer.length() != 0 && (this.prevcp == 32 || this.prevcp == 13)) {
                if (this.stage == 1) {
                    this.reportError(index, "Found white space between media");
                    return false;
                }
                this.spaceFound = true;
                this.buffer.append(' ');
            }
            if (quotes == 0) {
                this.buffer.append(word);
            } else if (quotes == 1) {
                this.buffer.append('\'').append(word).append('\'');
            } else {
                this.buffer.append('\"').append(word).append('\"');
            }
            if (!this.functionToken) {
                if (this.stage == 0) {
                    this.stage = 1;
                } else if (this.stage == 5) {
                    this.stage = (byte)6;
                }
            }
            return true;
        }

        @Override
        public void openGroup(int index, int codepoint) {
            if (codepoint == 40) {
                if (this.prevcp != 32 && this.prevcp != 13) {
                    this.functionToken = true;
                    this.buffer.append('(');
                } else if (this.stage == 2 || this.stage == 0) {
                    this.stage = (byte)3;
                }
                this.parendepth = (short)(this.parendepth + 1);
            } else {
                this.reportError(index, "Unexpected " + new String(Character.toChars(codepoint)));
            }
            this.prevcp = codepoint;
        }

        @Override
        public void closeGroup(int index, int codepoint) {
            if (codepoint == 41) {
                this.parendepth = (short)(this.parendepth - 1);
                if (this.functionToken) {
                    this.buffer.append(')');
                    this.functionToken = false;
                } else {
                    if (this.stage == 6) {
                        String tempstr;
                        this.processBuffer();
                        if (this.firstValue != null && MediaQueryParser.isKnownFeature(this.firstValue)) {
                            tempstr = this.firstValue;
                            this.firstValue = this.featureName;
                            this.featureName = tempstr;
                        } else if (!MediaQueryParser.isKnownFeature(this.featureName)) {
                            if (MediaQueryParser.isValidFeatureSyntax(this.firstValue)) {
                                tempstr = this.firstValue;
                                this.firstValue = this.featureName;
                                this.featureName = tempstr;
                            } else {
                                if (!MediaQueryParser.isValidFeatureSyntax(this.featureName)) {
                                    this.reportError(index, "Wrong feature expression near " + this.featureName + " " + this.firstValue + ")");
                                    this.prevcp = codepoint;
                                    return;
                                }
                                this.reverseRangetype();
                            }
                        } else {
                            this.reverseRangetype();
                        }
                        ExtendedCSSValue value1 = MediaQueryParser.parseMediaFeature(this.firstValue);
                        if (value1 == null) {
                            this.error(index, (byte)5, this.firstValue);
                        } else {
                            this.handler.featureRange(this.featureName, this.rangeType, value1, null);
                        }
                    } else if (this.buffer.length() != 0) {
                        if (this.stage == 4) {
                            ExtendedCSSValue value = MediaQueryParser.parseMediaFeature(this.buffer.toString());
                            if (value == null) {
                                this.error(index, (byte)5, this.buffer.toString());
                            } else {
                                this.handler.featureValue(this.featureName, value);
                            }
                        } else if (this.stage == 7) {
                            ExtendedCSSValue value1 = MediaQueryParser.parseMediaFeature(this.firstValue);
                            ExtendedCSSValue value2 = MediaQueryParser.parseMediaFeature(this.buffer.toString());
                            if (value1 == null) {
                                this.error(index, (byte)5, this.firstValue);
                            } else if (value2 == null) {
                                this.error(index, (byte)5, this.buffer.toString());
                            } else {
                                this.handler.featureRange(this.featureName, this.rangeType, value1, value2);
                            }
                        } else if (this.stage == 3 && !this.spaceFound) {
                            this.handler.featureValue(this.buffer.toString(), null);
                        } else {
                            this.error(index, (byte)32, this.buffer.toString());
                        }
                        this.buffer.setLength(0);
                        this.spaceFound = false;
                        this.escaped = false;
                    } else {
                        this.reportError(index, "Unexpected )");
                    }
                    if (this.stage == 5) {
                        this.reportError(index, "Unexpected )");
                    } else {
                        this.rangeType = 0;
                        this.stage = 1;
                    }
                }
            } else {
                this.reportError(index, "Unexpected " + new String(Character.toChars(codepoint)));
            }
            this.prevcp = codepoint;
        }

        @Override
        public void character(int index, int codepoint) {
            if (this.functionToken) {
                this.buffer.append(Character.toChars(codepoint));
            } else {
                if (codepoint == 58) {
                    if (this.buffer.length() != 0) {
                        this.featureName = this.rawBuffer();
                        this.stage = (byte)4;
                    } else {
                        this.reportError(index, "Empty feature name");
                    }
                } else if (codepoint == 44) {
                    if (this.parendepth != 0) {
                        this.reportError(index, "Unmatched parenthesis");
                    } else if (this.stage == 0) {
                        this.reportError(index, "No media found");
                    }
                    this.processBuffer();
                    this.stage = 0;
                    this.prevcp = 32;
                    this.spaceFound = false;
                    this.handler.endQuery();
                } else if (codepoint == 46) {
                    if (this.stage == 4 || this.stage == 3 || this.stage == 7 || this.functionToken) {
                        this.buffer.append('.');
                    } else {
                        this.reportError(index, "Unexpected '.'");
                    }
                } else if (codepoint == 47) {
                    if (this.stage == 4 || this.stage == 3 || this.stage == 7 || this.functionToken) {
                        this.buffer.append('/');
                    } else {
                        this.reportError(index, "Unexpected '/'");
                    }
                } else if (codepoint == 59) {
                    this.error(index, (byte)4, ";");
                } else if (codepoint == 60) {
                    if (this.stage < 3 || this.rangeType > 5) {
                        this.reportError(index, "Unexpected <");
                    } else if (this.stage != 6) {
                        this.rangeType = (byte)(this.rangeType | 2);
                        this.stage = (byte)5;
                    } else {
                        this.processBuffer();
                        this.rangeType = (byte)(this.rangeType | 0x10);
                        this.stage = (byte)7;
                    }
                } else if (codepoint == 61) {
                    if (this.stage < 3 || this.rangeType > 5) {
                        this.reportError(index, "Unexpected =");
                    } else if (this.stage != 6) {
                        this.rangeType = (byte)(this.rangeType | 1);
                        this.stage = (byte)5;
                    } else {
                        this.processBuffer();
                        this.rangeType = (byte)(this.rangeType | 8);
                        this.stage = (byte)7;
                    }
                } else if (codepoint == 62 || this.rangeType > 5) {
                    if (this.stage < 3) {
                        this.reportError(index, "Unexpected >");
                    } else if (this.stage != 6) {
                        this.rangeType = (byte)(this.rangeType | 4);
                        this.stage = (byte)5;
                    } else {
                        this.processBuffer();
                        this.rangeType = (byte)(this.rangeType | 0x20);
                        this.stage = (byte)7;
                    }
                } else {
                    this.reportError(index, "Unexpected " + new String(Character.toChars(codepoint)));
                }
                if (this.stage == 5 && this.firstValue == null && this.buffer.length() != 0) {
                    this.firstValue = this.rawBuffer();
                }
            }
            this.prevcp = codepoint;
        }

        @Override
        public void singleQuoted(int index, String quoted) {
            this.appendWord(index, quoted, (byte)1);
        }

        @Override
        public void doubleQuoted(int index, String quoted) {
            this.appendWord(index, quoted, (byte)2);
        }

        @Override
        public void escaped(int index, int codepoint) {
            if (this.stage != 127) {
                if (this.escaped) {
                    this.reportError(index, "Unexpected \\");
                } else {
                    this.escaped = true;
                    this.buffer.append('\\').append(Character.toChars(codepoint));
                    if (this.stage == 5) {
                        this.stage = (byte)6;
                    } else if (this.stage == 0) {
                        this.stage = 1;
                    }
                }
            }
            this.prevcp = codepoint;
        }

        @Override
        public void separator(int index, int cp) {
            if (this.escaped && CSSParser.bufferEndsWithEscapedChar(this.buffer)) {
                this.buffer.append(' ');
            } else {
                this.prevcp = 32;
            }
        }

        @Override
        public void control(int index, int codepoint) {
            if (this.escaped && CSSParser.bufferEndsWithEscapedChar(this.buffer)) {
                this.buffer.append(' ');
                this.escaped = false;
            }
            this.prevcp = 13;
        }

        @Override
        public void quotedNewlineChar(int index, int codepoint) {
        }

        @Override
        public void commented(int index, int commentType, String comment) {
        }

        @Override
        public void endOfStream(int len) {
            if (this.parendepth != 0) {
                this.handler.invalidQuery("Unmatched parenthesis");
            } else if (this.stage == 1) {
                this.processBuffer();
            } else if (this.stage > 1) {
                this.handler.invalidQuery("Unexpected end of media text");
            }
            this.handler.endQuery();
        }

        @Override
        public void error(int index, byte errCode, CharSequence context) {
            this.reportError(index, "Bad query near: " + context.toString());
        }

        private void reportError(int index, String message) {
            this.handler.invalidQuery(message);
            this.stage = (byte)127;
        }

        @Override
        public void tokenControl(TokenProducer.TokenControl control) {
        }
    }
}

