/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.OMCSSPageRule;
import io.sf.carte.doc.style.css.w3c.CSSMarginRule;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class OMCSSMarginRule
extends BaseCSSDeclarationRule
implements CSSMarginRule {
    private String ruleName = null;

    OMCSSMarginRule(AbstractCSSStyleSheet parentSheet, byte origin, String ruleName) {
        super(parentSheet, (short)9, origin);
        this.ruleName = ruleName;
    }

    @Override
    public OMCSSPageRule getParentRule() {
        return (OMCSSPageRule)super.getParentRule();
    }

    @Override
    public String getCssText() {
        StyleFormattingContext context = this.getStyleFormattingContext();
        context.setParentContext(this.getParentRule());
        BufferSimpleWriter sw = new BufferSimpleWriter(32 + this.getStyle().getLength() * 24);
        try {
            this.writeCssText(sw, context);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return sw.toString();
    }

    @Override
    public String getMinifiedCssText() {
        StringBuilder buf = new StringBuilder(96);
        buf.append('@').append(this.ruleName).append('{');
        buf.append(this.getStyle().getMinifiedCssText()).append('}');
        return buf.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        context.startRule(wri);
        wri.write('@');
        wri.write(this.ruleName);
        context.updateContext(this);
        context.writeLeftCurlyBracket(wri);
        context.startStyleDeclaration(wri);
        this.getStyle().writeCssText(wri, context);
        context.endCurrentContext(this);
        context.endStyleDeclaration(wri);
        context.writeRightCurlyBracket(wri);
        context.endRule(wri);
    }

    @Override
    public String getName() {
        return this.ruleName;
    }

    @Override
    public OMCSSMarginRule clone(AbstractCSSStyleSheet parentSheet) {
        return new OMCSSMarginRule(parentSheet, this.getOrigin(), this.ruleName);
    }
}

