/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.OMCSSValueList;
import java.util.Set;

class OrderedTwoValueShorthandBuilder
extends ShorthandBuilder {
    private final String initialvalue;

    OrderedTwoValueShorthandBuilder(String shorthandName, BaseCSSStyleDeclaration parentStyle, String initialvalue) {
        super(shorthandName, parentStyle);
        this.initialvalue = initialvalue;
    }

    @Override
    boolean appendShorthandSet(StringBuilder buf, Set<String> declaredSet, boolean important) {
        AbstractCSSValue cssVal2;
        buf.append(this.getShorthandName()).append(':');
        byte check = this.checkValuesForInherit(declaredSet);
        if (check == 1) {
            buf.append("inherit");
            this.appendPriority(buf, important);
            return true;
        }
        if (check == 2) {
            return false;
        }
        check = this.checkValuesForKeyword("unset", declaredSet);
        if (check == 1) {
            buf.append("unset");
            this.appendPriority(buf, important);
            return true;
        }
        if (check == 2) {
            return false;
        }
        String[] subp = this.getSubproperties();
        if (subp.length != 2) {
            throw new IllegalStateException("This class is only for two subproperties");
        }
        String property = subp[0];
        AbstractCSSValue cssVal = this.getCSSValue(property);
        if (cssVal.getCssValueType() == 2 && ((OMCSSValueList)cssVal).isCommaSeparated()) {
            return false;
        }
        boolean appended = false;
        if (this.isNotInitialValue(cssVal, property)) {
            this.appendValueText(buf, cssVal, false);
            appended = true;
        }
        if (!this.valueEquals(cssVal, cssVal2 = this.getCSSValue(subp[1]))) {
            this.appendValueText(buf, cssVal2, appended);
            appended = true;
        }
        if (!appended) {
            buf.append(this.initialvalue);
        }
        this.appendPriority(buf, important);
        return true;
    }

    @Override
    boolean isNotInitialValue(AbstractCSSValue cssVal, String propertyName) {
        return cssVal != null && !OrderedTwoValueShorthandBuilder.isInitialIdentifier(cssVal) && !this.valueEquals(this.getInitialPropertyValue(propertyName), cssVal);
    }

    private void appendValueText(StringBuilder buf, AbstractCSSValue cssVal, boolean prepend) {
        if (prepend) {
            buf.append(' ');
        }
        buf.append(cssVal.getMinifiedCssText(this.getShorthandName()));
    }
}

