/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.doc.style.css.property.AbstractCSSPrimitiveValue;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.CSSIdentifierValue;
import io.sf.carte.doc.style.css.property.CSSURIValue;
import io.sf.carte.doc.style.css.property.ColorIdentifiers;
import io.sf.carte.doc.style.css.property.PropertyDatabase;
import io.sf.carte.doc.style.css.property.SystemDefaultValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSPrimitiveValue;

abstract class ShorthandBuilder {
    private final String shorthandName;
    private BaseCSSStyleDeclaration parentStyle;
    private String[] subp;
    private Set<String> impPtySet = new TreeSet<String>();
    private Set<String> ptySet = new TreeSet<String>();

    ShorthandBuilder(String shorthandName, BaseCSSStyleDeclaration parentStyle) {
        this.shorthandName = shorthandName;
        this.parentStyle = parentStyle;
        this.subp = PropertyDatabase.getInstance().getShorthandSubproperties(shorthandName);
    }

    BaseCSSStyleDeclaration getParentStyle() {
        return this.parentStyle;
    }

    String getShorthandName() {
        return this.shorthandName;
    }

    String[] getLonghandProperties() {
        return this.getLonghandProperties(this.getShorthandName());
    }

    String[] getLonghandProperties(String shorthandName) {
        String[] subparray;
        PropertyDatabase pdb = PropertyDatabase.getInstance();
        for (String subproperty : subparray = pdb.getShorthandSubproperties(shorthandName)) {
            if (!pdb.isShorthand(subproperty)) continue;
            return this.longhandArray(pdb, subparray);
        }
        return subparray;
    }

    private String[] longhandArray(PropertyDatabase pdb, String[] subparray) {
        LinkedList<String> list = new LinkedList<String>();
        for (String subproperty : subparray) {
            if (!pdb.isShorthand(subproperty)) {
                list.add(subproperty);
                continue;
            }
            this.addLonghandsToList(pdb, list, subproperty);
        }
        return list.toArray(new String[0]);
    }

    private void addLonghandsToList(PropertyDatabase pdb, LinkedList<String> list, String property) {
        if (!pdb.isShorthand(property)) {
            list.add(property);
        } else {
            String[] ptysubp;
            for (String pty : ptysubp = pdb.getShorthandSubproperties(property)) {
                this.addLonghandsToList(pdb, list, pty);
            }
        }
    }

    String[] getSubproperties() {
        return this.subp;
    }

    AbstractCSSValue getCSSValue(String propertyName) {
        return this.parentStyle.getCSSValue(propertyName);
    }

    AbstractCSSValue getInitialPropertyValue(String propertyName) {
        PropertyDatabase pdb = PropertyDatabase.getInstance();
        if (this.parentStyle instanceof ComputedCSSStyle) {
            return this.parentStyle.defaultPropertyValue(propertyName, pdb);
        }
        AbstractCSSValue defval = pdb.getInitialValue(propertyName);
        if (defval == null) {
            if (propertyName.equals("color")) {
                defval = SystemDefaultValue.getInstance();
            } else if (propertyName.equals("font-family")) {
                defval = SystemDefaultValue.getInstance();
            } else if (propertyName.equals("text-align")) {
                String directionValue = this.parentStyle.getPropertyValue("direction");
                defval = directionValue.equals("rtl") ? new CSSIdentifierValue("right") : new CSSIdentifierValue("left");
            } else if (propertyName.equals("background-color")) {
                defval = new CSSIdentifierValue("transparent");
            } else if (propertyName.endsWith("-color")) {
                defval = new CSSIdentifierValue("currentcolor");
            } else if (propertyName.equals("quotes")) {
                defval = new ValueFactory().parseProperty("\" \"");
            }
        }
        return defval;
    }

    boolean isPropertyAssigned(String propertyName, boolean important) {
        return this.parentStyle.isPropertySet(propertyName, important);
    }

    boolean isPropertyAssigned(String property) {
        return this.ptySet.contains(property) || this.impPtySet.contains(property);
    }

    boolean isPropertyImportant(String property) {
        return this.impPtySet.contains(property);
    }

    void addAssignedProperty(String propertyName, boolean important) {
        if (important) {
            this.impPtySet.add(propertyName);
        } else {
            this.ptySet.add(propertyName);
        }
    }

    void appendCssText(StringBuilder buf) {
        int len = buf.length();
        if (!this.appendShorthandText(buf)) {
            buf.setLength(len);
            this.appendIndividualProperties(buf);
        }
    }

    void appendIndividualProperties(StringBuilder buf) {
        for (String ptyname : this.impPtySet) {
            buf.append(ptyname);
            buf.append(':').append(' ');
            BaseCSSStyleDeclaration.appendCssText(buf, this.getCSSValue(ptyname));
            buf.append(" ! important");
            buf.append(';').append(' ');
        }
        for (String ptyname : this.ptySet) {
            buf.append(ptyname);
            buf.append(':').append(' ');
            BaseCSSStyleDeclaration.appendCssText(buf, this.getCSSValue(ptyname));
            buf.append(';').append(' ');
        }
    }

    void appendMinifiedCssText(StringBuilder buf) {
        int len = buf.length();
        if (!this.appendShorthandText(buf)) {
            buf.setLength(len);
            this.appendMinifiedIndividualProperties(buf);
        }
    }

    void appendMinifiedIndividualProperties(StringBuilder buf) {
        this.appendImportantProperties(buf);
        this.appendNonImportantProperties(buf);
    }

    private void appendImportantProperties(StringBuilder buf) {
        for (String property : this.impPtySet) {
            buf.append(property).append(':');
            BaseCSSStyleDeclaration.appendMinifiedCssText(buf, this.getCSSValue(property), property);
            buf.append("!important;");
        }
    }

    private void appendNonImportantProperties(StringBuilder buf) {
        for (String property : this.ptySet) {
            buf.append(property).append(':');
            BaseCSSStyleDeclaration.appendMinifiedCssText(buf, this.getCSSValue(property), property);
            buf.append(';');
        }
    }

    boolean appendShorthandText(StringBuilder buf) {
        this.preprocessSet();
        int sz = this.getMinimumSetSize();
        if (this.getTotalSetSize() < sz) {
            return false;
        }
        return this.processPriorities(buf);
    }

    void preprocessSet() {
    }

    int getTotalSetSize() {
        return this.impPtySet.size() + this.ptySet.size();
    }

    boolean processPriorities(StringBuilder buf) {
        int sz = this.getMinimumSetSize();
        int impsz = this.impPtySet.size();
        if (impsz < sz) {
            if (!this.appendShorthandSet(buf, this.ptySet, false)) {
                return false;
            }
            if (impsz != 0) {
                this.appendImportantProperties(buf);
            }
        } else {
            if (this.ptySet.size() != 0) {
                int len = buf.length();
                if (!this.appendShorthandSet(buf, this.ptySet, false)) {
                    buf.setLength(len);
                    this.appendNonImportantProperties(buf);
                }
            }
            if (!this.appendShorthandSet(buf, this.impPtySet, true)) {
                return false;
            }
        }
        return true;
    }

    byte checkValuesForInherit(Set<String> declaredSet) {
        return this.checkValuesForInherit(this.getShorthandName(), declaredSet);
    }

    byte checkValuesForInherit(String shorthand, Set<String> declaredSet) {
        String[] properties;
        int count = 0;
        int expect = 0;
        for (String propertyName : properties = this.getLonghandProperties(shorthand)) {
            if (!declaredSet.contains(propertyName)) continue;
            expect = (byte)(expect + 1);
            if (!this.isInherit(this.getCSSValue(propertyName))) continue;
            count = (byte)(count + 1);
        }
        if (count == 0) {
            return 0;
        }
        if (count == expect) {
            return 1;
        }
        return 2;
    }

    byte checkDeclaredValuesForInherit(Set<String> declaredSet) {
        byte count = 0;
        for (String propertyName : declaredSet) {
            if (!this.isInherit(this.getCSSValue(propertyName))) continue;
            count = (byte)(count + 1);
        }
        if (count == 0) {
            return 0;
        }
        if (count == (byte)declaredSet.size()) {
            return 1;
        }
        return 2;
    }

    boolean isInherit(AbstractCSSValue value) {
        return value != null && value.getCssValueType() == 0;
    }

    byte checkDeclaredValuesForKeyword(String keyword, Set<String> declaredSet) {
        byte count = 0;
        for (String propertyName : declaredSet) {
            if (!this.isCssKeywordValue(keyword, this.getCSSValue(propertyName))) continue;
            count = (byte)(count + 1);
        }
        if (count == 0) {
            return 0;
        }
        if (count == (byte)declaredSet.size()) {
            return 1;
        }
        return 2;
    }

    byte checkValuesForKeyword(String keyword, Set<String> declaredSet) {
        return this.checkValuesForKeyword(keyword, this.getShorthandName(), declaredSet);
    }

    byte checkValuesForKeyword(String keyword, String shorthand, Set<String> declaredSet) {
        String[] properties;
        int count = 0;
        int expect = 0;
        for (String propertyName : properties = this.getLonghandProperties(shorthand)) {
            if (!declaredSet.contains(propertyName)) continue;
            expect = (byte)(expect + 1);
            if (!this.isCssKeywordValue(keyword, this.getCSSValue(propertyName))) continue;
            count = (byte)(count + 1);
        }
        if (count == 0) {
            return 0;
        }
        if (count == expect) {
            return 1;
        }
        return 2;
    }

    boolean isCssKeywordValue(String keyword, AbstractCSSValue cssValue) {
        return cssValue != null && cssValue.getCssValueType() == 1 && ((CSSPrimitiveValue)((Object)cssValue)).getPrimitiveType() == 21 && keyword.equalsIgnoreCase(((CSSPrimitiveValue)((Object)cssValue)).getStringValue());
    }

    String getValueTextIfNotInitial(String propertyName, AbstractCSSValue cssVal) {
        if (!(cssVal == null || cssVal.isSystemDefault() || ShorthandBuilder.isInitialIdentifier(cssVal) || this.valueEquals(this.getInitialPropertyValue(propertyName), cssVal))) {
            return cssVal.getMinifiedCssText(propertyName);
        }
        return null;
    }

    static boolean isInitialIdentifier(AbstractCSSValue cssVal) {
        return cssVal.getCssValueType() == 1 && ((CSSPrimitiveValue)((Object)cssVal)).getPrimitiveType() == 21 && ((CSSPrimitiveValue)((Object)cssVal)).getStringValue().toLowerCase(Locale.US).equals("initial");
    }

    boolean isInitialValue(String propertyName) {
        AbstractCSSValue cssVal = this.getCSSValue(propertyName);
        return cssVal.isSystemDefault() || ShorthandBuilder.isInitialIdentifier(cssVal) || this.valueEquals(this.getInitialPropertyValue(propertyName), cssVal);
    }

    boolean isNotInitialValue(AbstractCSSValue cssVal, String propertyName) {
        return cssVal != null && !cssVal.isSystemDefault() && !ShorthandBuilder.isInitialIdentifier(cssVal) && !this.valueEquals(this.getInitialPropertyValue(propertyName), cssVal);
    }

    boolean isUnknownIdentifier(String propertyName, AbstractCSSValue value) {
        String s;
        CSSPrimitiveValue primi;
        if (value.getCssValueType() == 1 && (primi = (CSSPrimitiveValue)((Object)value)).getPrimitiveType() == 21 && !"none".equalsIgnoreCase(s = primi.getStringValue())) {
            PropertyDatabase pdb = PropertyDatabase.getInstance();
            return !pdb.isIdentifierValue(propertyName, s);
        }
        return false;
    }

    boolean valueEquals(AbstractCSSValue value1, AbstractCSSValue value2) {
        if (value2 == null) {
            return value1 == null;
        }
        if (value1 == null) {
            return false;
        }
        if (value2.isSystemDefault() != value1.isSystemDefault()) {
            return false;
        }
        if (value1.getCssValueType() == 1 && value2.getCssValueType() == 1) {
            AbstractCSSPrimitiveValue pvalue1 = (AbstractCSSPrimitiveValue)value1;
            short type1 = pvalue1.getPrimitiveType();
            AbstractCSSPrimitiveValue pvalue2 = (AbstractCSSPrimitiveValue)value2;
            short type2 = pvalue2.getPrimitiveType();
            if (type1 == 21) {
                if (type2 == 25) {
                    return this.testColorIdentifier(pvalue2, pvalue1.getStringValue());
                }
                if (type2 == 21) {
                    return pvalue1.getStringValue().equalsIgnoreCase(pvalue2.getStringValue());
                }
            } else if (type1 == 25 && type2 == 21) {
                return this.testColorIdentifier(pvalue1, pvalue2.getStringValue());
            }
        }
        return value1.equals(value2);
    }

    private boolean testColorIdentifier(AbstractCSSPrimitiveValue color, String ident) {
        String spec = "transparent".equals(ident) ? "rgba(0,0,0,0)" : ColorIdentifiers.getInstance().getColor(ident);
        if (spec != null) {
            ValueFactory factory = new ValueFactory();
            try {
                CSSPrimitiveValue val = (CSSPrimitiveValue)((Object)factory.parseProperty(spec));
                return val.getRGBColorValue().equals(color.getRGBColorValue());
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        return false;
    }

    boolean appendValueIfNotInitial(StringBuilder buf, String propertyName, boolean prepend) {
        AbstractCSSValue cssVal = this.getCSSValue(propertyName);
        if (this.isNotInitialValue(cssVal, propertyName)) {
            if (prepend) {
                buf.append(' ');
            }
            buf.append(cssVal.getMinifiedCssText(propertyName));
            return true;
        }
        return prepend;
    }

    void appendPriority(StringBuilder buf, boolean important) {
        if (important) {
            buf.append("!important;");
        } else {
            buf.append(';');
        }
    }

    boolean appendRelativeURI(StringBuilder buf, boolean prepend, AbstractCSSValue value) {
        String text;
        if (value.getCssValueType() == 1) {
            CSSPrimitiveValue pvalue = (CSSPrimitiveValue)((Object)value);
            short type = pvalue.getPrimitiveType();
            if (type == 20) {
                URL url = ((CSSURIValue)pvalue).getURLValue();
                if (url != null) {
                    String baseuri = this.getBaseURI();
                    text = baseuri != null ? ShorthandBuilder.relativeURI(baseuri, url) : url.toExternalForm();
                    text = "url('" + text + "')";
                } else {
                    text = pvalue.getCssText();
                }
            } else if (type == 21) {
                text = pvalue.getStringValue();
                if ("none".equalsIgnoreCase(text) || "initial".equalsIgnoreCase(text)) {
                    return false;
                }
            } else {
                text = value.getMinifiedCssText("background-image");
            }
        } else {
            text = value.getMinifiedCssText("background-image");
        }
        if (prepend) {
            buf.append(' ');
        }
        buf.append(text);
        return true;
    }

    String getBaseURI() {
        Document document;
        Node node = this.getParentStyle().getOwnerNode();
        String baseuri = null;
        if (node != null && (document = node.getOwnerDocument()) != null) {
            baseuri = document.getBaseURI();
        }
        return baseuri;
    }

    static String relativeURI(String baseuri, URL url) {
        try {
            URL base = new URL(baseuri);
            if (ShorthandBuilder.sameTree(base, url)) {
                try {
                    return base.toURI().relativize(url.toURI()).toString();
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        String uri = url.toExternalForm();
        return uri;
    }

    static boolean sameTree(URL base, URL url) {
        if (base.getProtocol().equals(url.getProtocol())) {
            String bhost = base.getHost();
            String uhost = url.getHost();
            if (bhost != null) {
                if (bhost.equals(uhost)) {
                    int bport = base.getPort();
                    int uport = url.getPort();
                    if (bport == -1) {
                        bport = base.getDefaultPort();
                    }
                    if (uport == -1) {
                        uport = url.getDefaultPort();
                    }
                    return bport == uport;
                }
            } else {
                return uhost == null;
            }
        }
        return false;
    }

    int getMinimumSetSize() {
        return this.getLonghandProperties().length;
    }

    abstract boolean appendShorthandSet(StringBuilder var1, Set<String> var2, boolean var3);
}

