/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.property.AbstractCSSPrimitiveValue;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.CSSIdentifierValue;
import io.sf.carte.doc.style.css.property.CSSInheritValue;
import io.sf.carte.doc.style.css.property.OMCSSValueList;
import io.sf.carte.doc.style.css.property.PropertyDatabase;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSValue;

class ShorthandSetter
implements BaseCSSStyleDeclaration.SubpropertySetter {
    BaseCSSStyleDeclaration styleDeclaration;
    private final String shorthandName;
    private String priority = null;
    private PropertyDatabase pdb = PropertyDatabase.getInstance();
    ValueFactory valueFactory = new ValueFactory();
    private HashMap<String, AbstractCSSValue> mypropValue = new HashMap();
    private LinkedList<String> mypropertyList = new LinkedList();
    private LinkedList<String> mypriorities = new LinkedList();
    protected LexicalUnit currentValue = null;
    private StringBuilder valueBuffer = new StringBuilder(40);
    private ArrayList<String> unassignedProperties = new ArrayList(6);

    ShorthandSetter(BaseCSSStyleDeclaration style, String shorthandName) {
        this.styleDeclaration = style;
        this.shorthandName = shorthandName;
    }

    public String getShorthandName() {
        return this.shorthandName;
    }

    public String getPriority() {
        return this.priority;
    }

    protected void setPriority(String priority) {
        this.priority = priority;
    }

    public final PropertyDatabase getPropertyDatabase() {
        return this.pdb;
    }

    protected void addUnassignedProperty(String propertyName) {
        this.unassignedProperties.add(propertyName);
    }

    protected List<String> getUnassignedProperties() {
        return this.unassignedProperties;
    }

    protected boolean scanUnassigned(List<LexicalUnit> unassignedValues) {
        block0: for (LexicalUnit lu : unassignedValues) {
            StyleDeclarationErrorHandler errHandler;
            if (lu.getLexicalUnitType() == 35) {
                if (!this.isNotValidIdentifier(lu)) continue;
                String sv = lu.getStringValue();
                Iterator<String> it = this.getUnassignedProperties().iterator();
                while (it.hasNext()) {
                    String property = it.next();
                    if (!property.endsWith("-color") || !sv.endsWith("-color")) continue;
                    this.setSubpropertyValue(property, this.createCSSValue(property, lu));
                    it.remove();
                    continue block0;
                }
            } else if (lu.getLexicalUnitType() == 41) {
                Iterator<String> it = this.getUnassignedProperties().iterator();
                while (it.hasNext()) {
                    String property = it.next();
                    if (!property.endsWith("-color")) continue;
                    for (LexicalUnit param = lu.getParameters(); param != null; param = param.getNextLexicalUnit()) {
                        if (!BaseCSSStyleDeclaration.testColor(param)) continue;
                        this.setSubpropertyValue(property, this.createCSSValue(property, lu));
                        it.remove();
                        continue block0;
                    }
                }
            }
            if ((errHandler = this.styleDeclaration.getStyleDeclarationErrorHandler()) != null) {
                errHandler.unassignedShorthandValue(this.getShorthandName(), lu.toString());
            }
            return false;
        }
        return true;
    }

    byte scanForCssWideKeywords(LexicalUnit lunit) {
        String keyword;
        if (lunit.getLexicalUnitType() == 12) {
            if (lunit.getNextLexicalUnit() != null) {
                this.reportMixedKeywords("inherit");
                return 2;
            }
            CSSInheritValue inherit = CSSInheritValue.getValue().asSubproperty();
            this.setSubpropertiesInherit(inherit);
            this.initValueString();
            this.appendValueItemString(inherit);
            return 1;
        }
        if (lunit.getLexicalUnitType() == 35 && ((keyword = lunit.getStringValue()).equalsIgnoreCase("initial") || keyword.equalsIgnoreCase("unset"))) {
            if (lunit.getNextLexicalUnit() != null) {
                this.reportMixedKeywords(keyword);
                return 2;
            }
            AbstractCSSValue cssval = this.valueFactory.createCSSValueItem(lunit, true).getCSSValue();
            this.setSubpropertiesToKeyword(cssval);
            this.initValueString();
            this.appendValueItemString(cssval);
            return 1;
        }
        return 0;
    }

    private void reportMixedKeywords(String keyword) {
        StyleDeclarationErrorHandler errHandler = this.styleDeclaration.getStyleDeclarationErrorHandler();
        if (errHandler != null) {
            errHandler.shorthandError(this.getShorthandName(), "Found '" + keyword + "' keyword mixed with other values");
        }
    }

    void setSubpropertiesInherit(CSSInheritValue inherit) {
        String[] subparray;
        for (String subp : subparray = this.getShorthandSubproperties()) {
            String[] sh;
            if (!this.getPropertyDatabase().isShorthand(subp)) {
                this.styleDeclaration.setProperty(subp, inherit, this.getPriority());
                continue;
            }
            for (String s : sh = this.getPropertyDatabase().getShorthandSubproperties(subp)) {
                this.styleDeclaration.setProperty(s, inherit, this.getPriority());
            }
        }
    }

    void setSubpropertiesToKeyword(AbstractCSSValue keyword) {
        String[] subparray;
        for (String subp : subparray = this.getShorthandSubproperties()) {
            String[] sh;
            if (!this.getPropertyDatabase().isShorthand(subp)) {
                this.styleDeclaration.setProperty(subp, keyword, this.getPriority());
                continue;
            }
            for (String s : sh = this.getPropertyDatabase().getShorthandSubproperties(subp)) {
                this.styleDeclaration.setProperty(s, keyword, this.getPriority());
            }
        }
    }

    String[] getShorthandSubproperties() {
        return this.getPropertyDatabase().getShorthandSubproperties(this.getShorthandName());
    }

    protected void nextCurrentValue() {
        if (this.currentValue != null) {
            this.currentValue = this.currentValue.getNextLexicalUnit();
            this.appendValueItemString();
        }
    }

    @Override
    public void init(LexicalUnit shorthandValue, String priority) {
        this.currentValue = shorthandValue;
        this.setPriority(priority);
        this.unassignedProperties.clear();
        this.initValueString();
        this.appendValueItemString();
    }

    protected void resetSubproperties() {
        List<String> props = this.getUnassignedProperties();
        for (String pname : props) {
            if (!this.getPropertyDatabase().isShorthand(pname)) {
                this.setPropertyToDefault(pname);
                continue;
            }
            String[] sh = this.getPropertyDatabase().getShorthandSubproperties(pname);
            for (int i = 0; i < sh.length; ++i) {
                this.setPropertyToDefault(sh[i]);
            }
        }
    }

    void setSubpropertiesToDefault() {
        String[] subp;
        for (String pname : subp = this.getShorthandSubproperties()) {
            if (!this.getPropertyDatabase().isShorthand(pname)) {
                this.setPropertyToDefault(pname);
                continue;
            }
            String[] sh = this.getPropertyDatabase().getShorthandSubproperties(pname);
            for (int i = 0; i < sh.length; ++i) {
                this.setPropertyToDefault(sh[i]);
            }
        }
    }

    protected AbstractCSSValue defaultPropertyValue(String propertyName) {
        AbstractCSSValue cssVal = this.styleDeclaration.defaultPropertyValue(propertyName, this.getPropertyDatabase());
        if (cssVal != null) {
            short type = cssVal.getCssValueType();
            if (type == 1) {
                ((AbstractCSSPrimitiveValue)cssVal).setSubproperty(true);
            } else if (type == 2) {
                ((OMCSSValueList)cssVal).setSubproperty(true);
            }
        } else {
            CSSIdentifierValue ident = new CSSIdentifierValue();
            ident.setStringValue((short)21, "initial");
            ident.setSubproperty(true);
            cssVal = ident;
        }
        return cssVal;
    }

    void setPropertyToDefault(String pname) {
        AbstractCSSValue cssVal = this.defaultPropertyValue(pname);
        this.setProperty(pname, cssVal, this.getPriority());
    }

    void setDeclarationPropertyToDefault(String propertyName) {
        AbstractCSSValue cssVal = this.defaultPropertyValue(propertyName);
        this.styleDeclaration.setProperty(propertyName, cssVal, this.getPriority());
    }

    protected List<String> subpropertyList() {
        String[] subparray = this.getShorthandSubproperties();
        ArrayList<String> subp = new ArrayList<String>(subparray.length);
        subp.addAll(Arrays.asList((Object[])subparray.clone()));
        return subp;
    }

    @Override
    public boolean assignSubproperties() {
        byte kwscan = this.scanForCssWideKeywords(this.currentValue);
        if (kwscan == 1) {
            return true;
        }
        if (kwscan == 2) {
            return false;
        }
        LinkedList<LexicalUnit> unassignedValues = new LinkedList<LexicalUnit>();
        List<String> subp = this.subpropertyList();
        while (this.currentValue != null) {
            boolean assigned = false;
            for (int i = 0; i < subp.size(); ++i) {
                String pname = subp.get(i);
                if (!this.assignSubproperty(pname)) continue;
                subp.remove(i);
                assigned = true;
                break;
            }
            if (assigned) continue;
            unassignedValues.add(this.currentValue);
            this.nextCurrentValue();
        }
        if (!subp.isEmpty()) {
            Iterator<String> it = subp.iterator();
            while (it.hasNext()) {
                this.addUnassignedProperty(it.next());
            }
        }
        if (!unassignedValues.isEmpty() && !this.scanUnassigned(unassignedValues)) {
            return false;
        }
        this.resetSubproperties();
        this.flush();
        return true;
    }

    boolean isNotValidIdentifier(LexicalUnit lu) {
        return !lu.getStringValue().equalsIgnoreCase("none");
    }

    protected boolean assignSubproperty(String subproperty) {
        short lutype = this.currentValue.getLexicalUnitType();
        if (lutype == 35 && this.assignIdentifiers(subproperty)) {
            return true;
        }
        return subproperty.endsWith("-color") ? BaseCSSStyleDeclaration.testColor(this.currentValue) && this.setCurrentValue(subproperty) : (subproperty.endsWith("-width") ? ValueFactory.isSizeSACUnit(this.currentValue) && this.setCurrentValue(subproperty) : subproperty.endsWith("-image") && this.isImage() && this.setCurrentValue(subproperty));
    }

    boolean isImage() {
        return this.currentValue.getLexicalUnitType() == 24 || this.isGradientValue();
    }

    boolean setCurrentValue(String subproperty) {
        AbstractCSSValue cssValue = this.createCSSValue(subproperty, this.currentValue);
        if (cssValue != null) {
            this.setSubpropertyValue(subproperty, cssValue);
            this.nextCurrentValue();
            return true;
        }
        return false;
    }

    protected boolean assignIdentifiers(String subproperty) {
        if (this.testIdentifiers(subproperty)) {
            AbstractCSSValue cssValue = this.createCSSValue(subproperty, this.currentValue);
            this.setSubpropertyValue(subproperty, cssValue);
            this.nextCurrentValue();
            return true;
        }
        return false;
    }

    protected boolean testIdentifiers(String subproperty) {
        return this.getPropertyDatabase().isIdentifierValue(subproperty, this.currentValue.getStringValue());
    }

    protected void setSubpropertyValue(String subproperty, AbstractCSSValue cssValue) {
        this.setProperty(subproperty, cssValue, this.getPriority());
    }

    void setSubpropertyValueWListCheck(String property, AbstractCSSValue value) {
        OMCSSValueList list;
        if (value.getCssValueType() == 2 && (list = (OMCSSValueList)value).getLength() == 1) {
            value = list.item(0);
        }
        this.setSubpropertyValue(property, value);
    }

    protected void addSubpropertyValue(String subproperty, AbstractCSSValue cssValue, boolean commaList) {
        AbstractCSSValue cssval = this.getDeclaredCSSValue(subproperty);
        if (cssval == null) {
            this.setSubpropertyValue(subproperty, cssValue);
        } else {
            switch (cssval.getCssValueType()) {
                case 2: {
                    ((OMCSSValueList)cssval).add(cssValue);
                    cssValue = cssval;
                    break;
                }
                default: {
                    OMCSSValueList list = commaList ? OMCSSValueList.createCSValueList() : OMCSSValueList.createWSValueList();
                    list.add(cssval);
                    list.add(cssValue);
                    cssValue = list;
                }
            }
            this.setProperty(subproperty, cssValue, this.getPriority());
        }
    }

    protected void setProperty(String subpropertyName, AbstractCSSValue cssValue, String priority) {
        this.mypropertyList.add(subpropertyName);
        this.mypriorities.add(priority);
        this.mypropValue.put(subpropertyName, cssValue);
    }

    protected boolean isPropertySet(String subpropertyName) {
        return this.mypropertyList.contains(subpropertyName);
    }

    protected AbstractCSSValue getDeclaredCSSValue(String propertyName) {
        return this.mypropValue.get(propertyName);
    }

    void flush() {
        int i = 0;
        for (String myproperty : this.mypropertyList) {
            this.styleDeclaration.setProperty(myproperty, this.mypropValue.get(myproperty), this.mypriorities.get(i));
            ++i;
        }
        this.mypropertyList.clear();
        this.mypriorities.clear();
        this.mypropValue.clear();
    }

    AbstractCSSValue createCSSValue() throws DOMException {
        StyleDeclarationErrorHandler errHandler;
        ValueItem item = this.valueFactory.createCSSValueItem(this.currentValue, true);
        if (item.hasWarnings() && (errHandler = this.styleDeclaration.getStyleDeclarationErrorHandler()) != null) {
            item.handleSyntaxWarnings(errHandler);
        }
        this.currentValue = item.getNextLexicalUnit();
        return item.getCSSValue();
    }

    AbstractCSSValue createCSSValue(String propertyName, LexicalUnit lunit) throws DOMException {
        return this.createCSSValue(propertyName, lunit, true);
    }

    AbstractCSSValue createCSSValue(String propertyName, LexicalUnit lunit, boolean subproperty) throws DOMException {
        StyleDeclarationErrorHandler errHandler;
        ValueItem item = this.valueFactory.createCSSValueItem(lunit, subproperty);
        AbstractCSSValue cssVal = item.getCSSValue();
        if (item.hasWarnings() && (errHandler = this.styleDeclaration.getStyleDeclarationErrorHandler()) != null) {
            item.handleSyntaxWarnings(errHandler);
        }
        return cssVal;
    }

    protected void initValueString() {
        this.valueBuffer.setLength(0);
    }

    protected void appendValueItemString(CSSValue cssValue) {
        if (cssValue != null) {
            String cssText = cssValue.getCssText();
            StringBuilder buf = this.getValueItemBuffer();
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append(cssText);
        }
    }

    protected void appendValueItemString() {
        if (this.currentValue != null) {
            this.valueFactory.appendValueString(this.getValueItemBuffer(), this.currentValue);
        }
    }

    StringBuilder getValueItemBuffer() {
        return this.valueBuffer;
    }

    protected void appendToValueBuffer(StringBuilder buf) {
        this.valueBuffer.append((CharSequence)buf);
    }

    @Override
    public String getCssText() {
        return this.valueBuffer.toString();
    }

    boolean isGradientValue() {
        return this.currentValue.getLexicalUnitType() == 41 && this.currentValue.getFunctionName().toLowerCase(Locale.US).endsWith("-gradient");
    }

    void reportDeclarationError(String propertyName, String message) {
        BaseCSSDeclarationRule prule = this.styleDeclaration.getParentRule();
        if (prule != null) {
            prule.getStyleDeclarationErrorHandler().shorthandError(propertyName, message);
        }
    }
}

