/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.CSSInheritValue;
import io.sf.carte.doc.style.css.property.OMCSSValueList;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueItem;
import java.util.Locale;
import org.w3c.css.sac.LexicalUnit;

class TransitionShorthandSetter
extends ShorthandSetter {
    private String cssText = null;
    private int transitionsCount = 0;
    private OMCSSValueList lstProperty = OMCSSValueList.createCSValueList();
    private OMCSSValueList lstDuration = OMCSSValueList.createCSValueList();
    private OMCSSValueList lstTiming = OMCSSValueList.createCSValueList();
    private OMCSSValueList lstDelay = OMCSSValueList.createCSValueList();

    TransitionShorthandSetter(BaseCSSStyleDeclaration style) {
        super(style, "transition");
    }

    @Override
    public void init(LexicalUnit shorthandValue, String priority) {
        this.currentValue = shorthandValue;
        this.setPriority(priority);
        this.setCssText(shorthandValue);
        this.countTransitions(shorthandValue);
    }

    private void setCssText(LexicalUnit value) {
        StringBuilder valueBuffer = new StringBuilder(32);
        block5: do {
            switch (value.getLexicalUnitType()) {
                case 0: {
                    valueBuffer.append(',');
                    break;
                }
                case 4: {
                    valueBuffer.append('/');
                    break;
                }
                case 6: {
                    valueBuffer.append('^');
                    break;
                }
                default: {
                    ValueItem item = this.valueFactory.createCSSValueItem(value, true);
                    AbstractCSSValue cssVal = item.getCSSValue();
                    String cssText = cssVal.getCssText();
                    if (valueBuffer.length() > 0) {
                        valueBuffer.append(' ');
                    }
                    valueBuffer.append(cssText);
                    if (cssVal.getCssValueType() == 1) {
                        value = item.getNextLexicalUnit();
                        continue block5;
                    }
                    value = value.getNextLexicalUnit();
                    continue block5;
                }
            }
            value = value.getNextLexicalUnit();
        } while (value != null);
        this.cssText = valueBuffer.toString();
    }

    @Override
    public String getCssText() {
        return this.cssText;
    }

    protected void countTransitions(LexicalUnit shorthandValue) {
        this.transitionsCount = 0;
        int valueCount = 0;
        for (LexicalUnit value = shorthandValue; value != null; value = value.getNextLexicalUnit()) {
            if (value.getLexicalUnitType() == 0) {
                if (valueCount <= 0) continue;
                ++this.transitionsCount;
                valueCount = 0;
                continue;
            }
            ++valueCount;
        }
        if (valueCount > 0) {
            ++this.transitionsCount;
        }
    }

    @Override
    public boolean assignSubproperties() {
        int lastTdurCopied = 0;
        int lastTimingCopied = 0;
        int lastDelayCopied = 0;
        int i = 0;
        block0: while (i < this.transitionsCount && this.currentValue != null) {
            boolean tpropUnset = true;
            boolean tdurUnset = true;
            boolean ttfUnset = true;
            boolean tdelayUnset = true;
            while (this.currentValue != null) {
                AbstractCSSValue value;
                String sv;
                short lut = this.currentValue.getLexicalUnitType();
                if (lut == 0) {
                    ++i;
                    this.nextCurrentValue();
                    break;
                }
                if (this.currentValue.getLexicalUnitType() == 12) {
                    while (this.currentValue != null) {
                        boolean commaFound = this.currentValue.getLexicalUnitType() == 0;
                        this.currentValue = this.currentValue.getNextLexicalUnit();
                        if (!commaFound) continue;
                        break;
                    }
                    this.clearLayer(++i);
                    CSSInheritValue inherit = CSSInheritValue.getValue().asSubproperty();
                    this.addSingleValueLayer(inherit);
                    this.appendValueItemString(inherit);
                    continue block0;
                }
                if (this.currentValue.getLexicalUnitType() == 35 && ("initial".equals(sv = this.currentValue.getStringValue().toLowerCase(Locale.US)) || "unset".equals(sv))) {
                    AbstractCSSValue keyword = this.valueFactory.createCSSValueItem(this.currentValue, true).getCSSValue();
                    while (this.currentValue != null) {
                        boolean commaFound = this.currentValue.getLexicalUnitType() == 0;
                        this.currentValue = this.currentValue.getNextLexicalUnit();
                        if (!commaFound) continue;
                        break;
                    }
                    this.clearLayer(++i);
                    this.addSingleValueLayer(keyword);
                    this.appendValueItemString(keyword);
                    continue block0;
                }
                if ((tdurUnset || tdelayUnset) && ValueFactory.isTimeSACUnit(this.currentValue)) {
                    if (tdurUnset) {
                        value = this.createCSSValue("transition-duration", this.currentValue);
                        if (value != null) {
                            this.lstDuration.add(value);
                            tdurUnset = false;
                            this.nextCurrentValue();
                            continue;
                        }
                    } else {
                        value = this.createCSSValue("transition-delay", this.currentValue);
                        if (value != null) {
                            this.lstDelay.add(value);
                            tdelayUnset = false;
                            this.nextCurrentValue();
                            continue;
                        }
                    }
                }
                if (ttfUnset) {
                    if (35 == lut) {
                        if (this.testIdentifiers("transition-timing-function")) {
                            value = this.createCSSValue("transition-timing-function", this.currentValue);
                            this.lstTiming.add(value);
                            ttfUnset = false;
                            this.nextCurrentValue();
                            continue;
                        }
                    } else if (lut == 41 && (value = this.createCSSValue("transition-timing-function", this.currentValue)) != null) {
                        this.lstTiming.add(value);
                        ttfUnset = false;
                        this.nextCurrentValue();
                        continue;
                    }
                }
                if (tpropUnset && (lut == 35 || lut == 36)) {
                    value = this.createCSSValue("transition-property", this.currentValue);
                    if (!"none".equals(value.getCssText()) || this.transitionsCount == 1) {
                        this.lstProperty.add(value);
                        tpropUnset = false;
                        this.nextCurrentValue();
                        continue;
                    }
                    this.lstProperty.clear();
                    this.lstDuration.clear();
                    this.lstTiming.clear();
                    this.lstDelay.clear();
                    this.cssText = "";
                    StyleDeclarationErrorHandler errHandler = this.styleDeclaration.getStyleDeclarationErrorHandler();
                    if (errHandler != null) {
                        errHandler.shorthandError("transition", "Found 'none' in a multiple declaration");
                    }
                    return false;
                }
                StyleDeclarationErrorHandler errHandler = this.styleDeclaration.getStyleDeclarationErrorHandler();
                if (errHandler != null) {
                    if (lut == 35) {
                        errHandler.unknownIdentifier("transition", this.currentValue.getStringValue());
                    } else {
                        AbstractCSSValue val = this.createCSSValue("transition", this.currentValue);
                        errHandler.unassignedShorthandValue("transition", val.getCssText());
                    }
                }
                return false;
            }
            if (tpropUnset) {
                this.lstProperty.add(this.defaultPropertyValue("transition-property"));
            }
            if (tdurUnset) {
                if (i == 0 || this.lstDuration.isEmpty()) {
                    this.lstDuration.add(this.defaultPropertyValue("transition-duration"));
                } else {
                    this.lstDuration.add(this.lstDuration.item(lastTdurCopied));
                }
                if (++lastTdurCopied == i) {
                    lastTdurCopied = 0;
                }
            }
            if (ttfUnset) {
                if (i == 0 || this.lstTiming.isEmpty()) {
                    this.lstTiming.add(this.defaultPropertyValue("transition-timing-function"));
                } else {
                    this.lstTiming.add(this.lstTiming.item(lastTimingCopied));
                }
                if (++lastTimingCopied == i) {
                    lastTimingCopied = 0;
                }
            }
            if (!tdelayUnset) continue;
            if (i == 0 || this.lstDelay.isEmpty()) {
                this.lstDelay.add(this.defaultPropertyValue("transition-delay"));
            } else {
                this.lstDelay.add(this.lstDelay.item(lastDelayCopied));
            }
            if (++lastDelayCopied != i) continue;
            lastDelayCopied = 0;
        }
        int sz = this.lstProperty.getLength();
        if (sz > 1) {
            for (i = 1; i < sz; ++i) {
                AbstractCSSValue value = this.lstProperty.item(i);
                if (!"all".equals(value.getCssText())) continue;
                for (int j = i - 1; j != -1; --j) {
                    this.lstDuration.set(j, this.lstDuration.item(i));
                    this.lstTiming.set(j, this.lstTiming.item(i));
                    this.lstDelay.set(j, this.lstDelay.item(i));
                }
            }
        }
        this.setSubpropertyValueWListCheck("transition-property", this.lstProperty);
        this.setSubpropertyValueWListCheck("transition-duration", this.lstDuration);
        this.setSubpropertyValueWListCheck("transition-timing-function", this.lstTiming);
        this.setSubpropertyValueWListCheck("transition-delay", this.lstDelay);
        this.flush();
        return true;
    }

    private void clearLayer(int i) {
        if (this.lstProperty.getLength() == i) {
            this.lstProperty.remove(i - 1);
        }
        if (this.lstDuration.getLength() == i) {
            this.lstDuration.remove(i - 1);
        }
        if (this.lstTiming.getLength() == i) {
            this.lstTiming.remove(i - 1);
        }
        if (this.lstDelay.getLength() == i) {
            this.lstDelay.remove(i - 1);
        }
    }

    private void addSingleValueLayer(AbstractCSSValue keyword) {
        this.lstProperty.add(keyword);
        this.lstDuration.add(keyword);
        this.lstTiming.add(keyword);
        this.lstDelay.add(keyword);
    }
}

