/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSPrimitiveValue2;
import io.sf.carte.doc.style.css.RGBAColor;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.ColorIdentifiers;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueItem;
import java.util.Iterator;
import java.util.LinkedList;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.Counter;
import org.w3c.dom.css.Rect;

public abstract class AbstractCSSPrimitiveValue
extends AbstractCSSValue
implements CSSPrimitiveValue2 {
    private short primitiveType = 0;
    private boolean subproperty = false;

    protected AbstractCSSPrimitiveValue(short unitType) {
        super((short)1);
        this.primitiveType = unitType;
    }

    protected AbstractCSSPrimitiveValue() {
        this(0);
    }

    protected AbstractCSSPrimitiveValue(AbstractCSSPrimitiveValue copied) {
        this(copied.primitiveType);
        this.subproperty = copied.subproperty;
    }

    @Override
    public short getPrimitiveType() {
        return this.primitiveType;
    }

    @Override
    public void setFloatValue(short unitType, float floatValue) throws DOMException {
        throw new DOMException(15, "Not a Float");
    }

    @Override
    public float getFloatValue(short unitType) throws DOMException {
        throw new DOMException(15, "Not a Float");
    }

    @Override
    public void setStringValue(short stringType, String stringValue) throws DOMException {
        throw new DOMException(15, "Not a String");
    }

    @Override
    public String getStringValue() throws DOMException {
        throw new DOMException(15, "Not a String");
    }

    @Override
    public Counter getCounterValue() throws DOMException {
        throw new DOMException(15, "Not a Counter");
    }

    @Override
    public Rect getRectValue() throws DOMException {
        throw new DOMException(15, "Not a Rect");
    }

    @Override
    public RGBAColor getRGBColorValue() throws DOMException {
        String ident;
        String spec;
        if (this.getPrimitiveType() == 21 && (spec = "transparent".equals(ident = this.getStringValue()) ? "rgba(0,0,0,0)" : ColorIdentifiers.getInstance().getColor(ident)) != null) {
            ValueFactory factory = new ValueFactory();
            try {
                AbstractCSSValue val = factory.parseProperty(spec);
                if (val.getCssValueType() == 1 && ((AbstractCSSPrimitiveValue)val).getPrimitiveType() == 25) {
                    return ((AbstractCSSPrimitiveValue)val).getRGBColorValue();
                }
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        throw new DOMException(15, "Not an RGB Color");
    }

    public void setSubproperty(boolean subp) {
        this.subproperty = subp;
    }

    @Override
    public boolean isSubproperty() {
        return this.subproperty;
    }

    void setCSSUnitType(short cssUnitType) {
        this.primitiveType = cssUnitType;
    }

    boolean isNegativeNumber() {
        return false;
    }

    public boolean isNumberZero() {
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.primitiveType;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof AbstractCSSPrimitiveValue)) {
            return false;
        }
        AbstractCSSPrimitiveValue other = (AbstractCSSPrimitiveValue)obj;
        return this.primitiveType == other.primitiveType;
    }

    abstract LexicalSetter newLexicalSetter();

    @Override
    public abstract AbstractCSSPrimitiveValue clone();

    class LexicalSetter
    implements ValueItem {
        LexicalUnit nextLexicalUnit = null;
        private LinkedList<String> syntaxWarnings = null;

        LexicalSetter() {
        }

        void setLexicalUnit(LexicalUnit lunit) throws DOMException {
            AbstractCSSPrimitiveValue.this.setCSSUnitType(ValueFactory.domPrimitiveType(lunit));
        }

        @Override
        public LexicalUnit getNextLexicalUnit() {
            return this.nextLexicalUnit;
        }

        @Override
        public AbstractCSSPrimitiveValue getCSSValue() {
            return AbstractCSSPrimitiveValue.this;
        }

        void reportSyntaxWarning(String message) {
            if (this.syntaxWarnings == null) {
                this.syntaxWarnings = new LinkedList();
            }
            this.syntaxWarnings.add(message);
        }

        @Override
        public boolean hasWarnings() {
            return this.syntaxWarnings != null;
        }

        @Override
        public void handleSyntaxWarnings(StyleDeclarationErrorHandler handler) {
            if (this.syntaxWarnings != null) {
                Iterator it = this.syntaxWarnings.iterator();
                while (it.hasNext()) {
                    handler.syntaxWarning((String)it.next());
                }
            }
        }

        public String toString() {
            return AbstractCSSPrimitiveValue.this.getCssText();
        }
    }
}

