/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import org.w3c.dom.css.CSSStyleDeclaration;

public final class AttributeToStyle {
    public static void bgcolor(String bgcolorAttr, CSSStyleDeclaration style) {
        if (bgcolorAttr.length() != 0) {
            style.setProperty("background-color", bgcolorAttr, null);
        }
    }

    public static void width(String widthAttr, CSSStyleDeclaration style) {
        int attlen = widthAttr.length();
        if (attlen != 0) {
            char c = widthAttr.charAt(attlen - 1);
            if (Character.isDigit(c)) {
                widthAttr = widthAttr + "px";
            }
            style.setProperty("width", widthAttr, null);
        }
    }

    public static void height(String heightAttr, CSSStyleDeclaration style) {
        int attlen = heightAttr.length();
        if (attlen > 0) {
            char c = heightAttr.charAt(attlen - 1);
            if (Character.isDigit(c)) {
                heightAttr = heightAttr + "px";
            }
            style.setProperty("height", heightAttr, null);
        }
    }

    public static void face(String attribute, CSSStyleDeclaration style) {
        if (attribute.length() != 0) {
            style.setProperty("font-family", attribute, null);
        }
    }

    public static void size(String attribute, CSSStyleDeclaration style) {
        if (attribute.length() != 0) {
            style.setProperty("font-size", AttributeToStyle.translateFontSize(attribute), null);
        }
    }

    private static String translateFontSize(String size) {
        if (size.charAt(0) == '+') {
            return "larger";
        }
        if (size.charAt(0) == '-') {
            return "smaller";
        }
        return size.toString();
    }

    public static void color(String attribute, CSSStyleDeclaration style) {
        if (attribute.length() != 0) {
            style.setProperty("color", attribute, null);
        }
    }
}

