/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.property.CSSStringValue;
import java.util.Locale;
import org.w3c.dom.DOMException;

public class CSSIdentifierValue
extends CSSStringValue {
    public CSSIdentifierValue() {
        this.setCSSUnitType((short)21);
    }

    public CSSIdentifierValue(String plainIdentifier) {
        this.setCSSUnitType((short)21);
        this.setStringValue(plainIdentifier);
        this.setPlainCssText(plainIdentifier);
    }

    protected CSSIdentifierValue(CSSIdentifierValue copied) {
        super(copied);
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        if (this.isSubproperty()) {
            throw new DOMException(7, "This property was set with a shorthand. Must modify at the style-declaration level.");
        }
        try {
            this.setStringValue(ParseHelper.unescapeStringValue(cssText));
        }
        catch (NumberFormatException e) {
            this.setStringValue(cssText);
        }
        this.setPlainCssText(cssText);
    }

    @Override
    protected void setStringValue(String value) {
        super.setStringValue(value.intern());
    }

    @Override
    protected void setUnescapedCssText(String css) throws DOMException {
        css = ParseHelper.escapeControl(css);
        css = ParseHelper.escapeCssChars(css);
        this.setPlainCssText(css);
    }

    @Override
    String getEffectiveStringValue() {
        String sv = this.getStringValue();
        return sv != null ? sv.toLowerCase(Locale.US) : null;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CSSIdentifierValue)) {
            return false;
        }
        CSSIdentifierValue other = (CSSIdentifierValue)obj;
        String sv = this.getStringValue();
        String osv = other.getStringValue();
        return !(sv == null ? osv != null : !sv.equalsIgnoreCase(osv));
    }

    @Override
    public CSSIdentifierValue clone() {
        return new CSSIdentifierValue(this);
    }
}

