/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.property.CSSURIValue;
import io.sf.carte.doc.style.css.property.WrappedValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.w3c.dom.DOMException;

public class CSSURIValueWrapper
extends CSSURIValue
implements WrappedValue {
    private String parentSheetHref = null;

    public CSSURIValueWrapper(CSSURIValue wrapped, String parentSheetHref) {
        super(wrapped);
        this.parentSheetHref = parentSheetHref;
    }

    @Override
    public String getParentSheetHref() {
        return this.parentSheetHref;
    }

    @Override
    public String getCssText() {
        String sv = this.getStringValue();
        if (sv == null) {
            return "";
        }
        return "url('" + sv + "')";
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        String sv = this.getStringValue();
        if (sv != null) {
            wri.write("url('");
            wri.write(sv);
            wri.write("')");
        }
    }

    @Override
    public String getMinifiedCssText(String propertyName) {
        return super.getCssText();
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        this.error();
    }

    @Override
    public String getStringValue() {
        String sv = super.getStringValue();
        if (sv != null && !sv.contains("://") && this.parentSheetHref != null) {
            try {
                URL base = new URL(this.parentSheetHref);
                URL url = new URL(base, sv);
                sv = url.toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return sv;
    }

    @Override
    public void setStringValue(short stringType, String stringValue) throws DOMException {
        this.error();
    }

    private void error() throws DOMException {
        throw new DOMException(7, "This property is read-only computed value. Must modify at the original style sheet.");
    }

    @Override
    public URL getURLValue() {
        URL url = null;
        String sv = super.getStringValue();
        if (sv != null) {
            if (this.parentSheetHref != null) {
                try {
                    URL base = new URL(this.parentSheetHref);
                    url = new URL(base, sv);
                    return url;
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            try {
                url = new URL(sv);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return url;
    }

    @Override
    public CSSURIValue clone() {
        return new CSSURIValueWrapper(super.clone(), this.parentSheetHref);
    }
}

