/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSAttrValue;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.CSSStringValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;

public class OMCSSAttrValue
extends CSSStringValue
implements CSSAttrValue {
    private String attrname = null;
    private String typeval = null;
    private AbstractCSSValue fallback = null;

    public OMCSSAttrValue() {
        this.setCSSUnitType((short)22);
    }

    protected OMCSSAttrValue(OMCSSAttrValue copied) {
        super(copied);
        this.typeval = copied.typeval;
    }

    @Override
    public String getCssText() {
        BufferSimpleWriter sw = new BufferSimpleWriter(this.getStringValue().length() + 6);
        try {
            this.writeCssText(sw);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write("attr(");
        wri.write(this.getStringValue());
        wri.write(')');
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        if (this.isSubproperty()) {
            throw new DOMException(7, "This property was set with a shorthand. Must modify at the style-declaration level.");
        }
        ValueFactory factory = new ValueFactory();
        AbstractCSSValue cssval = factory.parseProperty(cssText);
        if (cssval == null || cssval.getCssValueType() != 1 || ((CSSPrimitiveValue)((Object)cssval)).getPrimitiveType() != 22) {
            throw new DOMException(5, "Wrong attr value.");
        }
        this.setPlainCssText(cssval.getCssText());
        this.setStringValue(((CSSPrimitiveValue)((Object)cssval)).getStringValue());
    }

    @Override
    protected void setStringValue(String stringValue) {
        super.setStringValue(stringValue);
        this.parseAttrValues(stringValue);
    }

    private void parseAttrValues(String attr) {
        StringTokenizer st;
        int len = attr.length();
        int idx = attr.indexOf(44);
        int idxp1 = idx + 1;
        if (idxp1 == len) {
            this.badSyntax(attr);
        }
        if (idxp1 != 0) {
            ValueFactory factory = new ValueFactory();
            this.fallback = factory.parseProperty(attr.substring(idxp1, len));
            if (this.fallback == null) {
                this.badSyntax(attr);
            }
        }
        if (idx == -1) {
            idx = len;
        }
        if (!(st = new StringTokenizer(attr.substring(0, idx))).hasMoreTokens()) {
            this.badSyntax(attr);
        }
        this.attrname = st.nextToken();
        if (st.hasMoreTokens()) {
            this.typeval = st.nextToken();
            if (st.hasMoreTokens()) {
                this.badSyntax(attr);
            }
        }
    }

    private void badSyntax(String attr) throws DOMException {
        throw new DOMException(12, "Bad attr(): " + attr);
    }

    @Override
    protected void setUnescapedCssText(String css) throws DOMException {
        this.setPlainCssText(css);
    }

    @Override
    public String getAttributeName() {
        return this.attrname;
    }

    @Override
    public String getAttributeType() {
        return this.typeval;
    }

    @Override
    public AbstractCSSValue getFallback() {
        return this.fallback;
    }

    @Override
    public OMCSSAttrValue clone() {
        return new OMCSSAttrValue(this);
    }
}

