/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.property.AbstractCSSPrimitiveValue;
import io.sf.carte.doc.style.css.property.CSSNumberValue;
import io.sf.carte.doc.style.css.property.ExpressionContainerValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class OMCSSCalcValue
extends ExpressionContainerValue {
    public OMCSSCalcValue() {
    }

    protected OMCSSCalcValue(OMCSSCalcValue copied) {
        super(copied);
    }

    @Override
    protected String getExpressionValueName() {
        return "calc";
    }

    @Override
    protected boolean isInvalidOperand(AbstractCSSPrimitiveValue primi, short lastlutype) {
        return !(primi instanceof CSSNumberValue) || lastlutype != -1 && lastlutype != 40 && primi.isNegativeNumber();
    }

    @Override
    public float getFloatValue(short unitType) throws DOMException {
        throw new DOMException(15, "Must retrieve individual operands and compute result");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + "calc".hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    @Override
    public String getCssText() {
        String s = this.getExpression().getCssText();
        StringBuilder buf = new StringBuilder(s.length() + 7);
        buf.append("calc(").append(s).append(')');
        return buf.toString();
    }

    @Override
    public String getMinifiedCssText(String pname) {
        String s = this.getExpression().getMinifiedCssText();
        StringBuilder buf = new StringBuilder(s.length() + 6);
        buf.append("calc(").append(s).append(')');
        return buf.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write("calc(");
        wri.write(this.getExpression().getCssText());
        wri.write(')');
    }

    @Override
    public OMCSSCalcValue clone() {
        return new OMCSSCalcValue(this);
    }
}

