/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSExpression;
import io.sf.carte.doc.style.css.property.AbstractCSSExpression;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SumExpression
extends AbstractCSSExpression
implements CSSExpression.AlgebraicExpression {
    LinkedList<AbstractCSSExpression> operands = new LinkedList();

    SumExpression() {
    }

    SumExpression(SumExpression copyFrom) {
        Iterator it = copyFrom.operands.iterator();
        while (it.hasNext()) {
            this.operands.add(((AbstractCSSExpression)it.next()).clone());
        }
    }

    @Override
    void addExpression(AbstractCSSExpression expr) {
        this.operands.add(expr);
        expr.setParentExpression(this);
        if (this.nextOperandInverse) {
            expr.setInverseOperation(true);
            this.nextOperandInverse = false;
        }
    }

    @Override
    void replaceLastExpression(AbstractCSSExpression operation) {
        AbstractCSSExpression lastexpr = this.operands.removeLast();
        if (lastexpr.isInverseOperation()) {
            lastexpr.setInverseOperation(false);
            operation.setInverseOperation(true);
        }
        lastexpr.setParentExpression(null);
        operation.addExpression(lastexpr);
        operation.setParentExpression(this);
        this.operands.addLast(operation);
    }

    public List<AbstractCSSExpression> getOperands() {
        return this.operands;
    }

    @Override
    public CSSExpression.AlgebraicPart getPartType() {
        return CSSExpression.AlgebraicPart.SUM;
    }

    @Override
    public int hashCode() {
        int prime = 1021;
        int result = super.hashCode();
        result = 1021 * result + (this.operands == null ? 0 : this.operands.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SumExpression other = (SumExpression)obj;
        return !(this.operands == null ? other.operands != null : !this.operands.equals(other.operands));
    }

    @Override
    public String getCssText() {
        StringBuilder buf = new StringBuilder();
        Iterator it = this.operands.iterator();
        if (!it.hasNext()) {
            return "";
        }
        CSSExpression expr = (CSSExpression)it.next();
        if (expr.getPartType() != CSSExpression.AlgebraicPart.SUM && expr.isInverseOperation()) {
            buf.append(' ').append('-').append(' ');
        }
        buf.append(expr.getCssText());
        while (it.hasNext()) {
            boolean parens = false;
            expr = (CSSExpression)it.next();
            if (expr.getPartType() == CSSExpression.AlgebraicPart.SUM && expr.isInverseOperation()) {
                buf.append(' ').append('-').append(' ').append('(');
                parens = true;
            } else if (expr.getPartType() != CSSExpression.AlgebraicPart.SUM && expr.isInverseOperation()) {
                buf.append(' ').append('-').append(' ');
            } else {
                buf.append(' ').append('+').append(' ');
            }
            buf.append(expr.getCssText());
            if (!parens) continue;
            buf.append(')');
        }
        return buf.toString();
    }

    @Override
    public String getMinifiedCssText() {
        StringBuilder buf = new StringBuilder();
        Iterator it = this.operands.iterator();
        if (!it.hasNext()) {
            return "";
        }
        CSSExpression expr = (CSSExpression)it.next();
        if (expr.getPartType() != CSSExpression.AlgebraicPart.SUM && expr.isInverseOperation()) {
            buf.append(' ').append('-').append(' ');
        }
        buf.append(expr.getMinifiedCssText());
        while (it.hasNext()) {
            boolean parens = false;
            expr = (CSSExpression)it.next();
            if (expr.getPartType() == CSSExpression.AlgebraicPart.SUM && expr.isInverseOperation()) {
                buf.append(' ').append('-').append(' ').append('(');
                parens = true;
            } else if (expr.getPartType() != CSSExpression.AlgebraicPart.SUM && expr.isInverseOperation()) {
                buf.append(' ').append('-').append(' ');
            } else {
                buf.append(' ').append('+').append(' ');
            }
            buf.append(expr.getMinifiedCssText());
            if (!parens) continue;
            buf.append(')');
        }
        return buf.toString();
    }

    @Override
    public SumExpression clone() {
        return new SumExpression(this);
    }
}

