/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSDeclarationRule;
import io.sf.carte.doc.style.css.SACParserFactory;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.property.AbstractCSSPrimitiveValue;
import io.sf.carte.doc.style.css.property.AbstractCSSValue;
import io.sf.carte.doc.style.css.property.CSSIdentifierValue;
import io.sf.carte.doc.style.css.property.CSSInheritValue;
import io.sf.carte.doc.style.css.property.CSSNumberValue;
import io.sf.carte.doc.style.css.property.CSSPercentageValue;
import io.sf.carte.doc.style.css.property.CSSStringValue;
import io.sf.carte.doc.style.css.property.CSSURIValue;
import io.sf.carte.doc.style.css.property.CSSUnknownValue;
import io.sf.carte.doc.style.css.property.GradientValue;
import io.sf.carte.doc.style.css.property.OMCSSAttrValue;
import io.sf.carte.doc.style.css.property.OMCSSCalcValue;
import io.sf.carte.doc.style.css.property.OMCSSColorValue;
import io.sf.carte.doc.style.css.property.OMCSSCounterValue;
import io.sf.carte.doc.style.css.property.OMCSSFunctionValue;
import io.sf.carte.doc.style.css.property.OMCSSRatioValue;
import io.sf.carte.doc.style.css.property.OMCSSRectValue;
import io.sf.carte.doc.style.css.property.OMCSSValueList;
import io.sf.carte.doc.style.css.property.ValueItem;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Locale;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.dom.DOMException;

public class ValueFactory {
    public static boolean isSizeSACUnit(LexicalUnit unit) {
        return ValueFactory.sizeSACUnit(unit) != 0;
    }

    private static short sizeSACUnit(LexicalUnit unit) {
        short type = unit.getLexicalUnitType();
        if (type == 41) {
            type = ValueFactory.functionDimensionArgumentUnit(unit);
        } else if (type == 40) {
            type = ValueFactory.subexpressionDimensionUnit(unit);
        }
        switch (type) {
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 42: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                return type;
            }
            case 13: {
                return unit.getIntegerValue() == 0 ? type : (short)0;
            }
        }
        return 0;
    }

    public static boolean isResolutionSACUnit(LexicalUnit unit) {
        short type = unit.getLexicalUnitType();
        if (type == 41) {
            type = ValueFactory.firstArgumentUnit(unit);
        }
        switch (type) {
            case 64: 
            case 65: 
            case 66: {
                return true;
            }
        }
        return false;
    }

    public static boolean isPositiveSizeSACUnit(LexicalUnit unit) {
        short utype;
        short type = utype = unit.getLexicalUnitType();
        if (utype == 41) {
            type = ValueFactory.functionDimensionArgumentUnit(unit);
        }
        switch (type) {
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 42: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                return utype == 41 || unit.getFloatValue() > 0.0f;
            }
        }
        return false;
    }

    public static boolean isSizeOrNumberSACUnit(LexicalUnit unit) {
        short type = unit.getLexicalUnitType();
        if (type == 41) {
            type = ValueFactory.functionDimensionArgumentUnit(unit);
        }
        switch (type) {
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 42: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                return true;
            }
        }
        return false;
    }

    public static boolean isPlainNumberOrPercentSACUnit(LexicalUnit unit) {
        short type = unit.getLexicalUnitType();
        switch (type) {
            case 13: 
            case 14: 
            case 23: {
                return true;
            }
        }
        return false;
    }

    public static boolean isNumericSACUnit(LexicalUnit unit) {
        short type = unit.getLexicalUnitType();
        if (type == 41) {
            type = ValueFactory.firstArgumentUnit(unit);
        }
        switch (type) {
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 42: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                return true;
            }
        }
        return false;
    }

    public static boolean isAngleSACUnit(LexicalUnit unit) {
        short type = unit.getLexicalUnitType();
        if (type == 41) {
            if (ValueFactory.isColorFunction(unit)) {
                return false;
            }
            type = ValueFactory.firstArgumentUnit(unit);
        }
        switch (type) {
            case 28: 
            case 29: 
            case 30: 
            case 63: {
                return true;
            }
            case 13: {
                if (unit.getIntegerValue() != 0) break;
                return true;
            }
        }
        return false;
    }

    public static boolean isTimeSACUnit(LexicalUnit unit) {
        short type = unit.getLexicalUnitType();
        if (type == 41 && (type = ValueFactory.firstArgumentUnit(unit)) == 13) {
            return false;
        }
        switch (type) {
            case 31: 
            case 32: {
                return true;
            }
            case 13: {
                if (unit.getIntegerValue() != 0) break;
                return true;
            }
        }
        return false;
    }

    static short functionDimensionArgumentUnit(LexicalUnit lunit) {
        if (ValueFactory.isColorFunction(lunit)) {
            return -1;
        }
        LexicalUnit lu = lunit.getParameters();
        while (lu != null) {
            short type = ValueFactory.sizeSACUnit(lu);
            if (type != 0) {
                return type;
            }
            if ((lu = lu.getNextLexicalUnit()) == null || lu.getLexicalUnitType() != 0) continue;
            lu = lu.getNextLexicalUnit();
        }
        return -1;
    }

    static short subexpressionDimensionUnit(LexicalUnit lunit) {
        LexicalUnit lu = lunit.getSubValues();
        while (lu != null) {
            short type = ValueFactory.sizeSACUnit(lu);
            if (type != 0) {
                return type;
            }
            if ((lu = lu.getNextLexicalUnit()) == null || lu.getLexicalUnitType() != 0) continue;
            lu = lu.getNextLexicalUnit();
        }
        return -1;
    }

    private static short firstArgumentUnit(LexicalUnit lunit) {
        LexicalUnit lu = lunit.getParameters();
        if (lu != null) {
            return lu.getLexicalUnitType();
        }
        return -1;
    }

    private static boolean isColorFunction(LexicalUnit lunit) {
        String name = lunit.getFunctionName().toLowerCase(Locale.US);
        return "rgba".equals(name) || "hsl".equals(name) || "hsla".equals(name) || "hwb".equals(name) || name.endsWith("-gradient");
    }

    public AbstractCSSValue parseProperty(String value) throws DOMException {
        return this.parseProperty(value, SACParserFactory.createSACParser());
    }

    public AbstractCSSValue parseProperty(String value, Parser parser) throws DOMException {
        InputSource source = new InputSource();
        StringReader re = new StringReader(value);
        source.setCharacterStream((Reader)re);
        LexicalUnit lunit = null;
        try {
            lunit = parser.parsePropertyValue(source);
        }
        catch (CSSException e) {
            throw new DOMException(12, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        AbstractCSSValue css = this.createCSSValue(lunit);
        if (css == null) {
            css = this.createUnknownValue(value, lunit);
        }
        return css;
    }

    private CSSUnknownValue createUnknownValue(String value, LexicalUnit lunit) {
        switch (lunit.getLexicalUnitType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return null;
            }
        }
        CSSUnknownValue css = new CSSUnknownValue();
        css.setCssText(value);
        ((AbstractCSSPrimitiveValue)css).newLexicalSetter().setLexicalUnit(lunit);
        return css;
    }

    public AbstractCSSValue parseMediaFeature(String feature) throws DOMException {
        AbstractCSSValue css;
        LexicalUnit nnlu;
        Parser parser = SACParserFactory.createSACParser();
        InputSource source = new InputSource();
        StringReader re = new StringReader(feature);
        source.setCharacterStream((Reader)re);
        LexicalUnit lunit = null;
        try {
            lunit = parser.parsePropertyValue(source);
        }
        catch (CSSException e) {
            throw new DOMException(12, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        LexicalUnit nlu = lunit.getNextLexicalUnit();
        if (nlu != null && nlu.getLexicalUnitType() == 4 && (nnlu = nlu.getNextLexicalUnit()) != null && nnlu.getLexicalUnitType() == 13) {
            OMCSSRatioValue ratio = new OMCSSRatioValue();
            ratio.newLexicalSetter().setLexicalUnit(lunit);
            css = ratio;
        } else {
            css = this.createCSSValue(lunit);
            if (css == null) {
                css = this.createUnknownValue(feature, lunit);
            }
        }
        return css;
    }

    public AbstractCSSValue createCSSValue(LexicalUnit lunit) throws DOMException {
        return this.createCSSValue(lunit, null);
    }

    public AbstractCSSValue createCSSValue(LexicalUnit lunit, CSSDeclarationRule rule) throws DOMException {
        if (lunit.getNextLexicalUnit() != null) {
            AbstractCSSValue value;
            OMCSSValueList superlist = null;
            OMCSSValueList list = OMCSSValueList.createWSValueList();
            LexicalUnit nlu = lunit;
            do {
                if (nlu.getLexicalUnitType() != 68) {
                    StyleDeclarationErrorHandler errHandler;
                    ValueItem item = this.createCSSValueItem(nlu, false);
                    if (item.hasWarnings() && rule != null && (errHandler = rule.getStyleDeclarationErrorHandler()) != null) {
                        item.handleSyntaxWarnings(errHandler);
                    }
                    nlu = (value = item.getCSSValue()).getCssValueType() == 1 ? item.getNextLexicalUnit() : nlu.getNextLexicalUnit();
                } else {
                    if ((nlu = nlu.getNextLexicalUnit()) == null) {
                        throw new DOMException(12, "Unmatched '['");
                    }
                    ListValueItem listitem = this.parseBracketList(nlu, rule, false);
                    value = listitem.getCSSValue();
                    nlu = listitem.getNextLexicalUnit();
                }
                if (nlu != null) {
                    if (nlu.getLexicalUnitType() == 0) {
                        nlu = nlu.getNextLexicalUnit();
                        if (superlist == null) {
                            superlist = OMCSSValueList.createCSValueList();
                        }
                        if (list.getLength() > 0) {
                            list.add(value);
                            superlist.add(list);
                            list = OMCSSValueList.createWSValueList();
                            continue;
                        }
                        superlist.add(value);
                        continue;
                    }
                    list.add(value);
                    continue;
                }
                if (superlist == null) {
                    list.add(value);
                    break;
                }
                if (list.getLength() > 0) {
                    list.add(value);
                    superlist.add(list);
                    break;
                }
                superlist.add(value);
                break;
            } while (nlu != null);
            if (superlist != null) {
                value = ValueFactory.listOrFirstItem(superlist);
                if (value.getCssValueType() == 2) {
                    return ValueFactory.listOrFirstItem((OMCSSValueList)value);
                }
                return value;
            }
            return ValueFactory.listOrFirstItem(list);
        }
        return this.createCSSValueItem(lunit, false).getCSSValue();
    }

    public ListValueItem parseBracketList(LexicalUnit nlu, CSSDeclarationRule rule, boolean subproperty) {
        ListValueItem listitem = new ListValueItem();
        listitem.list = OMCSSValueList.createBracketValueList();
        while (nlu.getLexicalUnitType() != 69) {
            AbstractCSSValue value;
            StyleDeclarationErrorHandler errHandler;
            ValueItem item = this.createCSSValueItem(nlu, subproperty);
            if (item.hasWarnings() && rule != null && (errHandler = rule.getStyleDeclarationErrorHandler()) != null) {
                item.handleSyntaxWarnings(errHandler);
            }
            nlu = (value = item.getCSSValue()).getCssValueType() == 1 ? item.getNextLexicalUnit() : nlu.getNextLexicalUnit();
            listitem.list.add(value);
            if (nlu != null) {
                if (nlu.getLexicalUnitType() != 0 || (nlu = nlu.getNextLexicalUnit()) != null) continue;
                throw new DOMException(12, "Unmatched '['");
            }
            throw new DOMException(12, "Unmatched '['");
        }
        listitem.nextLexicalUnit = nlu.getNextLexicalUnit();
        return listitem;
    }

    private static AbstractCSSValue listOrFirstItem(OMCSSValueList list) {
        int ll = list.getLength();
        if (ll > 1) {
            return list;
        }
        if (ll == 1) {
            return list.item(0);
        }
        return null;
    }

    public ValueItem createCSSValueItem(LexicalUnit lunit, boolean subproperty) throws DOMException {
        switch (lunit.getLexicalUnitType()) {
            case 12: {
                CSSInheritValue value = CSSInheritValue.getValue();
                if (subproperty) {
                    value = value.asSubproperty();
                }
                return value;
            }
        }
        return this.createCSSPrimitiveValueItem(lunit, subproperty);
    }

    AbstractCSSPrimitiveValue createCSSPrimitiveValue(LexicalUnit lunit, boolean subp) throws DOMException {
        return this.createCSSPrimitiveValueItem(lunit, subp).getCSSValue();
    }

    AbstractCSSPrimitiveValue.LexicalSetter createCSSPrimitiveValueItem(LexicalUnit lunit, boolean subp) throws DOMException {
        AbstractCSSPrimitiveValue.LexicalSetter setter;
        AbstractCSSPrimitiveValue primi;
        short unitType = lunit.getLexicalUnitType();
        try {
            switch (unitType) {
                case 35: {
                    primi = new CSSIdentifierValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case 37: {
                    primi = new OMCSSAttrValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case 36: {
                    primi = new CSSStringValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case 24: {
                    primi = new CSSURIValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case 23: {
                    primi = new CSSPercentageValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 42: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: {
                    primi = new CSSNumberValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    ((CSSNumberValue)primi).lengthUnitType = true;
                    break;
                }
                case 14: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: {
                    primi = new CSSNumberValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case 13: {
                    primi = new CSSNumberValue();
                    ((CSSNumberValue)primi).setIntegerValue(lunit.getIntegerValue());
                    setter = primi.newLexicalSetter();
                    primi.newLexicalSetter().nextLexicalUnit = lunit.getNextLexicalUnit();
                    break;
                }
                case 27: {
                    primi = new OMCSSColorValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case 38: {
                    primi = new OMCSSRectValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case 25: {
                    primi = new OMCSSCounterValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case 41: {
                    String func = lunit.getFunctionName();
                    if ("rgb".equals(func) || "rgba".equals(func) || "hsl".equals(func) || "hsla".equals(func) || "hwb".equals(func)) {
                        primi = new OMCSSColorValue();
                    } else if ("calc".equals(func)) {
                        primi = new OMCSSCalcValue();
                    } else {
                        if (func.endsWith("linear-gradient") || func.endsWith("radial-gradient") || func.endsWith("conic-gradient")) {
                            primi = new GradientValue();
                            setter = primi.newLexicalSetter();
                            try {
                                setter.setLexicalUnit(lunit);
                                break;
                            }
                            catch (RuntimeException e) {
                                if (func.charAt(0) == '-') {
                                    primi = new OMCSSFunctionValue();
                                    setter = primi.newLexicalSetter();
                                    setter.setLexicalUnit(lunit);
                                    break;
                                }
                                throw e;
                            }
                        }
                        primi = new OMCSSFunctionValue();
                    }
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case 0: {
                    throw new DOMException(12, "A comma is not a valid primitive");
                }
                default: {
                    primi = new CSSUnknownValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                }
            }
        }
        catch (DOMException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new DOMException(12, e.getMessage());
        }
        primi.setSubproperty(subp);
        return setter;
    }

    public LexicalUnit appendValueString(StringBuilder buf, LexicalUnit lunit) {
        LexicalUnit nlu;
        short type = lunit.getLexicalUnitType();
        if (type == 0) {
            nlu = lunit.getNextLexicalUnit();
            buf.append(',');
        } else if (type == 4) {
            nlu = lunit.getNextLexicalUnit();
            buf.append(' ').append('/');
        } else if (type != 68) {
            ValueItem item = this.createCSSValueItem(lunit, true);
            nlu = item.getNextLexicalUnit();
            AbstractCSSValue cssValue = item.getCSSValue();
            String cssText = cssValue.getCssText();
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append(cssText);
        } else {
            ListValueItem item = this.parseBracketList(lunit.getNextLexicalUnit(), null, false);
            nlu = item.getNextLexicalUnit();
            buf.append(item.getCSSValue().getCssText());
        }
        return nlu;
    }

    protected static short domPrimitiveType(LexicalUnit lunit) {
        short primiType;
        short sacType = lunit.getLexicalUnitType();
        switch (sacType) {
            case 37: {
                primiType = 22;
                break;
            }
            case 35: {
                primiType = 21;
                break;
            }
            case 36: {
                primiType = 19;
                break;
            }
            case 24: {
                primiType = 20;
                break;
            }
            case 19: {
                primiType = 6;
                break;
            }
            case 28: {
                primiType = 11;
                break;
            }
            case 42: {
                primiType = 18;
                break;
            }
            case 15: {
                primiType = 3;
                break;
            }
            case 16: {
                primiType = 4;
                break;
            }
            case 29: {
                primiType = 13;
                break;
            }
            case 33: {
                primiType = 16;
                break;
            }
            case 18: {
                primiType = 8;
                break;
            }
            case 34: {
                primiType = 17;
                break;
            }
            case 20: {
                primiType = 7;
                break;
            }
            case 31: {
                primiType = 14;
                break;
            }
            case 23: {
                primiType = 2;
                break;
            }
            case 22: {
                primiType = 10;
                break;
            }
            case 17: {
                primiType = 5;
                break;
            }
            case 21: {
                primiType = 9;
                break;
            }
            case 30: {
                primiType = 12;
                break;
            }
            case 32: {
                primiType = 15;
                break;
            }
            case 13: 
            case 14: {
                primiType = 1;
                break;
            }
            case 27: {
                primiType = 25;
                break;
            }
            case 50: {
                primiType = 26;
                break;
            }
            case 51: {
                primiType = 27;
                break;
            }
            case 52: {
                primiType = 28;
                break;
            }
            case 54: {
                primiType = 29;
                break;
            }
            case 62: {
                primiType = 30;
                break;
            }
            case 53: {
                primiType = 31;
                break;
            }
            case 55: {
                primiType = 32;
                break;
            }
            case 63: {
                primiType = 33;
                break;
            }
            case 59: {
                primiType = 34;
                break;
            }
            case 57: {
                primiType = 35;
                break;
            }
            case 58: {
                primiType = 36;
                break;
            }
            case 61: {
                primiType = 37;
                break;
            }
            case 60: {
                primiType = 38;
                break;
            }
            case 56: {
                primiType = 39;
                break;
            }
            case 67: {
                primiType = 43;
                break;
            }
            case 38: {
                primiType = 24;
                break;
            }
            case 25: 
            case 26: {
                primiType = 23;
                break;
            }
            case 41: {
                LexicalUnit lu = lunit.getParameters();
                while (lu != null) {
                    if (ValueFactory.isNumericSACUnit(lu)) {
                        return 1;
                    }
                    if ((lu = lu.getNextLexicalUnit()) == null || lu.getLexicalUnitType() != 0) continue;
                    lu = lu.getNextLexicalUnit();
                }
            }
            default: {
                primiType = 0;
            }
        }
        return primiType;
    }

    public static boolean isLengthUnitType(short primitiveType) {
        switch (primitiveType) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                return true;
            }
        }
        return false;
    }

    public class ListValueItem
    implements ValueItem {
        private OMCSSValueList list = null;
        private LexicalUnit nextLexicalUnit = null;

        @Override
        public OMCSSValueList getCSSValue() {
            return this.list;
        }

        @Override
        public LexicalUnit getNextLexicalUnit() {
            return this.nextLexicalUnit;
        }

        @Override
        public boolean hasWarnings() {
            return false;
        }

        @Override
        public void handleSyntaxWarnings(StyleDeclarationErrorHandler handler) {
        }
    }
}

