/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.utils;

import io.skodjob.testframe.security.CertAndKey;
import io.skodjob.testframe.security.CertAndKeyFiles;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.HashSet;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;

public class SecurityUtils {
    private SecurityUtils() {
    }

    public static CertAndKeyFiles exportToPemFiles(CertAndKey ... certs) {
        if (certs.length == 0) {
            throw new IllegalArgumentException("List of certificates should has at least one element");
        }
        try {
            File keyFile = SecurityUtils.exportPrivateKeyToPemFile(certs[0].getPrivateKey());
            File certFile = SecurityUtils.exportCertsToPemFile(certs);
            return new CertAndKeyFiles(certFile, keyFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static File convertPrivateKeyToPKCS8File(PrivateKey privatekey) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        byte[] encoded = privatekey.getEncoded();
        PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance((Object)encoded);
        ASN1Encodable asn1Encodable = privateKeyInfo.parsePrivateKey();
        byte[] privateKeyPKCS8Formatted = asn1Encodable.toASN1Primitive().getEncoded("DER");
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKeyPKCS8Formatted);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PrivateKey privateKey = kf.generatePrivate(keySpec);
        return SecurityUtils.exportPrivateKeyToPemFile(privateKey);
    }

    private static File exportPrivateKeyToPemFile(PrivateKey privateKey) throws IOException {
        File keyFile = Files.createTempFile("key-", ".key", new FileAttribute[0]).toFile();
        try (JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)new FileWriter(keyFile, StandardCharsets.UTF_8));){
            pemWriter.writeObject((Object)privateKey);
            pemWriter.flush();
        }
        return keyFile;
    }

    private static File exportCertsToPemFile(CertAndKey ... certs) throws IOException {
        File certFile = Files.createTempFile("crt-", ".crt", new FileAttribute[0]).toFile();
        try (JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)new FileWriter(certFile, StandardCharsets.UTF_8));){
            for (CertAndKey certAndKey : certs) {
                pemWriter.writeObject((Object)certAndKey.getCertificate());
            }
            pemWriter.flush();
        }
        return certFile;
    }

    public static File exportCaDataToFile(String caData, String prefix, String suffix) {
        try {
            File tempFile = Files.createTempFile(prefix + "-", suffix, new FileAttribute[0]).toFile();
            try (FileWriter fileWriter = new FileWriter(tempFile, StandardCharsets.UTF_8);){
                fileWriter.write(caData);
                fileWriter.flush();
            }
            return tempFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean containsAllDN(String principal1, String principal2) {
        try {
            return new HashSet<Rdn>(new LdapName(principal1).getRdns()).containsAll(new LdapName(principal2).getRdns());
        }
        catch (InvalidNameException e) {
            e.printStackTrace();
            return false;
        }
    }
}

