/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.beanbag;

import io.smallrye.beanbag.Bean;
import io.smallrye.beanbag.BeanBag;
import io.smallrye.beanbag.BeanDefinition;
import io.smallrye.beanbag.DependencyFilter;
import io.smallrye.beanbag.NoSuchBeanException;
import io.smallrye.beanbag.ScopeDefinition;
import io.smallrye.beanbag.Util;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Scope {
    private final Scope parent;
    private final Scope resolutionScope;
    private final List<Bean<?>> beans;
    private final Map<Class<?>, List<Bean<?>>> beansByType = new ConcurrentHashMap();
    private final BeanBag container;

    Scope(BeanBag container, Scope parent, ScopeDefinition resolutionScope, ScopeDefinition definition) {
        this.container = container;
        this.parent = parent;
        this.resolutionScope = resolutionScope == null ? this : new Scope(container, this, null, resolutionScope);
        this.beans = Util.mapList(definition.getBeanDefinitions(), Bean::new, Bean[]::new);
    }

    private <T> List<Bean<? extends T>> getBeansByType(Class<T> type) {
        List<Bean<Object>> list = this.beansByType.get(type);
        if (list == null) {
            List<Bean<Object>> appearing;
            list = this.parent != null ? new ArrayList<Bean<T>>(this.parent.getBeansByType(type)) : new ArrayList<Bean<? extends T>>();
            for (Bean<T> bean : this.beans) {
                if (!bean.matchesByType(type)) continue;
                list.add(bean);
            }
            list.sort(Bean.byPriority());
            if (list.isEmpty()) {
                list = List.of();
            }
            if ((appearing = this.beansByType.putIfAbsent(type, list)) != null) {
                list = appearing;
            }
        }
        return list;
    }

    public <T> List<T> getAllBeans(Class<T> type) {
        return this.getAllBeans(type, DependencyFilter.ACCEPT);
    }

    public <T> List<T> getAllBeans(Class<T> type, DependencyFilter filter) {
        return this.getAllBeans(type, "", filter);
    }

    public <T> List<T> getAllBeans(Class<T> type, String name) {
        return this.getAllBeans(type, name, DependencyFilter.ACCEPT);
    }

    public <T> List<T> getAllBeans(Class<T> type, String name, DependencyFilter filter) {
        List<Bean<T>> beans = this.getBeansByType(type);
        if (beans.isEmpty()) {
            return List.of();
        }
        ArrayList<T> list = new ArrayList<T>(beans.size());
        for (Bean<T> bean : beans) {
            if (!name.isEmpty() && !bean.getName().equals(name) || !filter.test(bean.getType(), bean.getName(), bean.getPriority())) continue;
            try {
                T instance = bean.get(this.resolutionScope);
                if (instance == null) continue;
                list.add(instance);
            }
            catch (Exception exception) {}
        }
        return List.copyOf(list);
    }

    public <T> Map<String, T> getAllBeansWithNames(Class<T> type, DependencyFilter filter) {
        List<Bean<T>> beans = this.getBeansByType(type);
        if (beans.isEmpty()) {
            return Map.of();
        }
        LinkedHashMap<String, T> map = new LinkedHashMap<String, T>(beans.size());
        for (Bean<T> bean : beans) {
            T instance;
            if (map.containsKey(bean.getName()) || !filter.test(bean.getType(), bean.getName(), bean.getPriority()) || (instance = bean.get(this.resolutionScope)) == null) continue;
            map.put(bean.getName(), instance);
        }
        return Map.copyOf(map);
    }

    public <T> T requireBean(Class<T> type) {
        return this.getBean(type, "", false, DependencyFilter.ACCEPT);
    }

    public <T> T requireBean(Class<T> type, String name) {
        return this.getBean(type, name, false, DependencyFilter.ACCEPT);
    }

    public <T> T getOptionalBean(Class<T> type) {
        return this.getOptionalBean(type, "");
    }

    public <T> T getOptionalBean(Class<T> type, String name) {
        return this.getOptionalBean(type, name, DependencyFilter.ACCEPT);
    }

    public <T> T getOptionalBean(Class<T> type, String name, DependencyFilter filter) {
        return this.getBean(type, name, true, filter);
    }

    public <T> T getBean(Class<T> type, String name, boolean optional, DependencyFilter filter) {
        List<Bean<T>> beans = this.getBeansByType(type);
        ArrayList<Exception> problems = null;
        for (Bean<T> bean : beans) {
            try {
                T instance;
                if (!name.isEmpty() && !bean.getName().equals(name) || !filter.test(bean.getType(), bean.getName(), bean.getPriority()) || (instance = bean.get(this.resolutionScope)) == null) continue;
                return instance;
            }
            catch (Exception e) {
                if (optional) continue;
                if (problems == null) {
                    problems = new ArrayList<Exception>();
                }
                problems.add(e);
            }
        }
        if (optional) {
            return null;
        }
        StringBuilder msgBuilder = new StringBuilder("No matching bean available: type is ");
        msgBuilder.append(type);
        if (!name.isEmpty()) {
            msgBuilder.append(", name is \"").append(name).append('\"');
        }
        NoSuchBeanException nbe = new NoSuchBeanException(msgBuilder.toString());
        if (problems != null) {
            problems.forEach(nbe::addSuppressed);
        }
        throw nbe;
    }

    <T> T requireBean(BeanDefinition<T> definition) {
        Class<T> type = definition.getType();
        List<Bean<T>> beans = this.getBeansByType(type);
        for (Bean<T> bean : beans) {
            if (bean.getDefinition() != definition) continue;
            return bean.get(this.resolutionScope);
        }
        StringBuilder msgBuilder = new StringBuilder("No matching bean available: type is ");
        msgBuilder.append(type);
        String name = definition.getName();
        if (!name.isEmpty()) {
            msgBuilder.append(", name is \"").append(name).append('\"');
        }
        NoSuchBeanException nbe = new NoSuchBeanException(msgBuilder.toString());
        throw nbe;
    }

    public BeanBag getContainer() {
        return this.container;
    }
}

