/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.common.annotation.Experimental;
import java.util.Objects;

@Experimental(value="Extension to the original ConfigSource to allow retrieval of additional metadata on config lookup")
public class ConfigValue
implements org.eclipse.microprofile.config.ConfigValue {
    private final String name;
    private final String value;
    private final String rawValue;
    private final String configSourceName;
    private final int configSourceOrdinal;
    private final int lineNumber;

    private ConfigValue(ConfigValueBuilder builder) {
        this.name = builder.name;
        this.value = builder.value;
        this.rawValue = builder.rawValue;
        this.configSourceName = builder.configSourceName;
        this.configSourceOrdinal = builder.configSourceOrdinal;
        this.lineNumber = builder.lineNumber;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getRawValue() {
        return this.rawValue;
    }

    public String getSourceName() {
        return this.getConfigSourceName();
    }

    public int getSourceOrdinal() {
        return this.getConfigSourceOrdinal();
    }

    public String getConfigSourceName() {
        return this.configSourceName;
    }

    public int getConfigSourceOrdinal() {
        return this.configSourceOrdinal;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getLocation() {
        return this.lineNumber != -1 ? this.configSourceName + ":" + this.lineNumber : this.configSourceName;
    }

    public ConfigValue withName(String name) {
        return this.from().withName(name).build();
    }

    public ConfigValue withValue(String value) {
        return this.from().withValue(value).build();
    }

    public ConfigValue withConfigSourceName(String configSourceName) {
        return this.from().withConfigSourceName(configSourceName).build();
    }

    public ConfigValue withConfigSourceOrdinal(int configSourceOrdinal) {
        return this.from().withConfigSourceOrdinal(configSourceOrdinal).build();
    }

    public ConfigValue withLineNumber(int lineNumber) {
        return this.from().withLineNumber(lineNumber).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigValue that = (ConfigValue)o;
        return this.name.equals(that.name) && this.value.equals(that.value) && this.rawValue.equals(that.rawValue) && this.configSourceName.equals(that.configSourceName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value, this.configSourceName);
    }

    ConfigValueBuilder from() {
        return new ConfigValueBuilder().withName(this.name).withValue(this.value).withRawValue(this.rawValue).withConfigSourceName(this.configSourceName).withConfigSourceOrdinal(this.configSourceOrdinal).withLineNumber(this.lineNumber);
    }

    public static ConfigValueBuilder builder() {
        return new ConfigValueBuilder();
    }

    public static class ConfigValueBuilder {
        private String name;
        private String value;
        private String rawValue;
        private String configSourceName;
        private int configSourceOrdinal;
        private int lineNumber = -1;

        public ConfigValueBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public ConfigValueBuilder withValue(String value) {
            this.value = value;
            return this;
        }

        public ConfigValueBuilder withRawValue(String rawValue) {
            this.rawValue = rawValue;
            return this;
        }

        public ConfigValueBuilder withConfigSourceName(String configSourceName) {
            this.configSourceName = configSourceName;
            return this;
        }

        public ConfigValueBuilder withConfigSourceOrdinal(int configSourceOrdinal) {
            this.configSourceOrdinal = configSourceOrdinal;
            return this;
        }

        public ConfigValueBuilder withLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
            return this;
        }

        public ConfigValue build() {
            return new ConfigValue(this);
        }
    }
}

