/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.common.classloader.ClassPathUtils;
import io.smallrye.config.ConfigurableConfigSource;
import io.smallrye.config.ProfileConfigSourceFactory;
import io.smallrye.config.SecuritySupport;
import io.smallrye.config._private.ConfigMessages;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Consumer;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;

public abstract class AbstractLocationConfigSourceLoader {
    private static final Converter<URI> URI_CONVERTER = new URIConverter();

    protected boolean failOnMissingFile() {
        return false;
    }

    protected abstract String[] getFileExtensions();

    protected abstract ConfigSource loadConfigSource(URL var1, int var2) throws IOException;

    protected List<ConfigSource> loadConfigSources(String location, int ordinal) {
        String[] stringArray;
        if (location != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = location;
        } else {
            stringArray = null;
        }
        return this.loadConfigSources(stringArray, ordinal);
    }

    protected List<ConfigSource> loadConfigSources(String location, int ordinal, ClassLoader classLoader) {
        String[] stringArray;
        if (location != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = location;
        } else {
            stringArray = null;
        }
        return this.loadConfigSources(stringArray, ordinal, classLoader);
    }

    protected List<ConfigSource> loadConfigSources(String[] locations, int ordinal) {
        return this.loadConfigSources(locations, ordinal, SecuritySupport.getContextClassLoader());
    }

    protected List<ConfigSource> loadConfigSources(String[] locations, int ordinal, ClassLoader classLoader) {
        if (locations == null || locations.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>();
        for (String location : locations) {
            URI uri = (URI)URI_CONVERTER.convert(location);
            if (uri.getScheme() == null) {
                configSources.addAll(this.tryFileSystem(uri, ordinal));
                configSources.addAll(this.tryClassPath(uri, ordinal, classLoader));
                continue;
            }
            if (uri.getScheme().equals("file")) {
                configSources.addAll(this.tryFileSystem(uri, ordinal));
                continue;
            }
            if (uri.getScheme().equals("jar")) {
                configSources.addAll(this.tryJar(uri, ordinal));
                continue;
            }
            if (uri.getScheme().startsWith("http")) {
                configSources.addAll(this.tryHttpResource(uri, ordinal));
                continue;
            }
            throw ConfigMessages.msg.schemeNotSupported(uri.getScheme());
        }
        return configSources;
    }

    protected List<ConfigSource> tryFileSystem(URI uri, int ordinal) {
        ArrayList<ConfigSource> configSources;
        block13: {
            Path urlPath;
            configSources = new ArrayList<ConfigSource>();
            Path path = urlPath = uri.getScheme() != null ? Paths.get(uri) : Paths.get(uri.getPath(), new String[0]);
            if (Files.isRegularFile(urlPath, new LinkOption[0])) {
                ClassPathUtils.consumeAsPath((URL)AbstractLocationConfigSourceLoader.toURL(urlPath.toUri()), (Consumer)new ConfigSourcePathConsumer(ordinal, configSources));
            } else {
                if (Files.isDirectory(urlPath, new LinkOption[0])) {
                    try (DirectoryStream<Path> paths = Files.newDirectoryStream(urlPath, this::validExtension);){
                        for (Path path2 : paths) {
                            configSources.add(this.loadConfigSource(path2.toUri(), ordinal));
                        }
                        break block13;
                    }
                    catch (IOException e) {
                        throw ConfigMessages.msg.failedToLoadResource(e, uri.toString());
                    }
                }
                if ("file".equals(uri.getScheme()) && Files.notExists(urlPath, new LinkOption[0]) && this.failOnMissingFile()) {
                    throw ConfigMessages.msg.failedToLoadResource(new FileNotFoundException(uri.toString()), uri.toString());
                }
            }
        }
        return configSources;
    }

    protected List<ConfigSource> tryClassPath(URI uri, int ordinal, ClassLoader classLoader) {
        ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>();
        ClassLoader useClassloader = classLoader != null ? classLoader : SecuritySupport.getContextClassLoader();
        try {
            ClassPathUtils.consumeAsPaths((ClassLoader)useClassloader, (String)uri.getPath(), (Consumer)new ConfigSourceClassPathConsumer(classLoader, uri, ordinal, configSources));
        }
        catch (IOException e) {
            throw ConfigMessages.msg.failedToLoadResource(e, uri.toString());
        }
        catch (IllegalArgumentException e) {
            return this.fallbackToUnknownProtocol(uri, ordinal, useClassloader);
        }
        return configSources;
    }

    protected List<ConfigSource> tryJar(URI uri, int ordinal) {
        ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>();
        try {
            ClassPathUtils.consumeAsPath((URL)AbstractLocationConfigSourceLoader.toURL(uri), (Consumer)new ConfigSourcePathConsumer(ordinal, configSources));
        }
        catch (Exception e) {
            throw ConfigMessages.msg.failedToLoadResource(e, uri.toString());
        }
        return configSources;
    }

    protected List<ConfigSource> fallbackToUnknownProtocol(URI uri, int ordinal, ClassLoader classLoader) {
        ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>();
        try {
            Enumeration<URL> resources = classLoader.getResources(uri.toString());
            while (resources.hasMoreElements()) {
                URL resourceUrl = resources.nextElement();
                if (!this.validExtension(resourceUrl.getFile())) continue;
                ConfigSource mainSource = this.loadConfigSourceInternal(resourceUrl, ordinal);
                configSources.add(mainSource);
                configSources.add(new ConfigurableConfigSource(profiles -> {
                    ArrayList<ConfigSource> profileSources = new ArrayList<ConfigSource>();
                    for (int i = profiles.size() - 1; i >= 0; --i) {
                        int mainOrdinal = mainSource.getOrdinal() + profiles.size() - i + 1;
                        for (String fileExtension : this.getFileExtensions()) {
                            URI profileUri = AbstractLocationConfigSourceLoader.addProfileName(uri, (String)profiles.get(i), fileExtension);
                            try {
                                Enumeration<URL> profileResources = classLoader.getResources(profileUri.toString());
                                while (profileResources.hasMoreElements()) {
                                    profileSources.addAll(this.loadProfileConfigSource(profileResources.nextElement(), mainOrdinal));
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                    return profileSources;
                }));
            }
        }
        catch (IOException e) {
            throw ConfigMessages.msg.failedToLoadResource(e, uri.toString());
        }
        return configSources;
    }

    protected List<ConfigSource> tryHttpResource(URI uri, int ordinal) {
        ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>();
        if (this.validExtension(uri.getPath())) {
            ConfigSource mainSource = this.loadConfigSource(uri, ordinal);
            configSources.add(mainSource);
            configSources.add(this.profileConfigSourceFactory(uri, mainSource.getOrdinal()));
        }
        return configSources;
    }

    private static URL toURL(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private ConfigSource loadConfigSourceInternal(URL url, int ordinal) {
        try {
            return this.loadConfigSource(url, ordinal);
        }
        catch (IOException e) {
            throw ConfigMessages.msg.failedToLoadResource(e, url.toString());
        }
    }

    private ConfigSource loadConfigSource(URI uri, int ordinal) {
        URL url = AbstractLocationConfigSourceLoader.toURL(uri);
        return this.loadConfigSourceInternal(url, ordinal);
    }

    private List<ConfigSource> loadProfileConfigSource(URL url, int ordinal) {
        try {
            return List.of(this.loadConfigSource(url, ordinal));
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            return Collections.emptyList();
        }
        catch (IOException e) {
            throw ConfigMessages.msg.failedToLoadResource(e, url.toString());
        }
    }

    private List<ConfigSource> loadProfileConfigSource(URI uri, int ordinal) {
        return this.loadProfileConfigSource(AbstractLocationConfigSourceLoader.toURL(uri), ordinal);
    }

    private boolean validExtension(Path fileName) {
        return this.validExtension(fileName.getFileName().toString());
    }

    private boolean validExtension(String resourceName) {
        String[] fileExtensions = this.getFileExtensions();
        if (fileExtensions.length == 0) {
            return true;
        }
        for (String s : fileExtensions) {
            if (!resourceName.endsWith(s)) continue;
            return true;
        }
        return false;
    }

    private static URI addProfileName(URI uri, String profile, String fileExtension) {
        if ("jar".equals(uri.getScheme())) {
            return URI.create("jar:" + String.valueOf(AbstractLocationConfigSourceLoader.addProfileName(URI.create(uri.getRawSchemeSpecificPart()), profile, fileExtension)));
        }
        String fileName = uri.getPath();
        assert (fileName != null);
        int dot = fileName.lastIndexOf(".");
        String fileNameProfile = dot != -1 && dot != 0 && fileName.charAt(dot - 1) != '/' ? fileName.substring(0, dot) + "-" + profile + "." + fileExtension : fileName + "-" + profile;
        try {
            return new URI(uri.getScheme(), uri.getAuthority(), uri.getHost(), uri.getPort(), fileNameProfile, uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    private ConfigurableConfigSource profileConfigSourceFactory(URI uri, int ordinal) {
        return new ConfigurableConfigSource(new ConfigurableProfileConfigSourceFactory(uri, ordinal));
    }

    protected final class ConfigSourcePathConsumer
    implements Consumer<Path> {
        private final int ordinal;
        private final List<ConfigSource> configSources;

        public ConfigSourcePathConsumer(int ordinal, List<ConfigSource> configSources) {
            this.ordinal = ordinal;
            this.configSources = configSources;
        }

        @Override
        public void accept(Path path) {
            AbstractLocationConfigSourceLoader loader = AbstractLocationConfigSourceLoader.this;
            if (loader.validExtension(path.getFileName().toString())) {
                ConfigSource mainSource = loader.loadConfigSource(path.toUri(), this.ordinal);
                this.configSources.add(mainSource);
                this.configSources.add(AbstractLocationConfigSourceLoader.this.profileConfigSourceFactory(path.toUri(), mainSource.getOrdinal()));
            }
        }
    }

    protected final class ConfigSourceClassPathConsumer
    implements Consumer<Path> {
        private final ClassLoader classLoader;
        private final URI resource;
        private final int ordinal;
        private final List<ConfigSource> configSources;

        public ConfigSourceClassPathConsumer(ClassLoader classLoader, URI resource, int ordinal, List<ConfigSource> configSources) {
            this.classLoader = classLoader;
            this.resource = resource;
            this.ordinal = ordinal;
            this.configSources = configSources;
        }

        @Override
        public void accept(final Path path) {
            final AbstractLocationConfigSourceLoader loader = AbstractLocationConfigSourceLoader.this;
            if (loader.validExtension(path.getFileName().toString())) {
                final ConfigSource mainSource = loader.loadConfigSource(path.toUri(), this.ordinal);
                this.configSources.add(mainSource);
                this.configSources.add(new ConfigurableConfigSource(new ProfileConfigSourceFactory(){

                    @Override
                    public Iterable<ConfigSource> getProfileConfigSources(List<String> profiles) {
                        ArrayList<ConfigSource> profileSources = new ArrayList<ConfigSource>();
                        for (int i = profiles.size() - 1; i >= 0; --i) {
                            int ordinal = mainSource.getOrdinal() + profiles.size() - i;
                            for (String fileExtension : AbstractLocationConfigSourceLoader.this.getFileExtensions()) {
                                URI profileResource = AbstractLocationConfigSourceLoader.addProfileName(ConfigSourceClassPathConsumer.this.resource, profiles.get(i), fileExtension);
                                URI profileUri = AbstractLocationConfigSourceLoader.addProfileName(path.toUri(), profiles.get(i), fileExtension);
                                if (!"jar".equals(profileUri.getScheme()) && !ConfigSourceClassPathConsumer.this.isInClassloader(profileResource, profileUri)) continue;
                                profileSources.addAll(loader.loadProfileConfigSource(profileUri, ordinal));
                            }
                        }
                        return profileSources;
                    }

                    @Override
                    public OptionalInt getPriority() {
                        return OptionalInt.of(mainSource.getOrdinal());
                    }
                }));
            }
        }

        private boolean isInClassloader(URI profileResource, URI profileUri) {
            return this.classLoader.resources(profileResource.getPath()).anyMatch(url -> url.toString().equals(profileUri.toString()));
        }
    }

    protected final class ConfigurableProfileConfigSourceFactory
    implements ProfileConfigSourceFactory {
        private final URI uri;
        private final int ordinal;

        public ConfigurableProfileConfigSourceFactory(URI uri, int ordinal) {
            this.uri = uri;
            this.ordinal = ordinal;
        }

        @Override
        public Iterable<ConfigSource> getProfileConfigSources(List<String> profiles) {
            ArrayList<ConfigSource> profileSources = new ArrayList<ConfigSource>();
            for (int i = profiles.size() - 1; i >= 0; --i) {
                int ordinal = this.ordinal + profiles.size() - i;
                for (String fileExtension : AbstractLocationConfigSourceLoader.this.getFileExtensions()) {
                    URI profileUri = AbstractLocationConfigSourceLoader.addProfileName(this.uri, profiles.get(i), fileExtension);
                    profileSources.addAll(AbstractLocationConfigSourceLoader.this.loadProfileConfigSource(profileUri, ordinal));
                }
            }
            return profileSources;
        }

        @Override
        public OptionalInt getPriority() {
            return OptionalInt.of(this.ordinal);
        }
    }

    private static class URIConverter
    implements Converter<URI> {
        private static final long serialVersionUID = -4852082279190307320L;

        private URIConverter() {
        }

        public URI convert(String value) {
            try {
                return new URI(value);
            }
            catch (URISyntaxException e) {
                throw ConfigMessages.msg.uriSyntaxInvalid(e, value);
            }
        }
    }
}

