/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigValidationException;
import io.smallrye.config.NameIterator;
import io.smallrye.config.ProfileConfigSourceInterceptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class ConfigValue
implements org.eclipse.microprofile.config.ConfigValue {
    private final String name;
    private final String value;
    private final String rawValue;
    private final String profile;
    private final String configSourceName;
    private final int configSourceOrdinal;
    private final int configSourcePosition;
    private final int lineNumber;
    private final List<ConfigValidationException.Problem> problems;
    public static final Comparator<ConfigValue> CONFIG_SOURCE_COMPARATOR = new Comparator<ConfigValue>(){

        @Override
        public int compare(ConfigValue original, ConfigValue candidate) {
            int result = Integer.compare(original.configSourceOrdinal, candidate.configSourceOrdinal);
            if (result != 0) {
                return result;
            }
            result = Integer.compare(original.configSourcePosition, candidate.configSourcePosition) * -1;
            if (result != 0) {
                return result;
            }
            if (original.getName().charAt(0) == '%' && candidate.getName().charAt(0) == '%') {
                List<String> originalProfiles = ProfileConfigSourceInterceptor.convertProfile(new NameIterator(original.getName()).getNextSegment().substring(1));
                List<String> candidateProfiles = ProfileConfigSourceInterceptor.convertProfile(new NameIterator(candidate.getName()).getNextSegment().substring(1));
                return Integer.compare(originalProfiles.size(), candidateProfiles.size()) * -1;
            }
            return result;
        }
    };

    private ConfigValue(ConfigValueBuilder builder) {
        this.name = builder.name;
        this.value = builder.value;
        this.rawValue = builder.rawValue;
        this.profile = builder.profile;
        this.configSourceName = builder.configSourceName;
        this.configSourceOrdinal = builder.configSourceOrdinal;
        this.configSourcePosition = builder.configSourcePosition;
        this.lineNumber = builder.lineNumber;
        this.problems = builder.problems;
    }

    public String getName() {
        return this.name;
    }

    public String getNameProfiled() {
        return this.profile != null ? "%" + this.profile + "." + this.name : this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getRawValue() {
        return this.rawValue;
    }

    public String getProfile() {
        return this.profile;
    }

    public String getSourceName() {
        return this.getConfigSourceName();
    }

    public int getSourceOrdinal() {
        return this.getConfigSourceOrdinal();
    }

    public String getConfigSourceName() {
        return this.configSourceName;
    }

    public int getConfigSourceOrdinal() {
        return this.configSourceOrdinal;
    }

    public int getConfigSourcePosition() {
        return this.configSourcePosition;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getLocation() {
        return this.lineNumber != -1 ? this.configSourceName + ":" + this.lineNumber : this.configSourceName;
    }

    boolean hasProblems() {
        return this.problems != null && !this.problems.isEmpty();
    }

    List<ConfigValidationException.Problem> getProblems() {
        return this.hasProblems() ? Collections.unmodifiableList(this.problems) : Collections.emptyList();
    }

    public ConfigValue withName(String name) {
        return this.from().withName(name).build();
    }

    public ConfigValue withValue(String value) {
        return this.from().withValue(value).build();
    }

    public ConfigValue withProfile(String profile) {
        return this.from().withProfile(profile).build();
    }

    public ConfigValue withConfigSourceName(String configSourceName) {
        return this.from().withConfigSourceName(configSourceName).build();
    }

    public ConfigValue withConfigSourceOrdinal(int configSourceOrdinal) {
        return this.from().withConfigSourceOrdinal(configSourceOrdinal).build();
    }

    public ConfigValue withConfigSourcePosition(int configSourcePosition) {
        return this.from().withConfigSourcePosition(configSourcePosition).build();
    }

    public ConfigValue withLineNumber(int lineNumber) {
        return this.from().withLineNumber(lineNumber).build();
    }

    public ConfigValue noProblems() {
        return this.from().noProblems().build();
    }

    public ConfigValue withProblems(List<ConfigValidationException.Problem> problems) {
        return this.from().withProblems(problems).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigValue that = (ConfigValue)o;
        return this.configSourceOrdinal == that.configSourceOrdinal && this.configSourcePosition == that.configSourcePosition && this.name.equals(that.name) && Objects.equals(this.value, that.value) && Objects.equals(this.rawValue, that.rawValue) && Objects.equals(this.profile, that.profile) && Objects.equals(this.configSourceName, that.configSourceName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value, this.rawValue, this.profile, this.configSourceName, this.configSourceOrdinal, this.configSourcePosition);
    }

    public String toString() {
        return "ConfigValue{name='" + this.name + "', value='" + this.value + "', rawValue='" + this.rawValue + "', profile='" + this.profile + "', configSourceName='" + this.configSourceName + "', configSourceOrdinal=" + this.configSourceOrdinal + ", configSourcePosition=" + this.configSourcePosition + ", lineNumber=" + this.lineNumber + "}";
    }

    public ConfigValueBuilder from() {
        return new ConfigValueBuilder().withName(this.name).withValue(this.value).withRawValue(this.rawValue).withProfile(this.profile).withConfigSourceName(this.configSourceName).withConfigSourceOrdinal(this.configSourceOrdinal).withConfigSourcePosition(this.configSourcePosition).withLineNumber(this.lineNumber).withProblems(this.problems);
    }

    public static ConfigValueBuilder builder() {
        return new ConfigValueBuilder();
    }

    public static class ConfigValueBuilder {
        private String name;
        private String value;
        private String rawValue;
        private String profile;
        private String configSourceName;
        private int configSourceOrdinal;
        private int configSourcePosition;
        private int lineNumber = -1;
        private List<ConfigValidationException.Problem> problems;

        public ConfigValueBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public ConfigValueBuilder withValue(String value) {
            this.value = value;
            return this;
        }

        public ConfigValueBuilder withRawValue(String rawValue) {
            this.rawValue = rawValue;
            return this;
        }

        public ConfigValueBuilder withProfile(String profile) {
            this.profile = profile;
            return this;
        }

        public ConfigValueBuilder withConfigSourceName(String configSourceName) {
            this.configSourceName = configSourceName;
            return this;
        }

        public ConfigValueBuilder withConfigSourceOrdinal(int configSourceOrdinal) {
            this.configSourceOrdinal = configSourceOrdinal;
            return this;
        }

        public ConfigValueBuilder withConfigSourcePosition(int configSourcePosition) {
            this.configSourcePosition = configSourcePosition;
            return this;
        }

        public ConfigValueBuilder withLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
            return this;
        }

        public ConfigValueBuilder noProblems() {
            this.problems = Collections.emptyList();
            return this;
        }

        public ConfigValueBuilder withProblems(List<ConfigValidationException.Problem> problems) {
            if (problems != null) {
                if (this.problems == null) {
                    this.problems = new ArrayList<ConfigValidationException.Problem>();
                }
                this.problems.addAll(problems);
            }
            return this;
        }

        public ConfigValueBuilder addProblem(ConfigValidationException.Problem problem) {
            if (this.problems == null) {
                this.problems = new ArrayList<ConfigValidationException.Problem>();
            }
            this.problems.add(problem);
            return this;
        }

        public ConfigValue build() {
            if (this.problems != null && !this.problems.isEmpty()) {
                this.value = null;
            }
            return new ConfigValue(this);
        }
    }
}

