/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.common.constraint.Assert;
import io.smallrye.config.ConfigMappingClass;
import io.smallrye.config.ConfigMappingContext;
import io.smallrye.config.ConfigMappingLoader;
import io.smallrye.config.ConfigMappingObject;
import io.smallrye.config.ConfigMappings;
import io.smallrye.config.ConfigValidationException;
import io.smallrye.config.EnvConfigSource;
import io.smallrye.config.SecretKeys;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.spi.ConfigSource;

final class ConfigMappingProvider
implements Serializable {
    private static final long serialVersionUID = 3977667610888849912L;
    private final Map<String, List<Class<?>>> roots;
    private final Set<String> keys;
    private final Map<String, Map<String, Set<String>>> names;
    private final List<String[]> ignoredPaths;
    private final boolean validateUnknown;

    ConfigMappingProvider(Builder builder) {
        this.roots = new HashMap(builder.roots);
        this.keys = builder.keys;
        this.names = builder.names;
        this.ignoredPaths = builder.ignoredPaths;
        this.validateUnknown = builder.validateUnknown;
    }

    public static Builder builder() {
        return new Builder();
    }

    Map<Class<?>, Map<String, ConfigMappingObject>> mapConfiguration(final SmallRyeConfig config) throws ConfigValidationException {
        List<ConfigValidationException.Problem> problems;
        if (this.roots.isEmpty()) {
            return Collections.emptyMap();
        }
        ConfigMappingProvider.matchPropertiesWithEnv(config, this.roots.keySet(), this.keys);
        ConfigMappingContext context = SecretKeys.doUnlocked(new Supplier<ConfigMappingContext>(){

            @Override
            public ConfigMappingContext get() {
                return new ConfigMappingContext(config, ConfigMappingProvider.this.roots, ConfigMappingProvider.this.names);
            }
        });
        if (config.getOptionalValue("smallrye.config.mapping.validate-unknown", Boolean.TYPE).orElse(this.validateUnknown).booleanValue()) {
            context.reportUnknown(this.ignoredPaths);
        }
        if (!(problems = context.getProblems()).isEmpty()) {
            throw new ConfigValidationException(problems.toArray(ConfigValidationException.Problem.NO_PROBLEMS));
        }
        return context.getRootsMap();
    }

    private static void matchPropertiesWithEnv(SmallRyeConfig config, Set<String> roots, Set<String> mappedProperties) {
        StringBuilder sb = new StringBuilder();
        for (ConfigSource configSource : config.getConfigSources(EnvConfigSource.class)) {
            EnvConfigSource envConfigSource = (EnvConfigSource)configSource;
            ArrayList<String> envProperties = new ArrayList<String>();
            if (roots.contains("")) {
                envProperties.addAll(envConfigSource.getPropertyNames());
            } else {
                block1: for (String envProperty : envConfigSource.getPropertyNames()) {
                    for (String root : roots) {
                        if (!ConfigMappingProvider.isEnvPropertyInRoot(envProperty, root)) continue;
                        envProperties.add(envProperty);
                        continue block1;
                    }
                }
            }
            block3: for (String envProperty : envProperties) {
                for (String mappedProperty : mappedProperties) {
                    List<Integer> indexOfDashes = ConfigMappingProvider.indexOfDashes(mappedProperty, envProperty);
                    if (indexOfDashes == null) continue;
                    sb.append(envProperty);
                    for (Integer dash : indexOfDashes) {
                        sb.setCharAt(dash, '-');
                    }
                    String expectedEnvProperty = sb.toString();
                    if (!envProperty.equals(expectedEnvProperty)) {
                        envConfigSource.getPropertyNames().add(sb.toString());
                        envConfigSource.getPropertyNames().remove(envProperty);
                    }
                    sb.setLength(0);
                    continue block3;
                }
            }
        }
    }

    private static boolean isEnvPropertyInRoot(String envProperty, String root) {
        if (envProperty.equals(root)) {
            return true;
        }
        if (envProperty.length() <= root.length()) {
            return false;
        }
        char e = envProperty.charAt(root.length());
        if (e == '.' || e == '[') {
            for (int i = 0; i < root.length(); ++i) {
                char r = root.charAt(i);
                e = envProperty.charAt(i);
                if (!(r == '-' ? e != '.' && e != '-' : r != e)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static List<Integer> indexOfDashes(String mappedProperty, String envProperty) {
        if (mappedProperty.length() > envProperty.length()) {
            return null;
        }
        ArrayList<Integer> dashesPosition = null;
        int matchPosition = envProperty.length() - 1;
        for (int i = mappedProperty.length() - 1; i >= 0; --i) {
            char p;
            if (matchPosition == -1) {
                return null;
            }
            char c = mappedProperty.charAt(i);
            if (c == '.' || c == '-') {
                p = envProperty.charAt(matchPosition);
                if (p != '.' && p != '-') {
                    return null;
                }
                if (c == '-') {
                    if (dashesPosition == null) {
                        dashesPosition = new ArrayList<Integer>();
                    }
                    dashesPosition.add(matchPosition);
                }
                --matchPosition;
                continue;
            }
            if (c == '*') {
                p = envProperty.charAt(matchPosition);
                if (p == '\"' && (matchPosition = envProperty.lastIndexOf(34, matchPosition - 1)) != -1) {
                    matchPosition = envProperty.lastIndexOf(46, matchPosition);
                }
                matchPosition = envProperty.lastIndexOf(46, matchPosition);
                continue;
            }
            if (c == ']') {
                i -= 2;
                if ((matchPosition = envProperty.lastIndexOf(91, matchPosition)) == -1) continue;
                --matchPosition;
                continue;
            }
            if (c != envProperty.charAt(matchPosition)) {
                return null;
            }
            --matchPosition;
        }
        return dashesPosition;
    }

    static final class Builder {
        Set<Class<?>> types = new HashSet();
        Map<String, List<Class<?>>> roots = new HashMap();
        Set<String> keys = new HashSet<String>();
        Map<String, Map<String, Set<String>>> names = new HashMap<String, Map<String, Set<String>>>();
        List<String[]> ignoredPaths = new ArrayList<String[]>();
        boolean validateUnknown = true;
        SmallRyeConfigBuilder configBuilder = null;

        Builder() {
        }

        Builder addRoot(String prefix, Class<?> type) {
            Assert.checkNotNullParam((String)"path", (Object)prefix);
            Assert.checkNotNullParam((String)"type", type);
            this.types.add(type);
            this.roots.computeIfAbsent(prefix, k -> new ArrayList(4)).add(ConfigMappingLoader.getConfigMappingClass(type));
            return this;
        }

        Builder keys(Set<String> keys) {
            Assert.checkNotNullParam((String)"keys", keys);
            this.keys.addAll(keys);
            return this;
        }

        Builder names(Map<String, Map<String, Set<String>>> names) {
            Assert.checkNotNullParam((String)"names", names);
            for (Map.Entry<String, Map<String, Set<String>>> entry : names.entrySet()) {
                Map<String, Set<String>> groupNames = this.names.computeIfAbsent(entry.getKey(), new Function<String, Map<String, Set<String>>>(){

                    @Override
                    public Map<String, Set<String>> apply(String s) {
                        return new HashMap<String, Set<String>>();
                    }
                });
                groupNames.putAll(entry.getValue());
            }
            return this;
        }

        Builder ignoredPath(String ignoredPath) {
            Assert.checkNotNullParam((String)"ignoredPath", (Object)ignoredPath);
            this.ignoredPaths.add(ignoredPath.split("\\."));
            return this;
        }

        Builder validateUnknown(boolean validateUnknown) {
            this.validateUnknown = validateUnknown;
            return this;
        }

        Builder registerDefaults(SmallRyeConfigBuilder configBuilder) {
            this.configBuilder = configBuilder;
            return this;
        }

        ConfigMappingProvider build() {
            ConfigMappings.ConfigClassWithPrefix configClass;
            boolean allConfigurationProperties = true;
            for (Class<?> clazz : this.types) {
                if (ConfigMappingClass.getConfigurationClass(clazz) != null) continue;
                allConfigurationProperties = false;
                break;
            }
            if (allConfigurationProperties) {
                this.validateUnknown = false;
            }
            if (this.keys.isEmpty()) {
                for (Map.Entry entry : this.roots.entrySet()) {
                    for (Class root : (List)entry.getValue()) {
                        configClass = ConfigMappings.ConfigClassWithPrefix.configClassWithPrefix(root, (String)entry.getKey());
                        this.keys(ConfigMappings.getProperties(configClass).get(configClass.getKlass()).get(configClass.getPrefix()).keySet());
                    }
                }
            }
            if (this.names.isEmpty()) {
                for (Map.Entry entry : this.roots.entrySet()) {
                    for (Class root : (List)entry.getValue()) {
                        configClass = ConfigMappings.ConfigClassWithPrefix.configClassWithPrefix(root, (String)entry.getKey());
                        this.names(ConfigMappings.getNames(configClass));
                    }
                }
            }
            if (this.configBuilder != null) {
                Map<String, String> defaultValues = this.configBuilder.getDefaultValues();
                for (Map.Entry<String, List<Class<?>>> entry : this.roots.entrySet()) {
                    for (Class<?> root : entry.getValue()) {
                        for (Map.Entry<String, String> defaultEntry : ConfigMappings.getDefaults(ConfigMappings.ConfigClassWithPrefix.configClassWithPrefix(root, entry.getKey())).entrySet()) {
                            defaultValues.putIfAbsent(defaultEntry.getKey(), defaultEntry.getValue());
                        }
                    }
                }
            }
            return new ConfigMappingProvider(this);
        }
    }
}

