/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni.builders;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.uni.builders.StateHolder;
import io.smallrye.mutiny.subscription.UniSubscriber;
import java.util.function.Function;
import java.util.function.Supplier;

public class UniCreateFromDeferredSupplierWithState<S, T>
extends AbstractUni<T> {
    private final Function<S, Uni<? extends T>> mapper;
    private final StateHolder<S> holder;

    public UniCreateFromDeferredSupplierWithState(Supplier<S> stateSupplier, Function<S, Uni<? extends T>> mapper) {
        this.holder = new StateHolder<S>(stateSupplier);
        this.mapper = mapper;
    }

    @Override
    protected void subscribing(UniSubscriber<? super T> subscriber) {
        Uni<? extends T> uni;
        S state;
        ParameterValidation.nonNull(subscriber, "subscriber");
        try {
            state = this.holder.get();
        }
        catch (Exception e) {
            subscriber.onSubscribe(EmptyUniSubscription.CANCELLED);
            subscriber.onFailure(e);
            return;
        }
        try {
            uni = this.mapper.apply(state);
        }
        catch (Throwable e) {
            subscriber.onSubscribe(EmptyUniSubscription.CANCELLED);
            subscriber.onFailure(e);
            return;
        }
        if (uni == null) {
            subscriber.onSubscribe(EmptyUniSubscription.CANCELLED);
            subscriber.onFailure(new NullPointerException("The supplier returned `null`"));
        } else {
            AbstractUni.subscribe(uni, subscriber);
        }
    }
}

