/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.uni.UniOperatorProcessor;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.function.Function;

public class UniOnItemTransformToUni<I, O>
extends UniOperator<I, O> {
    private final Function<? super I, Uni<? extends O>> mapper;

    public UniOnItemTransformToUni(Uni<I> upstream, Function<? super I, Uni<? extends O>> mapper) {
        super(upstream);
        this.mapper = mapper;
    }

    @Override
    public void subscribe(UniSubscriber<? super O> subscriber) {
        AbstractUni.subscribe(this.upstream(), new UniOnItemTransformToUniProcessor(subscriber));
    }

    private class UniOnItemTransformToUniProcessor
    extends UniOperatorProcessor<I, O> {
        private volatile UniSubscription innerSubscription;

        public UniOnItemTransformToUniProcessor(UniSubscriber<? super O> downstream) {
            super(downstream);
        }

        @Override
        public void onSubscribe(UniSubscription subscription) {
            if (this.upstream.get() == null) {
                super.onSubscribe(subscription);
            } else if (this.innerSubscription == null) {
                this.innerSubscription = subscription;
            } else {
                subscription.cancel();
            }
        }

        @Override
        public void onItem(I item) {
            if (this.isCancelled()) {
                return;
            }
            if (this.innerSubscription == null) {
                this.performInnerSubscription(item);
            } else {
                this.downstream.onItem(item);
            }
        }

        private void performInnerSubscription(I item) {
            Uni uni;
            try {
                uni = (Uni)UniOnItemTransformToUni.this.mapper.apply(item);
            }
            catch (Throwable e) {
                if (item instanceof Throwable) {
                    this.downstream.onFailure(new CompositeException((Throwable)item, e));
                } else {
                    this.downstream.onFailure(e);
                }
                return;
            }
            if (uni == null) {
                this.downstream.onFailure(new NullPointerException("The mapper returned `null`"));
                return;
            }
            AbstractUni.subscribe(uni, this);
        }

        @Override
        public void cancel() {
            if (this.innerSubscription != null) {
                this.innerSubscription.cancel();
            }
            super.cancel();
        }
    }
}

