/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.UniOnItem;
import io.smallrye.mutiny.helpers.ParameterValidation;
import java.util.function.Supplier;

public class UniOnItemIgnore<T> {
    private final UniOnItem<T> onResult;

    public UniOnItemIgnore(UniOnItem<T> onResult) {
        this.onResult = ParameterValidation.nonNull(onResult, "onItem");
    }

    public Uni<T> andFail(Throwable failure) {
        ParameterValidation.nonNull(failure, "failure");
        return this.andFail(() -> failure);
    }

    public Uni<T> andFail(Supplier<Throwable> supplier) {
        ParameterValidation.nonNull(supplier, "supplier");
        return this.onResult.produceUni(ignored -> Uni.createFrom().failure(supplier));
    }

    public Uni<T> andFail() {
        return this.andFail(new Exception("Ignored and Failed"));
    }

    public <O> Uni<O> andSwitchTo(Uni<? extends O> other) {
        ParameterValidation.nonNull(other, "other");
        return this.onResult.produceUni(ignored -> other);
    }

    public <O> Uni<O> andSwitchTo(Supplier<Uni<? extends O>> supplier) {
        ParameterValidation.nonNull(supplier, "supplier");
        return this.onResult.produceUni(ignored -> (Uni)supplier.get());
    }

    public Uni<T> andContinueWith(T fallback) {
        return this.onResult.apply(ignored -> fallback);
    }

    public Uni<Void> andContinueWithNull() {
        return this.onResult.apply(ignored -> null);
    }

    public Uni<T> andContinueWith(Supplier<? extends T> supplier) {
        ParameterValidation.nonNull(supplier, "supplier");
        return this.onResult.apply(ignored -> supplier.get());
    }
}

