/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.axle.core.eventbus;

import java.util.Map;
import org.reactivestreams.Publisher;
import io.reactivex.Flowable;
import java.util.function.Consumer;
import java.util.concurrent.CompletionStage;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * An event bus consumer object representing a stream of message to an {@link io.vertx.axle.core.eventbus.EventBus} address that can
 * be read from.
 * <p>
 * The {@link io.vertx.axle.core.eventbus.EventBus#consumer} or {@link io.vertx.axle.core.eventbus.EventBus#localConsumer}
 * creates a new consumer, the returned consumer is not yet registered against the event bus. Registration
 * is effective after the {@link io.vertx.axle.core.eventbus.MessageConsumer#handler} method is invoked.<p>
 *
 * The consumer is unregistered from the event bus using the {@link io.vertx.axle.core.eventbus.MessageConsumer#unregister} method or by calling the
 * {@link io.vertx.axle.core.eventbus.MessageConsumer#handler} with a null value..
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.eventbus.MessageConsumer original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.axle.Gen(io.vertx.core.eventbus.MessageConsumer.class)
public class MessageConsumer<T> implements io.vertx.axle.core.streams.ReadStream<io.vertx.axle.core.eventbus.Message<T>> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MessageConsumer that = (MessageConsumer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.axle.TypeArg<MessageConsumer> __TYPE_ARG = new io.vertx.lang.axle.TypeArg<>(    obj -> new MessageConsumer((io.vertx.core.eventbus.MessageConsumer) obj),
    MessageConsumer::getDelegate
  );

  private final io.vertx.core.eventbus.MessageConsumer<T> delegate;
  public final io.vertx.lang.axle.TypeArg<T> __typeArg_0;
  
  public MessageConsumer(io.vertx.core.eventbus.MessageConsumer delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.vertx.lang.axle.TypeArg.unknown();  }

  public MessageConsumer(io.vertx.core.eventbus.MessageConsumer delegate, io.vertx.lang.axle.TypeArg<T> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  MessageConsumer() {    this.delegate = null;
    this.__typeArg_0 = io.vertx.lang.axle.TypeArg.unknown();  }

  public io.vertx.core.eventbus.MessageConsumer getDelegate() {
    return delegate;
  }

  private org.reactivestreams.Publisher<io.vertx.axle.core.eventbus.Message<T>> publisher;

  public synchronized org.reactivestreams.Publisher<io.vertx.axle.core.eventbus.Message<T>> toPublisher() {
    if (publisher == null) {
      java.util.function.Function<io.vertx.core.eventbus.Message<T>, io.vertx.axle.core.eventbus.Message<T>> conv = io.vertx.axle.core.eventbus.Message::newInstance;
      publisher = io.vertx.axle.PublisherHelper.toPublisher(delegate, conv);
    }
    return publisher;
  }

  public synchronized org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder<io.vertx.axle.core.eventbus.Message<T>> toPublisherBuilder() {
    if (publisher == null) {
      java.util.function.Function<io.vertx.core.eventbus.Message<T>, io.vertx.axle.core.eventbus.Message<T>> conv = io.vertx.axle.core.eventbus.Message::newInstance;
      publisher = io.vertx.axle.PublisherHelper.toPublisher(delegate, conv);
    }
    return org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams.fromPublisher(publisher);
  }

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.axle.core.streams.Pipe<io.vertx.axle.core.eventbus.Message<T>> pipe() { 
    io.vertx.axle.core.streams.Pipe<io.vertx.axle.core.eventbus.Message<T>> ret = io.vertx.axle.core.streams.Pipe.newInstance(delegate.pipe(), new io.vertx.lang.axle.TypeArg<io.vertx.axle.core.eventbus.Message<T>>(o0 -> io.vertx.axle.core.eventbus.Message.newInstance((io.vertx.core.eventbus.Message)o0, __typeArg_0), o0 -> o0.getDelegate()));
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  private void __pipeTo(io.vertx.axle.core.streams.WriteStream<io.vertx.axle.core.eventbus.Message<T>> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public CompletionStage<Void> pipeTo(io.vertx.axle.core.streams.WriteStream<io.vertx.axle.core.eventbus.Message<T>> dst) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __pipeTo(dst, handler);
    });
  }

  private io.vertx.axle.core.eventbus.MessageConsumer<T> __exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.axle.core.eventbus.MessageConsumer<T> exceptionHandler(Consumer<Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  private io.vertx.axle.core.eventbus.MessageConsumer<T> __handler(Handler<io.vertx.axle.core.eventbus.Message<T>> handler) { 
    delegate.handler(new Handler<io.vertx.core.eventbus.Message<T>>() {
      public void handle(io.vertx.core.eventbus.Message<T> event) {
        handler.handle(io.vertx.axle.core.eventbus.Message.newInstance(event, __typeArg_0));
      }
    });
    return this;
  }

  public io.vertx.axle.core.eventbus.MessageConsumer<T> handler(Consumer<io.vertx.axle.core.eventbus.Message<T>> handler) {
    return __handler(handler != null ? handler::accept : null);
  }

  public io.vertx.axle.core.eventbus.MessageConsumer<T> pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.axle.core.eventbus.MessageConsumer<T> resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.axle.core.eventbus.MessageConsumer<T> fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  private io.vertx.axle.core.eventbus.MessageConsumer<T> __endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.axle.core.eventbus.MessageConsumer<T> endHandler(Consumer<Void> endHandler) {
    return __endHandler(endHandler != null ? endHandler::accept : null);
  }

  /**
   * @return a read stream for the body of the message stream.
   */
  public io.vertx.axle.core.streams.ReadStream<T> bodyStream() { 
    io.vertx.axle.core.streams.ReadStream<T> ret = io.vertx.axle.core.streams.ReadStream.newInstance(delegate.bodyStream(), __typeArg_0);
    return ret;
  }

  /**
   * @return true if the current consumer is registered
   */
  public boolean isRegistered() { 
    boolean ret = delegate.isRegistered();
    return ret;
  }

  /**
   * @return The address the handler was registered with.
   */
  public String address() { 
    String ret = delegate.address();
    return ret;
  }

  /**
   * Set the number of messages this registration will buffer when this stream is paused. The default
   * value is <code>1000</code>.
   * <p>
   * When a new value is set, buffered messages may be discarded to reach the new value. The most recent
   * messages will be kept.
   * @param maxBufferedMessages the maximum number of messages that can be buffered
   * @return this registration
   */
  public io.vertx.axle.core.eventbus.MessageConsumer<T> setMaxBufferedMessages(int maxBufferedMessages) { 
    io.vertx.axle.core.eventbus.MessageConsumer<T> ret = io.vertx.axle.core.eventbus.MessageConsumer.newInstance(delegate.setMaxBufferedMessages(maxBufferedMessages), __typeArg_0);
    return ret;
  }

  /**
   * @return the maximum number of messages that can be buffered when this stream is paused
   */
  public int getMaxBufferedMessages() { 
    int ret = delegate.getMaxBufferedMessages();
    return ret;
  }

  /**
   * Optional method which can be called to indicate when the registration has been propagated across the cluster.
   * @param completionHandler the completion handler
   */
  private void __completionHandler(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.completionHandler(completionHandler);
  }

  /**
   * Optional method which can be called to indicate when the registration has been propagated across the cluster.
   * @return 
   */
  public CompletionStage<Void> completionHandler() { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __completionHandler(handler);
    });
  }

  /**
   * Unregisters the handler which created this registration
   * @param completionHandler the handler called when the unregister is done. For example in a cluster when all nodes of the event bus have been unregistered.
   */
  private void __unregister(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.unregister(completionHandler);
  }

  /**
   * Unregisters the handler which created this registration
   * @return 
   */
  public CompletionStage<Void> unregister() { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __unregister(handler);
    });
  }


  public static <T>MessageConsumer<T> newInstance(io.vertx.core.eventbus.MessageConsumer arg) {
    return arg != null ? new MessageConsumer<T>(arg) : null;
  }

  public static <T>MessageConsumer<T> newInstance(io.vertx.core.eventbus.MessageConsumer arg, io.vertx.lang.axle.TypeArg<T> __typeArg_T) {
    return arg != null ? new MessageConsumer<T>(arg, __typeArg_T) : null;
  }
}
