/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.axle.core.net;

import java.util.Map;
import org.reactivestreams.Publisher;
import io.reactivex.Flowable;
import java.util.function.Consumer;
import java.util.concurrent.CompletionStage;
import javax.net.ssl.SSLSession;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Represents a socket-like interface to a TCP connection on either the
 * client or the server side.
 * <p>
 * Instances of this class are created on the client side by an {@link io.vertx.axle.core.net.NetClient}
 * when a connection to a server is made, or on the server side by a {@link io.vertx.axle.core.net.NetServer}
 * when a server accepts a connection.
 * <p>
 * It implements both  and  so it can be used with
 * {@link io.vertx.axle.core.streams.Pump} to pump data with flow control.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.net.NetSocket original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.axle.Gen(io.vertx.core.net.NetSocket.class)
public class NetSocket implements io.vertx.axle.core.streams.ReadStream<io.vertx.axle.core.buffer.Buffer>, io.vertx.axle.core.streams.WriteStream<io.vertx.axle.core.buffer.Buffer> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NetSocket that = (NetSocket) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.axle.TypeArg<NetSocket> __TYPE_ARG = new io.vertx.lang.axle.TypeArg<>(    obj -> new NetSocket((io.vertx.core.net.NetSocket) obj),
    NetSocket::getDelegate
  );

  private final io.vertx.core.net.NetSocket delegate;
  
  public NetSocket(io.vertx.core.net.NetSocket delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  NetSocket() {    this.delegate = null;
  }

  public io.vertx.core.net.NetSocket getDelegate() {
    return delegate;
  }

  private org.reactivestreams.Publisher<io.vertx.axle.core.buffer.Buffer> publisher;

  public synchronized org.reactivestreams.Publisher<io.vertx.axle.core.buffer.Buffer> toPublisher() {
    if (publisher == null) {
      java.util.function.Function<io.vertx.core.buffer.Buffer, io.vertx.axle.core.buffer.Buffer> conv = io.vertx.axle.core.buffer.Buffer::newInstance;
      publisher = io.vertx.axle.PublisherHelper.toPublisher(delegate, conv);
    }
    return publisher;
  }

  public synchronized org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder<io.vertx.axle.core.buffer.Buffer> toPublisherBuilder() {
    if (publisher == null) {
      java.util.function.Function<io.vertx.core.buffer.Buffer, io.vertx.axle.core.buffer.Buffer> conv = io.vertx.axle.core.buffer.Buffer::newInstance;
      publisher = io.vertx.axle.PublisherHelper.toPublisher(delegate, conv);
    }
    return org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams.fromPublisher(publisher);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   */
  private void __end(io.vertx.axle.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) { 
    delegate.end(data.getDelegate(), handler);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public CompletionStage<Void> end(io.vertx.axle.core.buffer.Buffer data) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __end(data, handler);
    });
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.axle.core.net.NetSocket#setWriteQueueMaxSize}
   * @return true if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.axle.core.streams.Pipe<io.vertx.axle.core.buffer.Buffer> pipe() { 
    io.vertx.axle.core.streams.Pipe<io.vertx.axle.core.buffer.Buffer> ret = io.vertx.axle.core.streams.Pipe.newInstance(delegate.pipe(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  private void __pipeTo(io.vertx.axle.core.streams.WriteStream<io.vertx.axle.core.buffer.Buffer> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public CompletionStage<Void> pipeTo(io.vertx.axle.core.streams.WriteStream<io.vertx.axle.core.buffer.Buffer> dst) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __pipeTo(dst, handler);
    });
  }

  private io.vertx.axle.core.net.NetSocket __exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.axle.core.net.NetSocket exceptionHandler(Consumer<Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  private io.vertx.axle.core.net.NetSocket __handler(Handler<io.vertx.axle.core.buffer.Buffer> handler) { 
    delegate.handler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(io.vertx.axle.core.buffer.Buffer.newInstance(event));
      }
    });
    return this;
  }

  public io.vertx.axle.core.net.NetSocket handler(Consumer<io.vertx.axle.core.buffer.Buffer> handler) {
    return __handler(handler != null ? handler::accept : null);
  }

  public io.vertx.axle.core.net.NetSocket pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.axle.core.net.NetSocket resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.axle.core.net.NetSocket fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  /**
   * 
   * <p>
   * This handler might be called after the close handler when the socket is paused and there are still
   * buffers to deliver.
   * @param endHandler 
   * @return 
   */
  private io.vertx.axle.core.net.NetSocket __endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  /**
   * 
   * <p>
   * This handler might be called after the close handler when the socket is paused and there are still
   * buffers to deliver.
   * @param endHandler 
   * @return 
   */
  public io.vertx.axle.core.net.NetSocket endHandler(Consumer<Void> endHandler) {
    return __endHandler(endHandler != null ? endHandler::accept : null);
  }

  public io.vertx.axle.core.net.NetSocket setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  private io.vertx.axle.core.net.NetSocket __drainHandler(Handler<Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  public io.vertx.axle.core.net.NetSocket drainHandler(Consumer<Void> handler) {
    return __drainHandler(handler != null ? handler::accept : null);
  }

  /**
   * When a <code>NetSocket</code> is created it automatically registers an event handler with the event bus, the ID of that
   * handler is given by <code>writeHandlerID</code>.
   * <p>
   * Given this ID, a different event loop can send a buffer to that event handler using the event bus and
   * that buffer will be received by this instance in its own event loop and written to the underlying connection. This
   * allows you to write data to other connections which are owned by different event loops.
   * @return the write handler ID
   */
  public String writeHandlerID() { 
    String ret = delegate.writeHandlerID();
    return ret;
  }

  /**
   * Same as {@link io.vertx.axle.core.net.NetSocket#write} but with an <code>handler</code> called when the operation completes
   * @param str 
   * @param handler 
   * @return 
   */
  private io.vertx.axle.core.net.NetSocket __write(String str, Handler<AsyncResult<Void>> handler) { 
    delegate.write(str, handler);
    return this;
  }

  /**
   * Same as {@link io.vertx.axle.core.net.NetSocket#write} but with an <code>handler</code> called when the operation completes
   * @param str 
   * @return 
   */
  public CompletionStage<Void> write(String str) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __write(str, handler);
    });
  }

  /**
   * Same as {@link io.vertx.axle.core.net.NetSocket#write} but with an <code>handler</code> called when the operation completes
   * @param str 
   * @param enc 
   * @param handler 
   * @return 
   */
  private io.vertx.axle.core.net.NetSocket __write(String str, String enc, Handler<AsyncResult<Void>> handler) { 
    delegate.write(str, enc, handler);
    return this;
  }

  /**
   * Same as {@link io.vertx.axle.core.net.NetSocket#write} but with an <code>handler</code> called when the operation completes
   * @param str 
   * @param enc 
   * @return 
   */
  public CompletionStage<Void> write(String str, String enc) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __write(str, enc, handler);
    });
  }

  /**
   * Like  but with an <code>handler</code> called when the message has been written
   * or failed to be written.
   * @param message 
   * @param handler 
   * @return 
   */
  private io.vertx.axle.core.net.NetSocket __write(io.vertx.axle.core.buffer.Buffer message, Handler<AsyncResult<Void>> handler) { 
    delegate.write(message.getDelegate(), handler);
    return this;
  }

  /**
   * Like  but with an <code>handler</code> called when the message has been written
   * or failed to be written.
   * @param message 
   * @return 
   */
  public CompletionStage<Void> write(io.vertx.axle.core.buffer.Buffer message) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __write(message, handler);
    });
  }

  /**
   * Same as {@link io.vertx.axle.core.net.NetSocket#sendFile} but also takes a handler that will be called when the send has completed or
   * a failure has occurred
   * @param filename file name of the file to send
   * @param resultHandler handler
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.axle.core.net.NetSocket __sendFile(String filename, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.sendFile(filename, resultHandler);
    return this;
  }

  /**
   * Same as {@link io.vertx.axle.core.net.NetSocket#sendFile} but also takes a handler that will be called when the send has completed or
   * a failure has occurred
   * @param filename file name of the file to send
   * @return a reference to this, so the API can be used fluently
   */
  public CompletionStage<Void> sendFile(String filename) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __sendFile(filename, handler);
    });
  }

  /**
   * Same as {@link io.vertx.axle.core.net.NetSocket#sendFile} but also takes a handler that will be called when the send has completed or
   * a failure has occurred
   * @param filename file name of the file to send
   * @param offset offset
   * @param resultHandler handler
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.axle.core.net.NetSocket __sendFile(String filename, long offset, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.sendFile(filename, offset, resultHandler);
    return this;
  }

  /**
   * Same as {@link io.vertx.axle.core.net.NetSocket#sendFile} but also takes a handler that will be called when the send has completed or
   * a failure has occurred
   * @param filename file name of the file to send
   * @param offset offset
   * @return a reference to this, so the API can be used fluently
   */
  public CompletionStage<Void> sendFile(String filename, long offset) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __sendFile(filename, offset, handler);
    });
  }

  /**
   * Same as {@link io.vertx.axle.core.net.NetSocket#sendFile} but also takes a handler that will be called when the send has completed or
   * a failure has occurred
   * @param filename file name of the file to send
   * @param offset offset
   * @param length length
   * @param resultHandler handler
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.axle.core.net.NetSocket __sendFile(String filename, long offset, long length, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.sendFile(filename, offset, length, resultHandler);
    return this;
  }

  /**
   * Same as {@link io.vertx.axle.core.net.NetSocket#sendFile} but also takes a handler that will be called when the send has completed or
   * a failure has occurred
   * @param filename file name of the file to send
   * @param offset offset
   * @param length length
   * @return a reference to this, so the API can be used fluently
   */
  public CompletionStage<Void> sendFile(String filename, long offset, long length) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __sendFile(filename, offset, length, handler);
    });
  }

  /**
   * @return the remote address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket)
   */
  public io.vertx.axle.core.net.SocketAddress remoteAddress() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.axle.core.net.SocketAddress ret = io.vertx.axle.core.net.SocketAddress.newInstance(delegate.remoteAddress());
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the local address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket)
   */
  public io.vertx.axle.core.net.SocketAddress localAddress() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.axle.core.net.SocketAddress ret = io.vertx.axle.core.net.SocketAddress.newInstance(delegate.localAddress());
    cached_1 = ret;
    return ret;
  }

  /**
   * Calls {@link io.vertx.axle.core.net.NetSocket#end}
   * @param handler 
   */
  private void __end(Handler<AsyncResult<Void>> handler) { 
    delegate.end(handler);
  }

  /**
   * Calls {@link io.vertx.axle.core.net.NetSocket#end}
   * @return 
   */
  public CompletionStage<Void> end() { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __end(handler);
    });
  }

  /**
   * Close the NetSocket and notify the <code>handler</code> when the operation completes.
   * @param handler 
   */
  private void __close(Handler<AsyncResult<Void>> handler) { 
    delegate.close(handler);
  }

  /**
   * Close the NetSocket and notify the <code>handler</code> when the operation completes.
   * @return 
   */
  public CompletionStage<Void> close() { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __close(handler);
    });
  }

  /**
   * Set a handler that will be called when the NetSocket is closed
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.axle.core.net.NetSocket __closeHandler(Handler<Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * Set a handler that will be called when the NetSocket is closed
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.axle.core.net.NetSocket closeHandler(Consumer<Void> handler) {
    return __closeHandler(handler != null ? handler::accept : null);
  }

  /**
   * Upgrade channel to use SSL/TLS. Be aware that for this to work SSL must be configured.
   * @param handler the handler will be notified when it's upgraded
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.axle.core.net.NetSocket __upgradeToSsl(Handler<Void> handler) { 
    delegate.upgradeToSsl(handler);
    return this;
  }

  /**
   * Upgrade channel to use SSL/TLS. Be aware that for this to work SSL must be configured.
   * @param handler the handler will be notified when it's upgraded
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.axle.core.net.NetSocket upgradeToSsl(Consumer<Void> handler) {
    return __upgradeToSsl(handler != null ? handler::accept : null);
  }

  /**
   * Upgrade channel to use SSL/TLS. Be aware that for this to work SSL must be configured.
   * @param serverName the server name
   * @param handler the handler will be notified when it's upgraded
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.axle.core.net.NetSocket __upgradeToSsl(String serverName, Handler<Void> handler) { 
    delegate.upgradeToSsl(serverName, handler);
    return this;
  }

  /**
   * Upgrade channel to use SSL/TLS. Be aware that for this to work SSL must be configured.
   * @param serverName the server name
   * @param handler the handler will be notified when it's upgraded
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.axle.core.net.NetSocket upgradeToSsl(String serverName, Consumer<Void> handler) {
    return __upgradeToSsl(serverName, handler != null ? handler::accept : null);
  }

  /**
   * @return true if this {@link io.vertx.axle.core.net.NetSocket} is encrypted via SSL/TLS.
   */
  public boolean isSsl() { 
    boolean ret = delegate.isSsl();
    return ret;
  }

  /**
   * Returns the SNI server name presented during the SSL handshake by the client.
   * @return the indicated server name
   */
  public String indicatedServerName() { 
    String ret = delegate.indicatedServerName();
    return ret;
  }

  /**
   * @return SSLSession associated with the underlying socket. Returns null if connection is not SSL.
   */
  public SSLSession sslSession() { 
    SSLSession ret = delegate.sslSession();
    return ret;
  }

  private static final io.vertx.lang.axle.TypeArg<io.vertx.axle.core.buffer.Buffer> TYPE_ARG_0 = new io.vertx.lang.axle.TypeArg<io.vertx.axle.core.buffer.Buffer>(o1 -> io.vertx.axle.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  private io.vertx.axle.core.net.SocketAddress cached_0;
  private io.vertx.axle.core.net.SocketAddress cached_1;

  public static  NetSocket newInstance(io.vertx.core.net.NetSocket arg) {
    return arg != null ? new NetSocket(arg) : null;
  }
}
