/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.axle.core.parsetools;

import java.util.Map;
import org.reactivestreams.Publisher;
import io.reactivex.Flowable;
import java.util.function.Consumer;
import java.util.concurrent.CompletionStage;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A parser class which allows to incrementally parse json elements and emit json parse events instead of parsing a json
 * element fully. This parser is convenient for parsing large json structures.
 * <p/>
 * The parser also parses concatenated json streams or line delimited json streams.
 * <p/>
 * The parser can also parse entire object or array when it is convenient, for instance a very large array
 * of small objects can be parsed efficiently by handling array <i>start</i>/<i>end</i> and <i>object</i>
 * events.
 * <p/>
 * Whenever the parser fails to parse or process the stream, the {@link io.vertx.axle.core.parsetools.JsonParser#exceptionHandler} is called with
 * the cause of the failure and the current handling stops. After such event, the parser should not handle data
 * anymore.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.parsetools.JsonParser original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.axle.Gen(io.vertx.core.parsetools.JsonParser.class)
public class JsonParser implements io.vertx.axle.core.streams.ReadStream<io.vertx.axle.core.parsetools.JsonEvent>, io.vertx.core.Handler<io.vertx.axle.core.buffer.Buffer> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JsonParser that = (JsonParser) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.axle.TypeArg<JsonParser> __TYPE_ARG = new io.vertx.lang.axle.TypeArg<>(    obj -> new JsonParser((io.vertx.core.parsetools.JsonParser) obj),
    JsonParser::getDelegate
  );

  private final io.vertx.core.parsetools.JsonParser delegate;
  
  public JsonParser(io.vertx.core.parsetools.JsonParser delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  JsonParser() {    this.delegate = null;
  }

  public io.vertx.core.parsetools.JsonParser getDelegate() {
    return delegate;
  }

  private org.reactivestreams.Publisher<io.vertx.axle.core.parsetools.JsonEvent> publisher;

  public synchronized org.reactivestreams.Publisher<io.vertx.axle.core.parsetools.JsonEvent> toPublisher() {
    if (publisher == null) {
      java.util.function.Function<io.vertx.core.parsetools.JsonEvent, io.vertx.axle.core.parsetools.JsonEvent> conv = io.vertx.axle.core.parsetools.JsonEvent::newInstance;
      publisher = io.vertx.axle.PublisherHelper.toPublisher(delegate, conv);
    }
    return publisher;
  }

  public synchronized org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder<io.vertx.axle.core.parsetools.JsonEvent> toPublisherBuilder() {
    if (publisher == null) {
      java.util.function.Function<io.vertx.core.parsetools.JsonEvent, io.vertx.axle.core.parsetools.JsonEvent> conv = io.vertx.axle.core.parsetools.JsonEvent::newInstance;
      publisher = io.vertx.axle.PublisherHelper.toPublisher(delegate, conv);
    }
    return org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams.fromPublisher(publisher);
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.axle.core.buffer.Buffer event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.axle.core.streams.Pipe<io.vertx.axle.core.parsetools.JsonEvent> pipe() { 
    io.vertx.axle.core.streams.Pipe<io.vertx.axle.core.parsetools.JsonEvent> ret = io.vertx.axle.core.streams.Pipe.newInstance(delegate.pipe(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  private void __pipeTo(io.vertx.axle.core.streams.WriteStream<io.vertx.axle.core.parsetools.JsonEvent> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public CompletionStage<Void> pipeTo(io.vertx.axle.core.streams.WriteStream<io.vertx.axle.core.parsetools.JsonEvent> dst) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __pipeTo(dst, handler);
    });
  }

  /**
   * Create a new <code>JsonParser</code> instance.
   * @return 
   */
  public static io.vertx.axle.core.parsetools.JsonParser newParser() { 
    io.vertx.axle.core.parsetools.JsonParser ret = io.vertx.axle.core.parsetools.JsonParser.newInstance(io.vertx.core.parsetools.JsonParser.newParser());
    return ret;
  }

  /**
   * Create a new <code>JsonParser</code> instance.
   * @param stream 
   * @return 
   */
  public static io.vertx.axle.core.parsetools.JsonParser newParser(io.vertx.axle.core.streams.ReadStream<io.vertx.axle.core.buffer.Buffer> stream) { 
    io.vertx.axle.core.parsetools.JsonParser ret = io.vertx.axle.core.parsetools.JsonParser.newInstance(io.vertx.core.parsetools.JsonParser.newParser(stream.getDelegate()));
    return ret;
  }

  /**
   * Create a new <code>JsonParser</code> instance.
   * @param stream 
   * @return 
   */
  public static io.vertx.axle.core.parsetools.JsonParser newParser(Publisher<io.vertx.axle.core.buffer.Buffer> stream) { 
    io.vertx.axle.core.parsetools.JsonParser ret = io.vertx.axle.core.parsetools.JsonParser.newInstance(io.vertx.core.parsetools.JsonParser.newParser(io.vertx.axle.ReadStreamSubscriber.asReadStream(stream,obj -> (io.vertx.core.buffer.Buffer)obj.getDelegate()).resume()));
    return ret;
  }

  /**
   * Handle a <code>Buffer</code>, pretty much like calling {@link io.vertx.core.Handler}.
   * @param buffer 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.axle.core.parsetools.JsonParser write(io.vertx.axle.core.buffer.Buffer buffer) { 
    delegate.write(buffer.getDelegate());
    return this;
  }

  /**
   * End the stream, this must be called after all the json stream has been processed.
   */
  public void end() { 
    delegate.end();
  }

  /**
   * Flip the parser to emit a stream of events for each new json object.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.axle.core.parsetools.JsonParser objectEventMode() { 
    delegate.objectEventMode();
    return this;
  }

  /**
   * Flip the parser to emit a single value event for each new json object.
   * </p>
   * Json object currently streamed won't be affected.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.axle.core.parsetools.JsonParser objectValueMode() { 
    delegate.objectValueMode();
    return this;
  }

  /**
   * Flip the parser to emit a stream of events for each new json array.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.axle.core.parsetools.JsonParser arrayEventMode() { 
    delegate.arrayEventMode();
    return this;
  }

  /**
   * Flip the parser to emit a single value event for each new json array.
   * </p>
   * Json array currently streamed won't be affected.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.axle.core.parsetools.JsonParser arrayValueMode() { 
    delegate.arrayValueMode();
    return this;
  }

  public io.vertx.axle.core.parsetools.JsonParser pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.axle.core.parsetools.JsonParser resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.axle.core.parsetools.JsonParser fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  private io.vertx.axle.core.parsetools.JsonParser __endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.axle.core.parsetools.JsonParser endHandler(Consumer<Void> endHandler) {
    return __endHandler(endHandler != null ? endHandler::accept : null);
  }

  private io.vertx.axle.core.parsetools.JsonParser __handler(Handler<io.vertx.axle.core.parsetools.JsonEvent> handler) { 
    delegate.handler(new Handler<io.vertx.core.parsetools.JsonEvent>() {
      public void handle(io.vertx.core.parsetools.JsonEvent event) {
        handler.handle(io.vertx.axle.core.parsetools.JsonEvent.newInstance(event));
      }
    });
    return this;
  }

  public io.vertx.axle.core.parsetools.JsonParser handler(Consumer<io.vertx.axle.core.parsetools.JsonEvent> handler) {
    return __handler(handler != null ? handler::accept : null);
  }

  private io.vertx.axle.core.parsetools.JsonParser __exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.axle.core.parsetools.JsonParser exceptionHandler(Consumer<Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  private static final io.vertx.lang.axle.TypeArg<io.vertx.axle.core.parsetools.JsonEvent> TYPE_ARG_0 = new io.vertx.lang.axle.TypeArg<io.vertx.axle.core.parsetools.JsonEvent>(o1 -> io.vertx.axle.core.parsetools.JsonEvent.newInstance((io.vertx.core.parsetools.JsonEvent)o1), o1 -> o1.getDelegate());

  public static  JsonParser newInstance(io.vertx.core.parsetools.JsonParser arg) {
    return arg != null ? new JsonParser(arg) : null;
  }
}
