/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.axle.core;

import java.util.Map;
import org.reactivestreams.Publisher;
import java.util.function.Consumer;
import java.util.concurrent.CompletionStage;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Represents the writable side of an action that may, or may not, have occurred yet.
 * <p>
 * The {@link io.vertx.axle.core.Promise#future} method returns the {@link io.vertx.axle.core.Future} associated with a promise, the future
 * can be used for getting notified of the promise completion and retrieve its value.
 * <p>
 * A promise extends <code>Handler<AsyncResult<T>></code> so it can be used as a callback.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.Promise original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.axle.Gen(io.vertx.core.Promise.class)
public class Promise<T> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Promise that = (Promise) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.axle.TypeArg<Promise> __TYPE_ARG = new io.vertx.lang.axle.TypeArg<>(    obj -> new Promise((io.vertx.core.Promise) obj),
    Promise::getDelegate
  );

  private final io.vertx.core.Promise<T> delegate;
  public final io.vertx.lang.axle.TypeArg<T> __typeArg_0;
  
  public Promise(io.vertx.core.Promise delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.vertx.lang.axle.TypeArg.unknown();  }

  public Promise(io.vertx.core.Promise delegate, io.vertx.lang.axle.TypeArg<T> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  Promise() {    this.delegate = null;
    this.__typeArg_0 = io.vertx.lang.axle.TypeArg.unknown();  }

  public io.vertx.core.Promise getDelegate() {
    return delegate;
  }

  /**
   * Create a promise that hasn't completed yet
   * @return the promise
   */
  public static <T> io.vertx.axle.core.Promise<T> promise() { 
    io.vertx.axle.core.Promise<T> ret = io.vertx.axle.core.Promise.newInstance(io.vertx.core.Promise.promise(), io.vertx.lang.axle.TypeArg.unknown());
    return ret;
  }

  /**
   * Set the result. Any handler will be called, if there is one, and the promise will be marked as completed.
   * <p/>
   * Any handler set on the associated promise will be called.
   * @param result the result
   */
  public void complete(T result) { 
    delegate.complete(__typeArg_0.<T>unwrap(result));
  }

  /**
   * Calls <code>complete(null)</code>
   */
  public void complete() { 
    delegate.complete();
  }

  /**
   * Set the failure. Any handler will be called, if there is one, and the future will be marked as completed.
   * @param cause the failure cause
   */
  public void fail(Throwable cause) { 
    delegate.fail(cause);
  }

  /**
   * Calls {@link io.vertx.axle.core.Promise#fail} with the <code>message</code>.
   * @param message the failure message
   */
  public void fail(String message) { 
    delegate.fail(message);
  }

  /**
   * Like {@link io.vertx.axle.core.Promise#complete} but returns <code>false</code> when the promise is already completed instead of throwing
   * an {@link java.lang.IllegalStateException}, it returns <code>true</code> otherwise.
   * @param result the result
   * @return <code>false</code> when the future is already completed
   */
  public boolean tryComplete(T result) { 
    boolean ret = delegate.tryComplete(__typeArg_0.<T>unwrap(result));
    return ret;
  }

  /**
   * Calls <code>tryComplete(null)</code>.
   * @return <code>false</code> when the future is already completed
   */
  public boolean tryComplete() { 
    boolean ret = delegate.tryComplete();
    return ret;
  }

  /**
   * Like {@link io.vertx.axle.core.Promise#fail} but returns <code>false</code> when the promise is already completed instead of throwing
   * an {@link java.lang.IllegalStateException}, it returns <code>true</code> otherwise.
   * @param cause the failure cause
   * @return <code>false</code> when the future is already completed
   */
  public boolean tryFail(Throwable cause) { 
    boolean ret = delegate.tryFail(cause);
    return ret;
  }

  /**
   * Calls {@link io.vertx.axle.core.Promise#fail} with the <code>message</code>.
   * @param message the failure message
   * @return false when the future is already completed
   */
  public boolean tryFail(String message) { 
    boolean ret = delegate.tryFail(message);
    return ret;
  }

  /**
   * @return the {@link io.vertx.axle.core.Future} associated with this promise, it can be used to be aware of the promise completion
   */
  public io.vertx.axle.core.Future<T> future() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.axle.core.Future<T> ret = io.vertx.axle.core.Future.newInstance(delegate.future(), __typeArg_0);
    cached_0 = ret;
    return ret;
  }

  private io.vertx.axle.core.Future<T> cached_0;

  public static <T>Promise<T> newInstance(io.vertx.core.Promise arg) {
    return arg != null ? new Promise<T>(arg) : null;
  }

  public static <T>Promise<T> newInstance(io.vertx.core.Promise arg, io.vertx.lang.axle.TypeArg<T> __typeArg_T) {
    return arg != null ? new Promise<T>(arg, __typeArg_T) : null;
  }
}
