/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.axle.core.http;

import java.util.Map;
import org.reactivestreams.Publisher;
import java.util.function.Consumer;
import java.util.concurrent.CompletionStage;
import javax.net.ssl.SSLSession;
import io.vertx.core.http.GoAway;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Represents an HTTP connection.
 * <p/>
 * HTTP/1.x connection provides an limited implementation, the following methods are implemented:
 * <ul>
 *   <li>{@link io.vertx.axle.core.http.HttpConnection#close}</li>
 *   <li>{@link io.vertx.axle.core.http.HttpConnection#closeHandler}</li>
 *   <li>{@link io.vertx.axle.core.http.HttpConnection#exceptionHandler}</li>
 * </ul>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.HttpConnection original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.axle.Gen(io.vertx.core.http.HttpConnection.class)
public class HttpConnection {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpConnection that = (HttpConnection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.axle.TypeArg<HttpConnection> __TYPE_ARG = new io.vertx.lang.axle.TypeArg<>(    obj -> new HttpConnection((io.vertx.core.http.HttpConnection) obj),
    HttpConnection::getDelegate
  );

  private final io.vertx.core.http.HttpConnection delegate;
  
  public HttpConnection(io.vertx.core.http.HttpConnection delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  HttpConnection() {    this.delegate = null;
  }

  public io.vertx.core.http.HttpConnection getDelegate() {
    return delegate;
  }

  /**
   * @return the current connection window size or <code>-1</code> for HTTP/1.x
   */
  public int getWindowSize() { 
    int ret = delegate.getWindowSize();
    return ret;
  }

  /**
   * Update the current connection wide window size to a new size.
   * <p/>
   * Increasing this value, gives better performance when several data streams are multiplexed
   * <p/>
   * This is not implemented for HTTP/1.x.
   * @param windowSize the new window size
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.axle.core.http.HttpConnection setWindowSize(int windowSize) { 
    delegate.setWindowSize(windowSize);
    return this;
  }

  /**
   * Like {@link io.vertx.axle.core.http.HttpConnection#goAway} with a last stream id <code>-1</code> which means to disallow any new stream creation.
   * @param errorCode 
   * @return 
   */
  public io.vertx.axle.core.http.HttpConnection goAway(long errorCode) { 
    delegate.goAway(errorCode);
    return this;
  }

  /**
   * Like {@link io.vertx.axle.core.http.HttpConnection#goAway} with no buffer.
   * @param errorCode 
   * @param lastStreamId 
   * @return 
   */
  public io.vertx.axle.core.http.HttpConnection goAway(long errorCode, int lastStreamId) { 
    delegate.goAway(errorCode, lastStreamId);
    return this;
  }

  /**
   * Send a go away frame to the remote endpoint of the connection.
   * <p/>
   * <ul>
   *   <li>a  frame is sent to the to the remote endpoint with the <code>errorCode</code> and <code>debugData</code></li>
   *   <li>any stream created after the stream identified by <code>lastStreamId</code> will be closed</li>
   *   <li>for an  is different than <code>0</code> when all the remaining streams are closed this connection will be closed automatically</li>
   * </ul>
   * <p/>
   * This is not implemented for HTTP/1.x.
   * @param errorCode the  error code
   * @param lastStreamId the last stream id
   * @param debugData additional debug data sent to the remote endpoint
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.axle.core.http.HttpConnection goAway(long errorCode, int lastStreamId, io.vertx.axle.core.buffer.Buffer debugData) { 
    delegate.goAway(errorCode, lastStreamId, debugData.getDelegate());
    return this;
  }

  /**
   * Set an handler called when a  frame is received.
   * <p/>
   * This is not implemented for HTTP/1.x.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.axle.core.http.HttpConnection __goAwayHandler(Handler<GoAway> handler) { 
    delegate.goAwayHandler(handler);
    return this;
  }

  /**
   * Set an handler called when a  frame is received.
   * <p/>
   * This is not implemented for HTTP/1.x.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.axle.core.http.HttpConnection goAwayHandler(Consumer<GoAway> handler) {
    return __goAwayHandler(handler != null ? handler::accept : null);
  }

  /**
   * Set an handler called when a  frame has been sent or received and all connections are closed.
   * <p/>
   * This is not implemented for HTTP/1.x.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.axle.core.http.HttpConnection __shutdownHandler(Handler<Void> handler) { 
    delegate.shutdownHandler(handler);
    return this;
  }

  /**
   * Set an handler called when a  frame has been sent or received and all connections are closed.
   * <p/>
   * This is not implemented for HTTP/1.x.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.axle.core.http.HttpConnection shutdownHandler(Consumer<Void> handler) {
    return __shutdownHandler(handler != null ? handler::accept : null);
  }

  /**
   * Initiate a graceful connection shutdown, the connection is taken out of service and closed when all current requests
   * are processed, otherwise after 30 seconds the connection will be closed. Client connection are immediately removed
   * from the pool.
   *
   * <ul>
   *   <li>HTTP/2 connections will send a go away frame immediately to signal the other side the connection will close</li>
   *   <li>HTTP/1.x client connection supports this feature</li>
   *   <li>HTTP/1.x server connections do not support this feature</li>
   * </ul>
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.axle.core.http.HttpConnection shutdown() { 
    delegate.shutdown();
    return this;
  }

  /**
   * Like {@link io.vertx.axle.core.http.HttpConnection#shutdown} but with a configurable timeout value.
   * @param timeoutMs the timeout in milliseconds
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.axle.core.http.HttpConnection shutdown(long timeoutMs) { 
    delegate.shutdown(timeoutMs);
    return this;
  }

  /**
   * Set a close handler. The handler will get notified when the connection is closed.
   * @param handler the handler to be notified
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.axle.core.http.HttpConnection __closeHandler(Handler<Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * Set a close handler. The handler will get notified when the connection is closed.
   * @param handler the handler to be notified
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.axle.core.http.HttpConnection closeHandler(Consumer<Void> handler) {
    return __closeHandler(handler != null ? handler::accept : null);
  }

  /**
   * Close the connection and all the currently active streams.
   * <p/>
   * An HTTP/2 connection will send a  frame before.
   */
  public void close() { 
    delegate.close();
  }

  /**
   * @return the latest server settings acknowledged by the remote endpoint - this is not implemented for HTTP/1.x
   */
  public Http2Settings settings() { 
    Http2Settings ret = delegate.settings();
    return ret;
  }

  /**
   * Send to the remote endpoint an update of this endpoint settings
   * <p/>
   * The <code>completionHandler</code> will be notified when the remote endpoint has acknowledged the settings.
   * <p/>
   * This is not implemented for HTTP/1.x.
   * @param settings the new settings
   * @param completionHandler the handler notified when the settings have been acknowledged by the remote endpoint
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.axle.core.http.HttpConnection __updateSettings(Http2Settings settings, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.updateSettings(settings, completionHandler);
    return this;
  }

  /**
   * Send to the remote endpoint an update of this endpoint settings
   * <p/>
   * The <code>completionHandler</code> will be notified when the remote endpoint has acknowledged the settings.
   * <p/>
   * This is not implemented for HTTP/1.x.
   * @param settings the new settings
   * @return a reference to this, so the API can be used fluently
   */
  public CompletionStage<Void> updateSettings(Http2Settings settings) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __updateSettings(settings, handler);
    });
  }

  /**
   * @return the current remote endpoint settings for this connection - this is not implemented for HTTP/1.x
   */
  public Http2Settings remoteSettings() { 
    Http2Settings ret = delegate.remoteSettings();
    return ret;
  }

  /**
   * Set an handler that is called when remote endpoint {@link io.vertx.core.http.Http2Settings} are updated.
   * <p/>
   * This is not implemented for HTTP/1.x.
   * @param handler the handler for remote endpoint settings
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.axle.core.http.HttpConnection __remoteSettingsHandler(Handler<Http2Settings> handler) { 
    delegate.remoteSettingsHandler(handler);
    return this;
  }

  /**
   * Set an handler that is called when remote endpoint {@link io.vertx.core.http.Http2Settings} are updated.
   * <p/>
   * This is not implemented for HTTP/1.x.
   * @param handler the handler for remote endpoint settings
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.axle.core.http.HttpConnection remoteSettingsHandler(Consumer<Http2Settings> handler) {
    return __remoteSettingsHandler(handler != null ? handler::accept : null);
  }

  /**
   * Send a  frame to the remote endpoint.
   * <p/>
   * This is not implemented for HTTP/1.x.
   * @param data the 8 bytes data of the frame
   * @param pongHandler an async result handler notified with pong reply or the failure
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.axle.core.http.HttpConnection __ping(io.vertx.axle.core.buffer.Buffer data, Handler<AsyncResult<io.vertx.axle.core.buffer.Buffer>> pongHandler) { 
    delegate.ping(data.getDelegate(), new Handler<AsyncResult<io.vertx.core.buffer.Buffer>>() {
      public void handle(AsyncResult<io.vertx.core.buffer.Buffer> ar) {
        if (ar.succeeded()) {
          pongHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.axle.core.buffer.Buffer.newInstance(ar.result())));
        } else {
          pongHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Send a  frame to the remote endpoint.
   * <p/>
   * This is not implemented for HTTP/1.x.
   * @param data the 8 bytes data of the frame
   * @return a reference to this, so the API can be used fluently
   */
  public CompletionStage<io.vertx.axle.core.buffer.Buffer> ping(io.vertx.axle.core.buffer.Buffer data) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __ping(data, handler);
    });
  }

  /**
   * Set an handler notified when a  frame is received from the remote endpoint.
   * <p/>
   * This is not implemented for HTTP/1.x.
   * @param handler the handler to be called when a  is received
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.axle.core.http.HttpConnection __pingHandler(Handler<io.vertx.axle.core.buffer.Buffer> handler) { 
    delegate.pingHandler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(io.vertx.axle.core.buffer.Buffer.newInstance(event));
      }
    });
    return this;
  }

  /**
   * Set an handler notified when a  frame is received from the remote endpoint.
   * <p/>
   * This is not implemented for HTTP/1.x.
   * @param handler the handler to be called when a  is received
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.axle.core.http.HttpConnection pingHandler(Consumer<io.vertx.axle.core.buffer.Buffer> handler) {
    return __pingHandler(handler != null ? handler::accept : null);
  }

  /**
   * Set an handler called when a connection error happens
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.axle.core.http.HttpConnection __exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * Set an handler called when a connection error happens
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.axle.core.http.HttpConnection exceptionHandler(Consumer<Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  /**
   * @return the remote address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket)
   */
  public io.vertx.axle.core.net.SocketAddress remoteAddress() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.axle.core.net.SocketAddress ret = io.vertx.axle.core.net.SocketAddress.newInstance(delegate.remoteAddress());
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the local address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket)
   */
  public io.vertx.axle.core.net.SocketAddress localAddress() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.axle.core.net.SocketAddress ret = io.vertx.axle.core.net.SocketAddress.newInstance(delegate.localAddress());
    cached_1 = ret;
    return ret;
  }

  /**
   * @return true if this {@link io.vertx.axle.core.http.HttpConnection} is encrypted via SSL/TLS.
   */
  public boolean isSsl() { 
    boolean ret = delegate.isSsl();
    return ret;
  }

  /**
   * Returns the SNI server name presented during the SSL handshake by the client.
   * @return the indicated server name
   */
  public String indicatedServerName() { 
    String ret = delegate.indicatedServerName();
    return ret;
  }

  /**
   * @return SSLSession associated with the underlying socket. Returns null if connection is not SSL.
   */
  public SSLSession sslSession() { 
    SSLSession ret = delegate.sslSession();
    return ret;
  }

  private io.vertx.axle.core.net.SocketAddress cached_0;
  private io.vertx.axle.core.net.SocketAddress cached_1;

  public static  HttpConnection newInstance(io.vertx.core.http.HttpConnection arg) {
    return arg != null ? new HttpConnection(arg) : null;
  }
}
