/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.axle.core.net;

import java.util.Map;
import org.reactivestreams.Publisher;
import java.util.function.Consumer;
import java.util.concurrent.CompletionStage;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Represents a TCP server
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.net.NetServer original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.axle.Gen(io.vertx.core.net.NetServer.class)
public class NetServer implements io.vertx.axle.core.metrics.Measured {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NetServer that = (NetServer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.axle.TypeArg<NetServer> __TYPE_ARG = new io.vertx.lang.axle.TypeArg<>(    obj -> new NetServer((io.vertx.core.net.NetServer) obj),
    NetServer::getDelegate
  );

  private final io.vertx.core.net.NetServer delegate;
  
  public NetServer(io.vertx.core.net.NetServer delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  NetServer() {    this.delegate = null;
  }

  public io.vertx.core.net.NetServer getDelegate() {
    return delegate;
  }

  /**
   * Whether the metrics are enabled for this measured object
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Return the connect stream for this server. The server can only have at most one handler at any one time.
   * As the server accepts TCP or SSL connections it creates an instance of {@link io.vertx.axle.core.net.NetSocket} and passes it to the
   * connect stream .
   * @return the connect stream
   */
  public io.vertx.axle.core.streams.ReadStream<io.vertx.axle.core.net.NetSocket> connectStream() { 
    io.vertx.axle.core.streams.ReadStream<io.vertx.axle.core.net.NetSocket> ret = io.vertx.axle.core.streams.ReadStream.newInstance(delegate.connectStream(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Supply a connect handler for this server. The server can only have at most one connect handler at any one time.
   * As the server accepts TCP or SSL connections it creates an instance of {@link io.vertx.axle.core.net.NetSocket} and passes it to the
   * connect handler.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.axle.core.net.NetServer __connectHandler(Handler<io.vertx.axle.core.net.NetSocket> handler) { 
    io.vertx.axle.core.net.NetServer ret = io.vertx.axle.core.net.NetServer.newInstance(delegate.connectHandler(new Handler<io.vertx.core.net.NetSocket>() {
      public void handle(io.vertx.core.net.NetSocket event) {
        handler.handle(io.vertx.axle.core.net.NetSocket.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * Supply a connect handler for this server. The server can only have at most one connect handler at any one time.
   * As the server accepts TCP or SSL connections it creates an instance of {@link io.vertx.axle.core.net.NetSocket} and passes it to the
   * connect handler.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.axle.core.net.NetServer connectHandler(Consumer<io.vertx.axle.core.net.NetSocket> handler) {
    return __connectHandler(handler != null ? handler::accept : null);
  }

  /**
   * Like {@link io.vertx.axle.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param listenHandler handler that will be notified when listening or failed
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.axle.core.net.NetServer __listen(Handler<AsyncResult<io.vertx.axle.core.net.NetServer>> listenHandler) { 
    delegate.listen(new Handler<AsyncResult<io.vertx.core.net.NetServer>>() {
      public void handle(AsyncResult<io.vertx.core.net.NetServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.axle.core.net.NetServer.newInstance(ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.axle.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @return a reference to this, so the API can be used fluently
   */
  public CompletionStage<io.vertx.axle.core.net.NetServer> listen() { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __listen(handler);
    });
  }

  /**
   * Like {@link io.vertx.axle.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param port the port to listen on
   * @param host the host to listen on
   * @param listenHandler handler that will be notified when listening or failed
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.axle.core.net.NetServer __listen(int port, String host, Handler<AsyncResult<io.vertx.axle.core.net.NetServer>> listenHandler) { 
    delegate.listen(port, host, new Handler<AsyncResult<io.vertx.core.net.NetServer>>() {
      public void handle(AsyncResult<io.vertx.core.net.NetServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.axle.core.net.NetServer.newInstance(ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.axle.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param port the port to listen on
   * @param host the host to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public CompletionStage<io.vertx.axle.core.net.NetServer> listen(int port, String host) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __listen(port, host, handler);
    });
  }

  /**
   * Like {@link io.vertx.axle.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param port the port to listen on
   * @param listenHandler handler that will be notified when listening or failed
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.axle.core.net.NetServer __listen(int port, Handler<AsyncResult<io.vertx.axle.core.net.NetServer>> listenHandler) { 
    delegate.listen(port, new Handler<AsyncResult<io.vertx.core.net.NetServer>>() {
      public void handle(AsyncResult<io.vertx.core.net.NetServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.axle.core.net.NetServer.newInstance(ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.axle.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param port the port to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public CompletionStage<io.vertx.axle.core.net.NetServer> listen(int port) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __listen(port, handler);
    });
  }

  /**
   * Like {@link io.vertx.axle.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param localAddress the local address to listen on
   * @param listenHandler handler that will be notified when listening or failed
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.axle.core.net.NetServer __listen(io.vertx.axle.core.net.SocketAddress localAddress, Handler<AsyncResult<io.vertx.axle.core.net.NetServer>> listenHandler) { 
    delegate.listen(localAddress.getDelegate(), new Handler<AsyncResult<io.vertx.core.net.NetServer>>() {
      public void handle(AsyncResult<io.vertx.core.net.NetServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.axle.core.net.NetServer.newInstance(ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.axle.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param localAddress the local address to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public CompletionStage<io.vertx.axle.core.net.NetServer> listen(io.vertx.axle.core.net.SocketAddress localAddress) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __listen(localAddress, handler);
    });
  }

  /**
   * Like {@link io.vertx.axle.core.net.NetServer#close} but supplying a handler that will be notified when close is complete.
   * @param completionHandler the handler
   */
  private void __close(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.close(completionHandler);
  }

  /**
   * Like {@link io.vertx.axle.core.net.NetServer#close} but supplying a handler that will be notified when close is complete.
   * @return 
   */
  public CompletionStage<Void> close() { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __close(handler);
    });
  }

  /**
   * The actual port the server is listening on. This is useful if you bound the server specifying 0 as port number
   * signifying an ephemeral port
   * @return the actual port the server is listening on.
   */
  public int actualPort() { 
    int ret = delegate.actualPort();
    return ret;
  }

  private static final io.vertx.lang.axle.TypeArg<io.vertx.axle.core.net.NetSocket> TYPE_ARG_0 = new io.vertx.lang.axle.TypeArg<io.vertx.axle.core.net.NetSocket>(o1 -> io.vertx.axle.core.net.NetSocket.newInstance((io.vertx.core.net.NetSocket)o1), o1 -> o1.getDelegate());

  public static  NetServer newInstance(io.vertx.core.net.NetServer arg) {
    return arg != null ? new NetServer(arg) : null;
  }
}
