/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.axle;

import io.vertx.codegen.ClassModel;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.TypeParamInfo;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.TypeReflectionFactory;
import io.vertx.lang.axle.AbstractAxleGenerator;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;

class AxleGenerator
extends AbstractAxleGenerator {
    AxleGenerator() {
        super("axle");
        this.kinds = Collections.singleton("class");
        this.name = "Axle";
    }

    @Override
    protected void genRxImports(ClassModel model, PrintWriter writer) {
        writer.println("import org.reactivestreams.Publisher;");
        writer.println("import io.reactivex.Flowable;");
        writer.println("import java.util.function.Consumer;");
        writer.println("import java.util.concurrent.CompletionStage;");
        super.genRxImports(model, writer);
    }

    @Override
    protected void genToObservable(TypeInfo streamType, PrintWriter writer) {
        writer.print("  private org.reactivestreams.Publisher<");
        writer.print(this.genTypeName(streamType));
        writer.println("> publisher;");
        writer.println();
        this.genToXXXAble(streamType, "Publisher", "publisher", writer);
        this.generateToPublisherBuilderMethod(streamType, "Publisher", "publisher", writer);
    }

    private void genToXXXAble(TypeInfo streamType, String rxType, String rxName, PrintWriter writer) {
        writer.print("  public synchronized org.reactivestreams.");
        writer.print(rxType);
        writer.print("<");
        writer.print(this.genTypeName(streamType));
        writer.println("> toPublisher() {");
        writer.print("    ");
        writer.print("if (");
        writer.print(rxName);
        writer.println(" == null) {");
        if (streamType.getKind() == ClassKind.API) {
            writer.print("      java.util.function.Function<");
            writer.print(streamType.getName());
            writer.print(", ");
            writer.print(this.genTypeName(streamType));
            writer.print("> conv = ");
            writer.print(this.genTypeName((TypeInfo)streamType.getRaw()));
            writer.println("::newInstance;");
            writer.print("      ");
            writer.print(rxName);
            writer.print(" = io.vertx.axle.");
            writer.print(rxType);
            writer.print("Helper.to");
            writer.print(rxType);
            writer.println("(delegate, conv);");
        } else if (streamType.isVariable()) {
            String typeVar = streamType.getSimpleName();
            writer.print("      java.util.function.Function<");
            writer.print(typeVar);
            writer.print(", ");
            writer.print(typeVar);
            writer.print("> conv = (java.util.function.Function<");
            writer.print(typeVar);
            writer.print(", ");
            writer.print(typeVar);
            writer.println(">) __typeArg_0.wrap;");
            writer.print("      ");
            writer.print(rxName);
            writer.print(" = io.vertx.axle.");
            writer.print(rxType);
            writer.print("Helper.to");
            writer.print(rxType);
            writer.println("(delegate, conv);");
        } else {
            writer.print("      ");
            writer.print(rxName);
            writer.print(" = io.vertx.axle.");
            writer.print(rxType);
            writer.print("Helper.to");
            writer.print(rxType);
            writer.println("(this.getDelegate());");
        }
        writer.println("    }");
        writer.print("    return ");
        writer.print(rxName);
        writer.println(";");
        writer.println("  }");
        writer.println();
    }

    private void generateToPublisherBuilderMethod(TypeInfo streamType, String rxType, String rxName, PrintWriter writer) {
        writer.print("  public synchronized org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder");
        writer.print("<");
        writer.print(this.genTypeName(streamType));
        writer.println("> toPublisherBuilder() {");
        writer.print("    ");
        writer.print("if (");
        writer.print(rxName);
        writer.println(" == null) {");
        if (streamType.getKind() == ClassKind.API) {
            writer.print("      java.util.function.Function<");
            writer.print(streamType.getName());
            writer.print(", ");
            writer.print(this.genTypeName(streamType));
            writer.print("> conv = ");
            writer.print(this.genTypeName((TypeInfo)streamType.getRaw()));
            writer.println("::newInstance;");
            writer.print("      ");
            writer.print(rxName);
            writer.print(" = io.vertx.axle.");
            writer.print(rxType);
            writer.print("Helper.to");
            writer.print(rxType);
            writer.println("(delegate, conv);");
        } else if (streamType.isVariable()) {
            String typeVar = streamType.getSimpleName();
            writer.print("      java.util.function.Function<");
            writer.print(typeVar);
            writer.print(", ");
            writer.print(typeVar);
            writer.print("> conv = (java.util.function.Function<");
            writer.print(typeVar);
            writer.print(", ");
            writer.print(typeVar);
            writer.println(">) __typeArg_0.wrap;");
            writer.print("      ");
            writer.print(rxName);
            writer.print(" = io.vertx.axle.");
            writer.print(rxType);
            writer.print("Helper.to");
            writer.print(rxType);
            writer.println("(delegate, conv);");
        } else {
            writer.print("      ");
            writer.print(rxName);
            writer.print(" = io.vertx.axle.");
            writer.print(rxType);
            writer.print("Helper.to");
            writer.print(rxType);
            writer.println("(this.getDelegate());");
        }
        writer.println("    }");
        writer.println("    return org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams.fromPublisher(" + rxName + ");");
        writer.println("  }");
        writer.println();
    }

    private void genToXXXEr(TypeInfo streamType, String rxType, String rxName, PrintWriter writer) {
        writer.format("  public synchronized io.vertx.reactivex.WriteStream%s<%s> to%s() {%n", rxType, this.genTypeName(streamType), rxType);
        writer.format("    if (%s == null) {%n", rxName);
        if (streamType.getKind() == ClassKind.API) {
            writer.format("      java.util.function.Function<%s, %s> conv = %s::getDelegate;%n", this.genTypeName((TypeInfo)streamType.getRaw()), streamType.getName(), this.genTypeName(streamType));
            writer.format("      %s = io.vertx.axle.RxHelper.to%s(getDelegate(), conv);%n", rxName, rxType);
        } else if (streamType.isVariable()) {
            String typeVar = streamType.getSimpleName();
            writer.format("      java.util.function.Function<%s, %s> conv = (java.util.function.Function<%s, %s>) __typeArg_0.unwrap;%n", typeVar, typeVar, typeVar, typeVar);
            writer.format("      %s = io.vertx.axle.RxHelper.to%s(getDelegate(), conv);%n", rxName, rxType);
        } else {
            writer.format("      %s = io.vertx.axle.RxHelper.to%s(getDelegate());%n", rxName, rxType);
        }
        writer.println("    }");
        writer.format("    return %s;%n", rxName);
        writer.println("  }");
        writer.println();
    }

    @Override
    protected void genMethods(ClassModel model, MethodInfo method, List<String> cacheDecls, PrintWriter writer) {
        this.genMethod(model, method, cacheDecls, writer);
        MethodInfo publisherOverload = this.genOverloadedMethod(method, Publisher.class);
        if (publisherOverload != null) {
            this.genMethod(model, publisherOverload, cacheDecls, writer);
        }
    }

    @Override
    protected void genConsumerMethod(boolean decl, ClassModel model, MethodInfo method, PrintWriter writer) {
        MethodInfo futMethod = this.genConsumerMethod(method);
        this.startMethodTemplate(false, futMethod.getName(), futMethod, "", writer);
        if (decl) {
            writer.println(";");
            return;
        }
        writer.println(" {");
        writer.print("    ");
        if (!method.getReturnType().isVoid()) {
            writer.print("return ");
        }
        writer.print("__" + method.getName() + "(");
        List params = futMethod.getParams();
        for (int i = 0; i < params.size(); ++i) {
            if (i > 0) {
                writer.print(", ");
            }
            ParamInfo param = (ParamInfo)params.get(i);
            if (i < params.size() - 1) {
                writer.print(param.getName());
                continue;
            }
            writer.print(param.getName() + " != null ? " + param.getName() + "::accept : null");
        }
        writer.println(");");
        writer.println("  }");
        writer.println();
    }

    @Override
    protected void genCSMethod(boolean decl, ClassModel model, MethodInfo method, PrintWriter writer) {
        MethodInfo futMethod = this.genCSMethod(method);
        ClassTypeInfo raw = futMethod.getReturnType().getRaw();
        String methodSimpleName = raw.getSimpleName();
        String adapterType = "io.vertx.axle.AsyncResult" + methodSimpleName + ".to" + methodSimpleName;
        this.startMethodTemplate(false, futMethod.getName(), futMethod, "", writer);
        if (decl) {
            writer.println(";");
            return;
        }
        writer.println(" { ");
        writer.print("    return ");
        writer.print(adapterType);
        writer.println("(handler -> {");
        writer.print("      __");
        writer.print(method.getName());
        writer.print("(");
        List params = futMethod.getParams();
        writer.print(params.stream().map(ParamInfo::getName).collect(Collectors.joining(", ")));
        if (params.size() > 0) {
            writer.print(", ");
        }
        writer.println("handler);");
        writer.println("    });");
        writer.println("  }");
        writer.println();
    }

    @Override
    protected void genReadStream(List<? extends TypeParamInfo> typeParams, PrintWriter writer) {
        writer.print("  org.reactivestreams.Publisher<");
        writer.print(typeParams.get(0).getName());
        writer.println("> toPublisher();");
        writer.println();
    }

    @Override
    public MethodInfo genConsumerMethod(MethodInfo method) {
        ArrayList<ParamInfo> futParams = new ArrayList<ParamInfo>();
        int size = method.getParams().size() - 1;
        for (int count = 0; count < size; ++count) {
            ParamInfo param = method.getParam(count);
            futParams.add(param);
        }
        ParamInfo futParam = method.getParam(size);
        TypeInfo consumerType = ((ParameterizedTypeInfo)futParam.getType()).getArg(0);
        TypeInfo consumerUnresolvedType = ((ParameterizedTypeInfo)futParam.getUnresolvedType()).getArg(0);
        ParameterizedTypeInfo consumerReturnType = new ParameterizedTypeInfo(TypeReflectionFactory.create(Consumer.class).getRaw(), consumerUnresolvedType.isNullable(), Collections.singletonList(consumerType));
        futParams.add(new ParamInfo(futParams.size(), futParam.getName(), futParam.getDescription(), (TypeInfo)consumerReturnType));
        return method.copy().setParams(futParams);
    }

    private MethodInfo genCSMethod(MethodInfo method) {
        ArrayList<ParamInfo> futParams = new ArrayList<ParamInfo>();
        int size = method.getParams().size() - 1;
        for (int count = 0; count < size; ++count) {
            ParamInfo param = method.getParam(count);
            futParams.add(param);
        }
        ParamInfo futParam = method.getParam(size);
        TypeInfo futType = ((ParameterizedTypeInfo)((ParameterizedTypeInfo)futParam.getType()).getArg(0)).getArg(0);
        TypeInfo futUnresolvedType = ((ParameterizedTypeInfo)((ParameterizedTypeInfo)futParam.getUnresolvedType()).getArg(0)).getArg(0);
        ParameterizedTypeInfo futReturnType = new ParameterizedTypeInfo(TypeReflectionFactory.create(CompletionStage.class).getRaw(), futUnresolvedType.isNullable(), Collections.singletonList(futType));
        return method.copy().setReturnType((TypeInfo)futReturnType).setParams(futParams);
    }

    private MethodInfo genOverloadedMethod(MethodInfo method, Class streamType) {
        ArrayList<ParamInfo> params = null;
        int count = 0;
        for (ParamInfo param : method.getParams()) {
            if (param.getType().isParameterized() && param.getType().getRaw().getName().equals("io.vertx.core.streams.ReadStream")) {
                if (params == null) {
                    params = new ArrayList<ParamInfo>(method.getParams());
                }
                ParameterizedTypeInfo paramType = new ParameterizedTypeInfo(TypeReflectionFactory.create((Type)streamType).getRaw(), false, Collections.singletonList(((ParameterizedTypeInfo)param.getType()).getArg(0)));
                params.set(count, new ParamInfo(param.getIndex(), param.getName(), param.getDescription(), (TypeInfo)paramType));
            }
            ++count;
        }
        if (params != null) {
            return method.copy().setParams(params);
        }
        return null;
    }
}

