package io.vertx.mutiny.core.file;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * A lock on a region of an {@link io.vertx.mutiny.core.file.AsyncFile}.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.file.AsyncFileLock original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.file.AsyncFileLock.class)
public class AsyncFileLock {

  public static final io.smallrye.mutiny.vertx.TypeArg<AsyncFileLock> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new AsyncFileLock((io.vertx.core.file.AsyncFileLock) obj),
    AsyncFileLock::getDelegate
  );

  private final io.vertx.core.file.AsyncFileLock delegate;
  
  public AsyncFileLock(io.vertx.core.file.AsyncFileLock delegate) {
    this.delegate = delegate;
  }

  public AsyncFileLock(Object delegate) {
    this.delegate = (io.vertx.core.file.AsyncFileLock)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  AsyncFileLock() {
    this.delegate = null;
  }

  public io.vertx.core.file.AsyncFileLock getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AsyncFileLock that = (AsyncFileLock) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return the position of the first byte of the locked region
   */
  public long position() { 
    long ret = delegate.position();
    return ret;
  }

  /**
   * @return the size in bytes of the locked region
   */
  public long size() { 
    long ret = delegate.size();
    return ret;
  }

  /**
   * @return <code>true</code> if this lock is shared, otherwise <code>false</code>
   */
  public boolean isShared() { 
    boolean ret = delegate.isShared();
    return ret;
  }

  /**
   * @param position 
   * @param size 
   * @return <code>true</code> if this lock overlaps with the range described by <code>position</code> and <code>size</code>, otherwise <code>false</code>
   */
  public boolean overlaps(long position, long size) { 
    boolean ret = delegate.overlaps(position, size);
    return ret;
  }

  /**
   * @return 
   */
  public boolean isValidBlocking() { 
    boolean ret = delegate.isValidBlocking();
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.core.file.AsyncFileLock#isValid} but the <code>handler</code> will be called when the operation completes or if an error occurs.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Boolean> isValid() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.isValid(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.file.AsyncFileLock#isValid}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Boolean instance produced by the operation.
   */
  public Boolean isValidAndAwait() { 
    return (Boolean) isValid().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.file.AsyncFileLock#isValid} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.file.AsyncFileLock#isValid}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.file.AsyncFileLock#isValid} but you don't need to compose it with other operations.
   */
  public void isValidAndForget() { 
    isValid().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   */
  public void releaseBlocking() { 
    delegate.releaseBlocking();
  }

  /**
   * Like {@link io.vertx.mutiny.core.file.AsyncFileLock#release} but the <code>handler</code> will be called when the operation completes or if an error occurs.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> release() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.release(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.file.AsyncFileLock#release}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void releaseAndAwait() { 
    return (Void) release().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.file.AsyncFileLock#release} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.file.AsyncFileLock#release}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.file.AsyncFileLock#release} but you don't need to compose it with other operations.
   */
  public void releaseAndForget() { 
    release().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  public static  AsyncFileLock newInstance(io.vertx.core.file.AsyncFileLock arg) {
    return arg != null ? new AsyncFileLock(arg) : null;
  }

}
