/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.amqp.tracing;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessageOperation;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingSpanNameExtractor;
import io.smallrye.reactive.messaging.amqp.AmqpMessage;
import io.smallrye.reactive.messaging.amqp.tracing.AmqpAttributesExtractor;
import io.smallrye.reactive.messaging.amqp.tracing.AmqpMessageTextMapGetter;
import io.smallrye.reactive.messaging.amqp.tracing.AmqpMessageTextMapSetter;
import io.smallrye.reactive.messaging.tracing.TracingUtils;
import jakarta.enterprise.inject.Instance;
import org.eclipse.microprofile.reactive.messaging.Message;

public class AmqpOpenTelemetryInstrumenter {
    private final Instrumenter<AmqpMessage<?>, Void> instrumenter;

    private AmqpOpenTelemetryInstrumenter(Instrumenter<AmqpMessage<?>, Void> instrumenter) {
        this.instrumenter = instrumenter;
    }

    public static AmqpOpenTelemetryInstrumenter createForConnector(Instance<OpenTelemetry> openTelemetryInstance) {
        return AmqpOpenTelemetryInstrumenter.create(TracingUtils.getOpenTelemetry(openTelemetryInstance), false);
    }

    public static AmqpOpenTelemetryInstrumenter createForSender(Instance<OpenTelemetry> openTelemetryInstance) {
        return AmqpOpenTelemetryInstrumenter.create(TracingUtils.getOpenTelemetry(openTelemetryInstance), true);
    }

    private static AmqpOpenTelemetryInstrumenter create(OpenTelemetry openTelemetry, boolean sender) {
        MessageOperation messageOperation = sender ? MessageOperation.PUBLISH : MessageOperation.RECEIVE;
        AmqpAttributesExtractor amqpAttributesExtractor = new AmqpAttributesExtractor();
        MessagingAttributesGetter<AmqpMessage<?>, Void> messagingAttributesGetter = amqpAttributesExtractor.getMessagingAttributesGetter();
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.smallrye.reactive.messaging", (SpanNameExtractor)MessagingSpanNameExtractor.create(messagingAttributesGetter, (MessageOperation)messageOperation));
        builder.addAttributesExtractor(MessagingAttributesExtractor.create(messagingAttributesGetter, (MessageOperation)messageOperation)).addAttributesExtractor((AttributesExtractor)amqpAttributesExtractor).buildProducerInstrumenter((TextMapSetter)AmqpMessageTextMapSetter.INSTANCE);
        Instrumenter instrumenter = sender ? builder.buildProducerInstrumenter((TextMapSetter)AmqpMessageTextMapSetter.INSTANCE) : builder.buildConsumerInstrumenter((TextMapGetter)AmqpMessageTextMapGetter.INSTANCE);
        return new AmqpOpenTelemetryInstrumenter(instrumenter);
    }

    public Message<?> traceIncoming(Message<?> m, AmqpMessage<?> trace) {
        return TracingUtils.traceIncoming(this.instrumenter, m, trace);
    }

    public void traceOutgoing(Message<?> msg, AmqpMessage<Object> trace) {
        TracingUtils.traceOutgoing(this.instrumenter, msg, trace);
    }
}

