/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.commit;

import io.smallrye.reactive.messaging.providers.helpers.VertxContext;
import io.vertx.core.Context;
import io.vertx.mutiny.core.Vertx;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.common.errors.InterruptException;

public class ContextHolder {
    protected final Vertx vertx;
    private final int timeout;
    protected volatile io.vertx.mutiny.core.Context context;

    public ContextHolder(Vertx vertx, int defaultTimeout) {
        this.vertx = vertx;
        this.timeout = defaultTimeout;
    }

    public void capture(io.vertx.mutiny.core.Context context) {
        this.context = context;
    }

    public void capture(Context context) {
        this.context = io.vertx.mutiny.core.Context.newInstance((Context)context);
    }

    public io.vertx.mutiny.core.Context getContext() {
        return this.context;
    }

    public int getTimeoutInMillis() {
        return this.timeout;
    }

    public void runOnContext(Runnable runnable) {
        VertxContext.runOnEventLoopContext((Context)this.context.getDelegate(), (Runnable)runnable);
    }

    public <T> T runOnContextAndAwait(Callable<T> action) {
        try {
            return VertxContext.callOnContext((Context)this.context.getDelegate(), action).toCompletableFuture().get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new InterruptException(e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new CompletionException(e);
        }
    }
}

