package io.smallrye.reactive.messaging.i18n;

import java.util.Locale;
import io.smallrye.reactive.messaging.MediatorConfiguration.Consumption;
import java.lang.IllegalStateException;
import java.io.Serializable;
import io.smallrye.reactive.messaging.Shape;
import java.util.Set;
import javax.enterprise.inject.spi.InjectionPoint;
import io.smallrye.reactive.messaging.annotations.Merge.Mode;
import java.lang.String;
import java.lang.reflect.Method;
import io.smallrye.reactive.messaging.WeavingException;
import java.lang.reflect.Type;
import java.lang.RuntimeException;
import java.lang.NullPointerException;
import io.smallrye.reactive.messaging.MediatorConfiguration.Production;
import java.lang.Throwable;
import org.eclipse.microprofile.reactive.messaging.OnOverflow.Strategy;
import java.util.List;
import javax.enterprise.inject.spi.DeploymentException;
import javax.enterprise.inject.spi.DefinitionException;
import java.util.Arrays;
import java.lang.IllegalArgumentException;
import java.util.NoSuchElementException;
import io.smallrye.reactive.messaging.ProcessingException;

/**
 * Warning this class consists of generated code.
 */
public class ProviderExceptions_$bundle implements ProviderExceptions, Serializable {
    private static final long serialVersionUID = 1L;
    protected ProviderExceptions_$bundle() {}
    public static final ProviderExceptions_$bundle INSTANCE = new ProviderExceptions_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String processingException$str() {
        return "%s";
    }
    @Override
    public final ProcessingException processingException(final String methodAsString, final Throwable cause) {
        final ProcessingException result = new ProcessingException(String.format(getLoggingLocale(), processingException$str(), methodAsString), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String illegalArgumentForGenericParameterType$str() {
        return "SRMSG00001: Method %s only has %d so parameter with index %d cannot be retrieved";
    }
    @Override
    public final IllegalArgumentException illegalArgumentForGenericParameterType(final Method method, final int length, final int index) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentForGenericParameterType$str(), method, length, index));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentForAnnotationNullOrBlank$str() {
        return "SRMSG00002: Invalid method annotated with %s: %s - value is blank or null";
    }
    @Override
    public final IllegalArgumentException illegalArgumentForAnnotationNullOrBlank(final String annotation, final String annotationTarget) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentForAnnotationNullOrBlank$str(), annotation, annotationTarget));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalStateExceptionForValidate$str() {
        return "SRMSG00003: Unknown shape: %s";
    }
    @Override
    public final IllegalStateException illegalStateExceptionForValidate(final Shape shape) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateExceptionForValidate$str(), shape));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentForValidateProcessor$str() {
        return "SRMSG00004: Invalid method annotated with @Outgoing and @Incoming %s - one parameter expected";
    }
    @Override
    public final IllegalArgumentException illegalArgumentForValidateProcessor(final String methodAsString) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentForValidateProcessor$str(), methodAsString));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalStateForValidateProcessor$str() {
        return "SRMSG00005: Unsupported acknowledgement policy - POST_PROCESSING not supported when producing messages for %s";
    }
    @Override
    public final IllegalStateException illegalStateForValidateProcessor(final String methodAsString) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateForValidateProcessor$str(), methodAsString));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String definitionExceptionUnsupported$str() {
        return "SRMSG00006: Invalid method annotated with %s: %s - The @Acknowledgment annotation is only supported for method annotated with @Incoming";
    }
    @Override
    public final DefinitionException definitionExceptionUnsupported(final String annotation, final String methodAsString) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), definitionExceptionUnsupported$str(), annotation, methodAsString));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentForUnsupportedShape$str() {
        return "SRMSG00007: Unsupported shape %s for method %s";
    }
    @Override
    public final IllegalArgumentException illegalArgumentForUnsupportedShape(final Shape shape, final String methodAsString) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentForUnsupportedShape$str(), shape, methodAsString));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentForProcessorShape$str() {
        return "SRMSG00008: Expected a Processor shape, received a %s";
    }
    @Override
    public final IllegalArgumentException illegalArgumentForProcessorShape(final Shape shape) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentForProcessorShape$str(), shape));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentForInitialize$str() {
        return "SRMSG00009: Invalid Processor - unsupported signature for %s";
    }
    @Override
    public final IllegalArgumentException illegalArgumentForInitialize(final String methodAsString) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentForInitialize$str(), methodAsString));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentForUnexpectedProduction$str() {
        return "SRMSG00010: Unexpected production type: %s";
    }
    @Override
    public final IllegalArgumentException illegalArgumentForUnexpectedProduction(final Production production) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentForUnexpectedProduction$str(), production));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentForPublisherShape$str() {
        return "SRMSG00011: Expected a Publisher shape, received a %s";
    }
    @Override
    public final IllegalArgumentException illegalArgumentForPublisherShape(final Shape shape) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentForPublisherShape$str(), shape));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentForUnexpectedConsumption$str() {
        return "SRMSG00012: Unexpected consumption type: %s";
    }
    @Override
    public final IllegalArgumentException illegalArgumentForUnexpectedConsumption(final Consumption consumption) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentForUnexpectedConsumption$str(), consumption));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentForSubscriberShape$str() {
        return "SRMSG00013: Expected a Subscriber shape, received a %s";
    }
    @Override
    public final IllegalArgumentException illegalArgumentForSubscriberShape(final Shape shape) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentForSubscriberShape$str(), shape));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String weavingForIncoming$str() {
        return "SRMSG00014: %s";
    }
    @Override
    public final WeavingException weavingForIncoming(final List<String> incoming, final Throwable cause) {
        final WeavingException result = new WeavingException(String.format(getLoggingLocale(), weavingForIncoming$str(), incoming), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalStateExceptionForSubscriberOrSubscriberBuilder$str() {
        return "SRMSG00015: Invalid return type: %s - expected a Subscriber or a SubscriberBuilder";
    }
    @Override
    public final IllegalStateException illegalStateExceptionForSubscriberOrSubscriberBuilder(final String resultClassName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateExceptionForSubscriberOrSubscriberBuilder$str(), resultClassName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String runtimeForFailedWorker$str() {
        return "SRMSG00016: Failed to create Worker for %s";
    }
    @Override
    public final RuntimeException runtimeForFailedWorker(final String workerName) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), runtimeForFailedWorker$str(), workerName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentForFailedWorker$str() {
        return "SRMSG00017: @Blocking referred to invalid worker name.";
    }
    @Override
    public final IllegalArgumentException illegalArgumentForFailedWorker() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentForFailedWorker$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalStateForStream$str() {
        return "SRMSG00018: Unable to find a stream with the name %s, available streams are: %s";
    }
    @Override
    public final IllegalStateException illegalStateForStream(final String name, final Set<String> valid) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateForStream$str(), name, valid));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String incomingNotFoundForEmitter1$str() {
        return "SRMSG00019: Unable to connect an emitter with the channel `%s`";
    }
    @Override
    public final DefinitionException incomingNotFoundForEmitter(final String name) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), incomingNotFoundForEmitter1$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String emitterWithoutChannelAnnotation$str() {
        return "SRMSG00020: Missing @Channel qualifier for + `%s`";
    }
    @Override
    public final DefinitionException emitterWithoutChannelAnnotation(final InjectionPoint injectionPoint) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), emitterWithoutChannelAnnotation$str(), injectionPoint));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentForDefaultBuffer$str() {
        return "SRMSG00021: The default buffer size must be strictly positive";
    }
    @Override
    public final IllegalArgumentException illegalArgumentForDefaultBuffer() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentForDefaultBuffer$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentForBackPressure$str() {
        return "SRMSG00022: Invalid back-pressure strategy: %s";
    }
    @Override
    public final IllegalArgumentException illegalArgumentForBackPressure(final Strategy overFlowStrategy) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentForBackPressure$str(), overFlowStrategy));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentForNullValue$str() {
        return "SRMSG00023: `null` is not a valid value";
    }
    @Override
    public final IllegalArgumentException illegalArgumentForNullValue() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentForNullValue$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String incomingNotFoundForEmitter0$str() {
        return "SRMSG00024: The emitter encountered a failure";
    }
    @Override
    public final IllegalStateException incomingNotFoundForEmitter(final Throwable throwable) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), incomingNotFoundForEmitter0$str()), throwable);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalStateForDownstreamCancel$str() {
        return "SRMSG00025: The downstream has cancelled the consumption";
    }
    @Override
    public final IllegalStateException illegalStateForDownstreamCancel() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateForDownstreamCancel$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalStateForEmitterWhileEmitting$str() {
        return "SRMSG00026: The emitter encountered a failure while emitting";
    }
    @Override
    public final IllegalStateException illegalStateForEmitterWhileEmitting(final Throwable throwable) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateForEmitterWhileEmitting$str()), throwable);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalStateForNoSubscriber$str() {
        return "SRMSG00027: No subscriber found for the channel %s";
    }
    @Override
    public final IllegalStateException illegalStateForNoSubscriber(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateForNoSubscriber$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalStateForCancelledSubscriber$str() {
        return "SRMSG00028: The subscription to %s has been cancelled";
    }
    @Override
    public final IllegalStateException illegalStateForCancelledSubscriber(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateForCancelledSubscriber$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentForException$str() {
        return "SRMSG00029: `%s` is not a valid exception";
    }
    @Override
    public final IllegalArgumentException illegalArgumentForException(final String val) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentForException$str(), val));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentMergePolicy$str() {
        return "SRMSG00030: Unknown merge policy for %s: %s";
    }
    @Override
    public final IllegalArgumentException illegalArgumentMergePolicy(final String source, final Mode mode) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentMergePolicy$str(), source, mode));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalStateForMediatorManagerAlreadyInitialized$str() {
        return "SRMSG00031: MediatorManager was already initialized!";
    }
    @Override
    public final IllegalStateException illegalStateForMediatorManagerAlreadyInitialized() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateForMediatorManagerAlreadyInitialized$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String weavingImposibleToBind$str() {
        return "SRMSG00033: Impossible to bind mediators, some mediators are not connected: %s, available publishers: %s, available emitters: %s";
    }
    @Override
    public final WeavingException weavingImposibleToBind(final List<String> methodsAsString, final Set<String> incomingNames, final Set<String> emitterNames) {
        final WeavingException result = new WeavingException(String.format(getLoggingLocale(), weavingImposibleToBind$str(), methodsAsString, incomingNames, emitterNames));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalStateInsufficientDownstreamRequests$str() {
        return "SRMSG00034: Insufficient downstream requests to emit item";
    }
    @Override
    public final IllegalStateException illegalStateInsufficientDownstreamRequests() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateInsufficientDownstreamRequests$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalStateUnhandledType$str() {
        return "SRMSG00035: found an unhandled type: %s";
    }
    @Override
    public final IllegalStateException illegalStateUnhandledType(final Type type) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateUnhandledType$str(), type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentMissingAssignment$str() {
        return "SRMSG00036: missing assignment type for type variable %s";
    }
    @Override
    public final IllegalArgumentException illegalArgumentMissingAssignment(final Type type) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentMissingAssignment$str(), type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalStateUnexpectedGenericInterface$str() {
        return "SRMSG00037: Unexpected generic interface type found: %s";
    }
    @Override
    public final IllegalStateException illegalStateUnexpectedGenericInterface(final Type type) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateUnexpectedGenericInterface$str(), type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentTypeToString$str() {
        return "SRMSG00038: %s";
    }
    @Override
    public final IllegalArgumentException illegalArgumentTypeToString(final String typeName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentTypeToString$str(), typeName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nameMustBeSet$str() {
        return "SRMSG00039: `name` must be set";
    }
    @Override
    public final IllegalArgumentException nameMustBeSet() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nameMustBeSet$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String validationForNotNull$str() {
        return "SRMSG00040: %s must not be `null`";
    }
    @Override
    public final IllegalArgumentException validationForNotNull(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), validationForNotNull$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String validationForNotEmpty$str() {
        return "SRMSG00041: %s must not be `empty`";
    }
    @Override
    public final IllegalArgumentException validationForNotEmpty(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), validationForNotEmpty$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String validationForContainsNull$str() {
        return "SRMSG00042: %s must not contain a `null` element";
    }
    @Override
    public final IllegalArgumentException validationForContainsNull(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), validationForContainsNull$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String validateIsTrue$str() {
        return "SRMSG00043: %s";
    }
    @Override
    public final IllegalArgumentException validateIsTrue(final String value) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), validateIsTrue$str(), value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentInvalidChannelConfiguration$str() {
        return "SRMSG00044: Invalid channel configuration -  the `channel-name` attribute cannot be used in configuration (channel `%s`)";
    }
    @Override
    public final IllegalArgumentException illegalArgumentInvalidChannelConfiguration(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentInvalidChannelConfiguration$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noSuchElementForAttribute$str() {
        return "SRMSG00045: Cannot find attribute `%s` for channel `%s`. Has been tried: % and %s";
    }
    @Override
    public final NoSuchElementException noSuchElementForAttribute(final String propertyName, final String name, final String channelKey, final String connectorKey) {
        final NoSuchElementException result = new NoSuchElementException(String.format(getLoggingLocale(), noSuchElementForAttribute$str(), propertyName, name, channelKey, connectorKey));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentForAnnotationNonEmpty$str() {
        return "SRMSG00046: %ss must contain a non-empty array of %s";
    }
    @Override
    public final IllegalArgumentException illegalArgumentForAnnotationNonEmpty(final String annotation, final String annotationTarget) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentForAnnotationNonEmpty$str(), annotation, annotationTarget));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String definitionNoParamOnSubscriber$str() {
        return "SRMSG00047: Invalid method annotated with %s: %s - when returning a Subscriber or a SubscriberBuilder, no parameters are expected";
    }
    @Override
    public final DefinitionException definitionNoParamOnSubscriber(final String annotation, final String methodAsString) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), definitionNoParamOnSubscriber$str(), annotation, methodAsString));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String definitionSubscriberTypeParam$str() {
        return "SRMSG00048: Invalid method annotated with %s: %s - the returned Subscriber must declare a type parameter";
    }
    @Override
    public final DefinitionException definitionSubscriberTypeParam(final String annotation, final String methodAsString) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), definitionSubscriberTypeParam$str(), annotation, methodAsString));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String definitionOnParam$str() {
        return "SRMSG00049: Invalid method annotated with %s: %s - when returning a %s, one parameter is expected";
    }
    @Override
    public final DefinitionException definitionOnParam(final String annotation, final String methodAsString, final String returnType) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), definitionOnParam$str(), annotation, methodAsString, returnType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String definitionUnsupportedSignature$str() {
        return "SRMSG00050: Invalid method annotated with %s: %s - Unsupported signature";
    }
    @Override
    public final DefinitionException definitionUnsupportedSignature(final String annotation, final String methodAsString) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), definitionUnsupportedSignature$str(), annotation, methodAsString));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedSynchronousSignature$str() {
        return "SRMSG00051: Invalid method annotated with @Incoming: %s - The signature is not supported. The method consumes a `Message`, so the returned type must be `CompletionStage<Void>` or `Uni<Void>`.";
    }
    @Override
    public final DefinitionException unsupportedSynchronousSignature(final String methodAsString) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), unsupportedSynchronousSignature$str(), methodAsString));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String definitionNotVoid$str() {
        return "SRMSG00052: Invalid method annotated with %s: %s - the method must not be `void`";
    }
    @Override
    public final DefinitionException definitionNotVoid(final String annotation, final String methodAsString) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), definitionNotVoid$str(), annotation, methodAsString));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String definitionNoParametersExpected$str() {
        return "SRMSG00053: Invalid method annotated with %s: %s - no parameters expected";
    }
    @Override
    public final DefinitionException definitionNoParametersExpected(final String annotation, final String methodAsString) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), definitionNoParametersExpected$str(), annotation, methodAsString));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String definitionMustDeclareParam$str() {
        return "SRMSG00054: Invalid method annotated with %s: %s - the returned %s must declare a type parameter";
    }
    @Override
    public final DefinitionException definitionMustDeclareParam(final String annotation, final String methodAsString, final String returnClass) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), definitionMustDeclareParam$str(), annotation, methodAsString, returnClass));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String definitionMustNotHaveParams$str() {
        return "SRMSG00055: Invalid method annotated with %s: %s - the method must not have parameters";
    }
    @Override
    public final DefinitionException definitionMustNotHaveParams(final String annotation, final String methodAsString) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), definitionMustNotHaveParams$str(), annotation, methodAsString));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String definitionExpectedTwoParams$str() {
        return "SRMSG00056: Invalid method annotated with %s: %s - Expected 2 type parameters for the returned Processor";
    }
    @Override
    public final DefinitionException definitionExpectedTwoParams(final String annotation, final String methodAsString) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), definitionExpectedTwoParams$str(), annotation, methodAsString));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String definitionExpectedReturnedParam$str() {
        return "SRMSG00057: Invalid method annotated with %s: %s - Expected a type parameter in the returned %s";
    }
    @Override
    public final DefinitionException definitionExpectedReturnedParam(final String annotation, final String methodAsString, final String returnClass) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), definitionExpectedReturnedParam$str(), annotation, methodAsString, returnClass));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String definitionExpectedConsumedParam$str() {
        return "SRMSG00058: Invalid method annotated with %s: %s - Expected a type parameter for the consumed  %s";
    }
    @Override
    public final DefinitionException definitionExpectedConsumedParam(final String annotation, final String methodAsString, final String returnClass) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), definitionExpectedConsumedParam$str(), annotation, methodAsString, returnClass));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String definitionAutoAckNotSupported$str() {
        return "SRMSG00059: Invalid method annotated with %s: %s - Automatic post-processing acknowledgment is not supported.";
    }
    @Override
    public final DefinitionException definitionAutoAckNotSupported(final String annotation, final String methodAsString) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), definitionAutoAckNotSupported$str(), annotation, methodAsString));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String definitionManualAckNotSupported$str() {
        return "SRMSG00060: Invalid method annotated with %s: %s - Consuming a stream of payload is not supported with MANUAL acknowledgment. Use a Publisher<Message<I>> or PublisherBuilder<Message<I>> instead.";
    }
    @Override
    public final DefinitionException definitionManualAckNotSupported(final String annotation, final String methodAsString) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), definitionManualAckNotSupported$str(), annotation, methodAsString));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String definitionProduceConsume$str() {
        return "SRMSG00061: Invalid method annotated with %s: %s - If the method produces a PublisherBuilder, it needs to consume a PublisherBuilder.";
    }
    @Override
    public final DefinitionException definitionProduceConsume(final String annotation, final String methodAsString) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), definitionProduceConsume$str(), annotation, methodAsString));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String definitionMergeOnlyIncoming$str() {
        return "SRMSG00062: Invalid method annotated with %s: %s - The @Merge annotation is only supported for method annotated with @Incoming";
    }
    @Override
    public final DefinitionException definitionMergeOnlyIncoming(final String annotation, final String methodAsString) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), definitionMergeOnlyIncoming$str(), annotation, methodAsString));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String definitionBroadcastOnlyOutgoing$str() {
        return "SRMSG00063: Invalid method annotated with %s: %s - The @Broadcast annotation is only supported for method annotated with @Outgoing";
    }
    @Override
    public final DefinitionException definitionBroadcastOnlyOutgoing(final String annotation, final String methodAsString) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), definitionBroadcastOnlyOutgoing$str(), annotation, methodAsString));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String definitionBlockingOnlyIndividual$str() {
        return "SRMSG00064: Invalid method annotated with @Blocking: %s - The @Blocking annotation is only supported for methods returning `void` (@Incoming only), a `Message` or a payload";
    }
    @Override
    public final DefinitionException definitionBlockingOnlyIndividual(final String methodAsString) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), definitionBlockingOnlyIndividual$str(), methodAsString));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String definitionBlockingOnlyIndividualParam$str() {
        return "SRMSG00065: Invalid method annotated with @Blocking: %s - The @Blocking annotation is only supported for methods consuming an individual Message or payload like `consume(String s)` or `consume(Message<String> s)";
    }
    @Override
    public final DefinitionException definitionBlockingOnlyIndividualParam(final String methodAsString) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), definitionBlockingOnlyIndividualParam$str(), methodAsString));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalBlockingSignature$str() {
        return "SRMSG00066: Invalid method annotated with @Blocking: %s - no @Incoming or @Outgoing present";
    }
    @Override
    public final IllegalArgumentException illegalBlockingSignature(final String methodAsString) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalBlockingSignature$str(), methodAsString));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentForWorkerConfigKey$str() {
        return "SRMSG00067: Invalid method annotated with %s: %s - %s was not defined";
    }
    @Override
    public final IllegalArgumentException illegalArgumentForWorkerConfigKey(final String annotation, final String annotationTarget, final String workerConfigKey) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentForWorkerConfigKey$str(), annotation, annotationTarget, workerConfigKey));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nullPointerOnInvokeBlocking$str() {
        return "SRMSG00068: The operation %s has returned null";
    }
    @Override
    public final NullPointerException nullPointerOnInvokeBlocking(final String methodAsString) {
        final NullPointerException result = new NullPointerException(String.format(getLoggingLocale(), nullPointerOnInvokeBlocking$str(), methodAsString));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalStateForNotSupported$str() {
        return "SRMSG00069: %s not supported";
    }
    @Override
    public final IllegalStateException illegalStateForNotSupported(final String value) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateForNotSupported$str(), value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String deploymentNoChannel$str() {
        return "SRMSG00070: No channel found for name: %s, injection point: %s";
    }
    @Override
    public final DeploymentException deploymentNoChannel(final String name, final InjectionPoint ip) {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), deploymentNoChannel$str(), name, ip));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentChannelConnectorConfiguration$str() {
        return "SRMSG00071: Invalid channel configuration -  the `connector` attribute must be set for channel `%s`";
    }
    @Override
    public final IllegalArgumentException illegalArgumentChannelConnectorConfiguration(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentChannelConnectorConfiguration$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentUnknownConnector$str() {
        return "SRMSG00072: Unknown connector for `%s`.";
    }
    @Override
    public final IllegalArgumentException illegalArgumentUnknownConnector(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentUnknownConnector$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String deploymentInvalidConfiguration$str() {
        return "SRMSG00073: Invalid configuration, the following channel names cannot be used for both incoming and outgoing: %s";
    }
    @Override
    public final DeploymentException deploymentInvalidConfiguration(final Set<String> sources) {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), deploymentInvalidConfiguration$str(), sources));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalStateRetrieveConfig$str() {
        return "SRMSG00074: Unable to retrieve the config";
    }
    @Override
    public final IllegalStateException illegalStateRetrieveConfig() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateRetrieveConfig$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidEmitterOfMessage$str() {
        return "SRMSG00075: Invalid Emitter injection found for `%s`. Injecting an `Emitter<Message<T>>` is invalid. You can use an `Emitter<T>` to send instances of `T` and `Message<T>`.";
    }
    @Override
    public final DefinitionException invalidEmitterOfMessage(final InjectionPoint ip) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), invalidEmitterOfMessage$str(), ip));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidRawEmitter$str() {
        return "SRMSG00076: Invalid Emitter injection found for  `%s`. The Emitter expected to be parameterized with the emitted type, such as Emitter<String>.";
    }
    @Override
    public final DefinitionException invalidRawEmitter(final InjectionPoint ip) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), invalidRawEmitter$str(), ip));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
