/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.unchecked.Unchecked;
import io.smallrye.reactive.messaging.OutgoingInterceptor;
import io.smallrye.reactive.messaging.OutgoingMessageMetadata;
import io.smallrye.reactive.messaging.SubscriberDecorator;
import io.smallrye.reactive.messaging.providers.helpers.CDIUtils;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.List;
import org.eclipse.microprofile.reactive.messaging.Message;

@ApplicationScoped
public class OutgoingInterceptorDecorator
implements SubscriberDecorator {
    @Any
    @Inject
    Instance<OutgoingInterceptor> interceptors;

    public int getPriority() {
        return 2000;
    }

    public Multi<? extends Message<?>> decorate(Multi<? extends Message<?>> toBeSubscribed, List<String> channelName, boolean isConnector) {
        Multi multi = toBeSubscribed;
        if (isConnector) {
            List<OutgoingInterceptor> matching;
            Instance instances = CDIUtils.getInstanceById(this.interceptors, channelName.get(0));
            if (instances.isUnsatisfied()) {
                instances = this.interceptors.select(new Annotation[0]).select(new Annotation[]{Default.Literal.INSTANCE});
            }
            if (!(matching = CDIUtils.getSortedInstances(instances)).isEmpty()) {
                OutgoingInterceptor interceptor = matching.get(0);
                multi = multi.map(m -> {
                    Message before = interceptor.beforeMessageSend(m.addMetadata((Object)new OutgoingMessageMetadata()));
                    Message withAck = before.withAckWithMetadata(metadata -> before.ack(before.getMetadata()).thenAccept(Unchecked.consumer(x -> interceptor.onMessageAck(before))));
                    return withAck.withNackWithMetadata((throwable, metadata) -> withAck.nack(throwable, metadata).thenAccept(Unchecked.consumer(x -> interceptor.onMessageNack(withAck, throwable))));
                });
            }
        }
        return multi;
    }
}

