/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.pulsar.transactions;

import io.smallrye.reactive.messaging.ChannelRegistry;
import io.smallrye.reactive.messaging.EmitterConfiguration;
import io.smallrye.reactive.messaging.EmitterFactory;
import io.smallrye.reactive.messaging.annotations.EmitterFactoryFor;
import io.smallrye.reactive.messaging.providers.extension.ChannelProducer;
import io.smallrye.reactive.messaging.pulsar.PulsarClientService;
import io.smallrye.reactive.messaging.pulsar.transactions.PulsarTransactions;
import io.smallrye.reactive.messaging.pulsar.transactions.PulsarTransactionsImpl;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import org.eclipse.microprofile.reactive.messaging.Channel;

@EmitterFactoryFor(value=PulsarTransactions.class)
@ApplicationScoped
public class PulsarTransactionsFactory
implements EmitterFactory<PulsarTransactionsImpl<Object>> {
    @Inject
    PulsarClientService pulsarClientService;
    @Inject
    ChannelRegistry channelRegistry;

    public PulsarTransactionsImpl<Object> createEmitter(EmitterConfiguration configuration, long defaultBufferSize) {
        return new PulsarTransactionsImpl<Object>(configuration, defaultBufferSize, this.pulsarClientService);
    }

    @Produces
    @Typed(value={PulsarTransactions.class})
    @Channel(value="")
    <T> PulsarTransactions<T> produceEmitter(InjectionPoint injectionPoint) {
        String channelName = ChannelProducer.getChannelName((InjectionPoint)injectionPoint);
        return (PulsarTransactions)this.channelRegistry.getEmitter(channelName, PulsarTransactions.class);
    }
}

